/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.config.CBCConfigs;

public class ParticleWindHandler {
    private static PerlinNoise BEARING_NOISE = ParticleWindHandler.createNoise(1024L);
    private static PerlinNoise SPEED_NOISE = ParticleWindHandler.createNoise(1026L);
    private static float deltaBearing;
    private static float bearing;
    private static double time;
    private static Vec3 oldWindForce;
    private static Vec3 windForce;

    private static PerlinNoise createNoise(long seed) {
        return PerlinNoise.m_230520_((RandomSource)new LegacyRandomSource(seed), (int)6, (double)1.0, (double[])new double[]{1.0, 0.1, 0.1, 0.1, 0.1});
    }

    public static void refreshNoise(long seed) {
        BEARING_NOISE = ParticleWindHandler.createNoise(seed);
        SPEED_NOISE = ParticleWindHandler.createNoise(seed + 2L);
        time = 0.0;
        ParticleWindHandler.updateWind();
        bearing = 0.0f;
        oldWindForce = windForce;
    }

    public static void updateWind() {
        bearing = Mth.m_14177_((float)(bearing + deltaBearing));
        oldWindForce = windForce;
        float bearingChange = CBCConfigs.client().maxWindBearingChangeSpeed.getF();
        deltaBearing = (float)BEARING_NOISE.m_75408_(time += 5.0E-4, 0.0, 0.0);
        float speed = (float)SPEED_NOISE.m_75408_(0.0, time, 0.0) * 0.5f + 0.5f;
        double rotationRad = (bearing + (deltaBearing *= bearingChange)) * ((float)Math.PI / 180);
        windForce = new Vec3(Math.cos(rotationRad), 0.0, Math.sin(rotationRad)).m_82490_((double)speed);
    }

    public static Vec3 getWindForce(double partialTick) {
        double maximumWindSpeed = (double)CBCConfigs.client().maximumWindSpeed.getF() * 0.05;
        return maximumWindSpeed < 0.01 ? Vec3.f_82478_ : oldWindForce.m_165921_(windForce, partialTick).m_82490_(maximumWindSpeed);
    }

    static {
        oldWindForce = Vec3.f_82478_;
        windForce = Vec3.f_82478_;
    }
}

