/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client;

import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.AbstractLodestoneParticleType;

public class SpiritBasedParticleBuilder
extends WorldParticleBuilder {
    @Nullable
    public MalumSpiritType spiritType;

    public static SpiritBasedParticleBuilder createSpirit(AbstractLodestoneParticleType<?> particle) {
        return SpiritBasedParticleBuilder.createSpirit(particle, null);
    }

    public static SpiritBasedParticleBuilder createSpirit(AbstractLodestoneParticleType<?> particle, LodestoneBehaviorComponent behavior) {
        return SpiritBasedParticleBuilder.createSpirit(new WorldParticleOptions(particle).setBehavior(behavior));
    }

    public static SpiritBasedParticleBuilder createSpirit(RegistryObject<? extends AbstractLodestoneParticleType<?>> particle) {
        return SpiritBasedParticleBuilder.createSpirit(particle, null);
    }

    public static SpiritBasedParticleBuilder createSpirit(RegistryObject<? extends AbstractLodestoneParticleType<?>> particle, LodestoneBehaviorComponent behavior) {
        return SpiritBasedParticleBuilder.createSpirit(new WorldParticleOptions((ParticleType)particle.get()).setBehavior(behavior));
    }

    public static SpiritBasedParticleBuilder createSpirit(WorldParticleOptions options) {
        return new SpiritBasedParticleBuilder(options);
    }

    protected SpiritBasedParticleBuilder(WorldParticleOptions options) {
        super(options);
    }

    public SpiritBasedParticleBuilder setSpirit(MalumSpiritType spiritType) {
        this.spiritType = spiritType;
        if (this.isUmbral()) {
            super.setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT);
        }
        return this.setColorData(spiritType.createColorData().build());
    }

    public boolean isUmbral() {
        return this.spiritType != null && this.spiritType.equals(SpiritTypeRegistry.UMBRAL_SPIRIT);
    }

    public SpiritBasedParticleBuilder setRenderType(ParticleRenderType renderType) {
        if (this.isUmbral()) {
            return (SpiritBasedParticleBuilder)super.setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT);
        }
        return (SpiritBasedParticleBuilder)super.setRenderType(renderType);
    }

    public SpiritBasedParticleBuilder setLifetime(Supplier<Integer> lifetimeSupplier) {
        if (this.isUmbral()) {
            return (SpiritBasedParticleBuilder)super.setLifetime(() -> (int)((float)((Integer)lifetimeSupplier.get()).intValue() * 2.5f));
        }
        return (SpiritBasedParticleBuilder)super.setLifetime(lifetimeSupplier);
    }

    public SpiritBasedParticleBuilder setScaleData(GenericParticleData scaleData) {
        if (this.isUmbral()) {
            scaleData.multiplyCoefficient(1.5f);
        }
        return (SpiritBasedParticleBuilder)super.setScaleData(scaleData);
    }

    public SpiritBasedParticleBuilder setTransparencyData(GenericParticleData transparencyData) {
        if (this.isUmbral()) {
            transparencyData.multiplyValue(4.0f).multiplyCoefficient(1.5f);
        }
        return (SpiritBasedParticleBuilder)super.setTransparencyData(transparencyData);
    }

    public SpiritBasedParticleBuilder enableNoClip() {
        return (SpiritBasedParticleBuilder)super.enableNoClip();
    }

    public SpiritBasedParticleBuilder disableNoClip() {
        return (SpiritBasedParticleBuilder)super.disableNoClip();
    }

    public SpiritBasedParticleBuilder setNoClip(boolean noClip) {
        return (SpiritBasedParticleBuilder)super.setNoClip(noClip);
    }

    public SpiritBasedParticleBuilder setRenderTarget(RenderHandler.LodestoneRenderLayer renderLayer) {
        return (SpiritBasedParticleBuilder)super.setRenderTarget(renderLayer);
    }

    public SpiritBasedParticleBuilder enableForcedSpawn() {
        return (SpiritBasedParticleBuilder)super.enableForcedSpawn();
    }

    public SpiritBasedParticleBuilder disableForcedSpawn() {
        return (SpiritBasedParticleBuilder)super.disableForcedSpawn();
    }

    public SpiritBasedParticleBuilder setForceSpawn(boolean forceSpawn) {
        return (SpiritBasedParticleBuilder)super.setForceSpawn(forceSpawn);
    }

    public SpiritBasedParticleBuilder enableCull() {
        return (SpiritBasedParticleBuilder)super.enableCull();
    }

    public SpiritBasedParticleBuilder disableCull() {
        return (SpiritBasedParticleBuilder)super.disableCull();
    }

    public SpiritBasedParticleBuilder setShouldCull(boolean shouldCull) {
        return (SpiritBasedParticleBuilder)super.setShouldCull(shouldCull);
    }

    public SpiritBasedParticleBuilder setRandomMotion(double maxSpeed) {
        return (SpiritBasedParticleBuilder)super.setRandomMotion(maxSpeed);
    }

    public SpiritBasedParticleBuilder setRandomMotion(double maxHSpeed, double maxVSpeed) {
        return (SpiritBasedParticleBuilder)super.setRandomMotion(maxHSpeed, maxVSpeed);
    }

    public SpiritBasedParticleBuilder setRandomMotion(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
        return (SpiritBasedParticleBuilder)super.setRandomMotion(maxXSpeed, maxYSpeed, maxZSpeed);
    }

    public SpiritBasedParticleBuilder addMotion(Vector3f motion) {
        return (SpiritBasedParticleBuilder)super.addMotion(motion);
    }

    public SpiritBasedParticleBuilder addMotion(Vec3 motion) {
        return (SpiritBasedParticleBuilder)super.addMotion(motion);
    }

    public SpiritBasedParticleBuilder addMotion(double vx, double vy, double vz) {
        return (SpiritBasedParticleBuilder)super.addMotion(vx, vy, vz);
    }

    public SpiritBasedParticleBuilder setMotion(Vector3f motion) {
        return (SpiritBasedParticleBuilder)super.setMotion(motion);
    }

    public SpiritBasedParticleBuilder setMotion(Vec3 motion) {
        return (SpiritBasedParticleBuilder)super.setMotion(motion);
    }

    public SpiritBasedParticleBuilder setMotion(double vx, double vy, double vz) {
        return (SpiritBasedParticleBuilder)super.setMotion(vx, vy, vz);
    }

    public SpiritBasedParticleBuilder setRandomOffset(double maxDistance) {
        return (SpiritBasedParticleBuilder)super.setRandomOffset(maxDistance);
    }

    public SpiritBasedParticleBuilder setRandomOffset(double maxHDist, double maxVDist) {
        return (SpiritBasedParticleBuilder)super.setRandomOffset(maxHDist, maxVDist);
    }

    public SpiritBasedParticleBuilder setRandomOffset(double maxXDist, double maxYDist, double maxZDist) {
        return (SpiritBasedParticleBuilder)super.setRandomOffset(maxXDist, maxYDist, maxZDist);
    }

    public SpiritBasedParticleBuilder act(Consumer<WorldParticleBuilder> worldParticleBuilderConsumer) {
        return (SpiritBasedParticleBuilder)super.act(worldParticleBuilderConsumer);
    }

    public SpiritBasedParticleBuilder addTickActor(Consumer<LodestoneWorldParticle> particleActor) {
        return (SpiritBasedParticleBuilder)super.addTickActor(particleActor);
    }

    public SpiritBasedParticleBuilder addSpawnActor(Consumer<LodestoneWorldParticle> particleActor) {
        return (SpiritBasedParticleBuilder)super.addSpawnActor(particleActor);
    }

    public SpiritBasedParticleBuilder addRenderActor(Consumer<LodestoneWorldParticle> particleActor) {
        return (SpiritBasedParticleBuilder)super.addRenderActor(particleActor);
    }

    public SpiritBasedParticleBuilder clearActors() {
        return (SpiritBasedParticleBuilder)super.clearActors();
    }

    public SpiritBasedParticleBuilder clearTickActor() {
        return (SpiritBasedParticleBuilder)super.clearTickActor();
    }

    public SpiritBasedParticleBuilder clearSpawnActors() {
        return (SpiritBasedParticleBuilder)super.clearSpawnActors();
    }

    public SpiritBasedParticleBuilder clearRenderActors() {
        return (SpiritBasedParticleBuilder)super.clearRenderActors();
    }

    public SpiritBasedParticleBuilder spawn(Level level, double x, double y, double z) {
        return (SpiritBasedParticleBuilder)super.spawn(level, x, y, z);
    }

    public SpiritBasedParticleBuilder repeat(Level level, double x, double y, double z, int n) {
        return (SpiritBasedParticleBuilder)super.repeat(level, x, y, z, n);
    }

    public SpiritBasedParticleBuilder surroundBlock(Level level, BlockPos pos, Direction ... directions) {
        return (SpiritBasedParticleBuilder)super.surroundBlock(level, pos, directions);
    }

    public SpiritBasedParticleBuilder repeatSurroundBlock(Level level, BlockPos pos, int n) {
        return (SpiritBasedParticleBuilder)super.repeatSurroundBlock(level, pos, n);
    }

    public SpiritBasedParticleBuilder repeatSurroundBlock(Level level, BlockPos pos, int n, Direction ... directions) {
        return (SpiritBasedParticleBuilder)super.repeatSurroundBlock(level, pos, n, directions);
    }

    public SpiritBasedParticleBuilder surroundVoxelShape(Level level, BlockPos pos, VoxelShape voxelShape, int max) {
        return (SpiritBasedParticleBuilder)super.surroundVoxelShape(level, pos, voxelShape, max);
    }

    public SpiritBasedParticleBuilder surroundVoxelShape(Level level, BlockPos pos, BlockState state, int max) {
        return (SpiritBasedParticleBuilder)super.surroundVoxelShape(level, pos, state, max);
    }

    public SpiritBasedParticleBuilder spawnAtRandomFace(Level level, BlockPos pos) {
        return (SpiritBasedParticleBuilder)super.spawnAtRandomFace(level, pos);
    }

    public SpiritBasedParticleBuilder repeatRandomFace(Level level, BlockPos pos, int n) {
        return (SpiritBasedParticleBuilder)super.repeatRandomFace(level, pos, n);
    }

    public SpiritBasedParticleBuilder createCircle(Level level, double x, double y, double z, double distance, double currentCount, double totalCount) {
        return (SpiritBasedParticleBuilder)super.createCircle(level, x, y, z, distance, currentCount, totalCount);
    }

    public SpiritBasedParticleBuilder repeatCircle(Level level, double x, double y, double z, double distance, int times) {
        return (SpiritBasedParticleBuilder)super.repeatCircle(level, x, y, z, distance, times);
    }

    public SpiritBasedParticleBuilder createBlockOutline(Level level, BlockPos pos, BlockState state) {
        return (SpiritBasedParticleBuilder)super.createBlockOutline(level, pos, state);
    }

    public SpiritBasedParticleBuilder spawnLine(Level level, Vec3 one, Vec3 two) {
        return (SpiritBasedParticleBuilder)super.spawnLine(level, one, two);
    }

    public SpiritBasedParticleBuilder modifyData(Supplier<GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifyData(dataType, dataConsumer);
    }

    public SpiritBasedParticleBuilder modifyData(Function<WorldParticleBuilder, GenericParticleData> dataType, Consumer<GenericParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifyData(dataType, dataConsumer);
    }

    public SpiritBasedParticleBuilder modifyColorData(Consumer<ColorParticleData> dataConsumer) {
        return (SpiritBasedParticleBuilder)super.modifyColorData(dataConsumer);
    }

    public SpiritBasedParticleBuilder setColorData(ColorParticleData colorData) {
        return (SpiritBasedParticleBuilder)super.setColorData(colorData);
    }

    public SpiritBasedParticleBuilder setSpinData(SpinParticleData spinData) {
        return (SpiritBasedParticleBuilder)super.setSpinData(spinData);
    }

    public SpiritBasedParticleBuilder multiplyGravity(float gravityMultiplier) {
        return (SpiritBasedParticleBuilder)super.multiplyGravity(gravityMultiplier);
    }

    public SpiritBasedParticleBuilder modifyGravity(Function<Float, Supplier<Float>> gravityReplacement) {
        return (SpiritBasedParticleBuilder)super.modifyGravity(gravityReplacement);
    }

    public SpiritBasedParticleBuilder setGravityStrength(float gravity) {
        return (SpiritBasedParticleBuilder)super.setGravityStrength(gravity);
    }

    public SpiritBasedParticleBuilder setGravityStrength(Supplier<Float> gravityStrengthSupplier) {
        return (SpiritBasedParticleBuilder)super.setGravityStrength(gravityStrengthSupplier);
    }

    public SpiritBasedParticleBuilder multiplyLifetime(float lifetimeMultiplier) {
        return (SpiritBasedParticleBuilder)super.multiplyLifetime(lifetimeMultiplier);
    }

    public SpiritBasedParticleBuilder modifyLifetime(Function<Integer, Supplier<Integer>> lifetimeReplacement) {
        return (SpiritBasedParticleBuilder)super.modifyLifetime(lifetimeReplacement);
    }

    public SpiritBasedParticleBuilder setLifetime(int lifetime) {
        return (SpiritBasedParticleBuilder)super.setLifetime(lifetime);
    }

    public SpiritBasedParticleBuilder multiplyLifeDelay(float lifeDelayMultiplier) {
        return (SpiritBasedParticleBuilder)super.multiplyLifeDelay(lifeDelayMultiplier);
    }

    public SpiritBasedParticleBuilder modifyLifeDelay(Function<Integer, Supplier<Integer>> lifeDelayReplacement) {
        return (SpiritBasedParticleBuilder)super.modifyLifeDelay(lifeDelayReplacement);
    }

    public SpiritBasedParticleBuilder setLifeDelay(int lifeDelay) {
        return (SpiritBasedParticleBuilder)super.setLifeDelay(lifeDelay);
    }

    public SpiritBasedParticleBuilder setLifeDelay(Supplier<Integer> lifeDelaySupplier) {
        return (SpiritBasedParticleBuilder)super.setLifeDelay(lifeDelaySupplier);
    }

    public SpiritBasedParticleBuilder setSpritePicker(SimpleParticleOptions.ParticleSpritePicker spritePicker) {
        return (SpiritBasedParticleBuilder)super.setSpritePicker(spritePicker);
    }

    public SpiritBasedParticleBuilder setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType discardFunctionType) {
        return (SpiritBasedParticleBuilder)super.setDiscardFunction(discardFunctionType);
    }
}

