/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.RenderTypeRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TickEvent;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class TotemBaseRenderer
implements BlockEntityRenderer<TotemBaseBlockEntity> {
    public static final RenderTypeToken AREA_COVERAGE_TEXTURE = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/vfx/area_coverage.png"));
    private static float totemicStaffHeldTimer = 0.0f;
    private static boolean isHoldingStaff;

    public TotemBaseRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void checkForTotemicStaff(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Item totemicStaff = (Item)ItemRegistry.TOTEMIC_STAFF.get();
            if (player.m_21205_().m_41720_().equals(totemicStaff) || player.m_21206_().m_41720_().equals(totemicStaff)) {
                if (totemicStaffHeldTimer < 20.0f) {
                    totemicStaffHeldTimer += 1.0f;
                }
                isHoldingStaff = true;
            } else if (totemicStaffHeldTimer > 0.0f) {
                totemicStaffHeldTimer -= 1.0f;
                isHoldingStaff = false;
            }
        }
    }

    public void render(TotemBaseBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (totemicStaffHeldTimer > 0.0f) {
            int height;
            if (blockEntityIn.cachedRadiusRite == null) {
                return;
            }
            float staffTimer = Mth.m_14036_((float)(totemicStaffHeldTimer + (float)(isHoldingStaff ? 1 : -1) * partialTicks), (float)0.0f, (float)20.0f);
            float totemTimer = Mth.m_14036_((float)((float)blockEntityIn.radiusVisibility + (float)(blockEntityIn.isActiveOrAssembling() ? 1 : -1) * partialTicks), (float)0.0f, (float)40.0f);
            float scalar = Easing.SINE_IN_OUT.ease(staffTimer / 20.0f, 0.0f, 1.0f, 1.0f) * Easing.SINE_IN_OUT.ease(totemTimer / 40.0f, 0.0f, 1.0f, 1.0f);
            MalumSpiritType spiritType = blockEntityIn.cachedRadiusRite.getIdentifyingSpirit();
            TotemicRiteEffect riteEffect = blockEntityIn.cachedRadiusRite.getRiteEffect(blockEntityIn.isSoulwood);
            BlockPos riteEffectCenter = riteEffect.getRiteEffectCenter(blockEntityIn);
            BlockPos offset = riteEffectCenter.m_121996_((Vec3i)blockEntityIn.m_58899_());
            int width = riteEffect.getRiteEffectHorizontalRadius();
            if (width > 1) {
                width = width * 2 + 1;
            }
            if ((height = riteEffect.getRiteEffectVerticalRadius()) > 1) {
                height = height * 2 + 1;
            }
            float shaderWidth = width * 32;
            float shaderHeight = height * 32;
            float distortion = 6.0f + (float)height / 2.0f;
            float sideDistortion = 6.0f + (float)width / 2.0f;
            LodestoneRenderType renderType = RenderTypeRegistry.ADDITIVE_DISTORTED_TEXTURE.applyWithModifierAndCache(AREA_COVERAGE_TEXTURE, b -> b.setCullState(LodestoneRenderTypeRegistry.NO_CULL));
            float index = shaderWidth + distortion;
            float sideIndex = shaderWidth * shaderHeight + sideDistortion;
            VFXBuilders.WorldVFXBuilder builder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((RenderType)LodestoneRenderTypeRegistry.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypeRegistry.copyAndStore((Object)Float.valueOf(index), (LodestoneRenderType)renderType), s -> {
                s.m_173356_("Speed").m_5985_(1500.0f);
                s.m_173356_("Distortion").m_5985_(distortion);
                s.m_173356_("Width").m_5985_(shaderWidth);
                s.m_173356_("Height").m_5985_(shaderWidth);
            })).setColor(spiritType.getPrimaryColor(), 0.7f * scalar);
            VFXBuilders.WorldVFXBuilder sideBuilder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((RenderType)LodestoneRenderTypeRegistry.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypeRegistry.copyAndStore((Object)Float.valueOf(sideIndex), (LodestoneRenderType)renderType), s -> {
                s.m_173356_("Speed").m_5985_(1500.0f);
                s.m_173356_("Distortion").m_5985_(sideDistortion);
                s.m_173356_("Width").m_5985_(shaderWidth);
                s.m_173356_("Height").m_5985_(shaderHeight);
            })).setColor(spiritType.getPrimaryColor(), 0.7f * scalar);
            poseStack.m_85836_();
            poseStack.m_252880_((float)offset.m_123341_(), (float)offset.m_123342_(), (float)offset.m_123343_());
            RenderUtils.CubeVertexData cubeVertexData = RenderUtils.makeCubePositions(width, height).applyWobble(0.0f, 0.5f, 0.01f);
            RenderUtils.CubeVertexData inverse = RenderUtils.makeCubePositions(-width, -height).applyWobble(0.0f, 0.5f, 0.01f);
            RenderUtils.drawCube(poseStack, builder, sideBuilder, 1.05f, cubeVertexData);
            builder.setUV(0.0f, 1.0f, 1.0f, 0.0f).setColor(spiritType.getSecondaryColor(), 0.6f * scalar);
            sideBuilder.setUV(0.0f, 1.0f, 1.0f, 0.0f).setColor(spiritType.getSecondaryColor(), 0.6f * scalar);
            RenderUtils.drawCube(poseStack, builder, sideBuilder, 1.05f, inverse);
            poseStack.m_85849_();
        }
    }
}

