/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.curio;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.cosmetic.curios.CurioTokenOfGratitude;
import com.sammy.malum.registry.client.ModelRegistry;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class TokenOfGratitudeRenderer
implements ICurioRenderer {
    private static final ResourceLocation SAMMY = MalumMod.malumPath("textures/cosmetic/sammy_tail.png");
    private static final ResourceLocation OWL_PERSON_EYES = MalumMod.malumPath("textures/cosmetic/owl_person_eyes.png");
    private static final ResourceLocation OWL_PERSON_ELYTRA = MalumMod.malumPath("textures/cosmetic/owl_person_elytra.png");
    private static final ResourceLocation SNAKE_FELLA_SCARF = MalumMod.malumPath("textures/cosmetic/snake_scarf.png");
    private static final ResourceLocation BOBBU_SCARF = MalumMod.malumPath("textures/cosmetic/bobbu_scarf.png");
    private static final ResourceLocation DELLY_NECKLACE = MalumMod.malumPath("textures/cosmetic/delly_necklace.png");
    private static final ResourceLocation LOFI = MalumMod.malumPath("textures/cosmetic/lofi_tail.png");
    private static final ResourceLocation TRANS_SCARF = MalumMod.malumPath("textures/cosmetic/trans_scarf.png");

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer playerEntity = (AbstractClientPlayer)livingEntity;
            if (playerEntity.m_20148_().equals(CurioTokenOfGratitude.SAMMY)) {
                TokenOfGratitudeRenderer.renderTail(stack, SAMMY, poseStack, playerEntity, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
            if (playerEntity.m_20148_().equals(CurioTokenOfGratitude.LOFI) || playerEntity.m_20148_().equals(CurioTokenOfGratitude.CREECHURE)) {
                TokenOfGratitudeRenderer.renderTail(stack, LOFI, poseStack, playerEntity, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
            if (playerEntity.m_20148_().equals(CurioTokenOfGratitude.OWL_PERSON)) {
                TokenOfGratitudeRenderer.renderGlowingEyes(playerEntity, (RenderType)LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(RenderTypeToken.createCachedToken((ResourceLocation)OWL_PERSON_EYES)), poseStack, renderTypeBuffer, 0xF000F0);
            }
            if (playerEntity.m_20148_().equals(CurioTokenOfGratitude.SNAKE_SCARF_FELLA)) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, SNAKE_FELLA_SCARF, poseStack, renderTypeBuffer, light);
            }
            if (playerEntity.m_20148_().equals(CurioTokenOfGratitude.BOBBU)) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, BOBBU_SCARF, poseStack, renderTypeBuffer, light);
            }
            if (playerEntity.m_20148_().equals(CurioTokenOfGratitude.DELLY)) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, DELLY_NECKLACE, poseStack, renderTypeBuffer, light);
            }
            if (CurioTokenOfGratitude.TRANS_SCARFS.contains(playerEntity.m_20148_())) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, TRANS_SCARF, poseStack, renderTypeBuffer, light);
            }
        }
    }

    public static ResourceLocation getElytraTexture(UUID uuid, ResourceLocation original) {
        if (uuid.equals(CurioTokenOfGratitude.OWL_PERSON)) {
            return OWL_PERSON_ELYTRA;
        }
        return original;
    }

    public static void renderGlowingEyes(AbstractClientPlayer playerEntity, RenderType renderType, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light) {
        VertexConsumer vertexconsumer = renderTypeBuffer.m_6299_(renderType);
        ICurioRenderer.followHeadRotations((LivingEntity)playerEntity, (ModelPart[])new ModelPart[]{ModelRegistry.HEAD_OVERLAY_MODEL.overlay});
        ModelRegistry.HEAD_OVERLAY_MODEL.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTail(ItemStack stack, ResourceLocation texture, PoseStack poseStack, AbstractClientPlayer playerEntity, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        poseStack.m_85836_();
        Vec3 movement = new Vec3(playerEntity.m_20184_().f_82479_, 0.0, playerEntity.m_20184_().f_82481_);
        double wagSpeed = playerEntity.m_20184_().m_82553_();
        if (wagSpeed != 0.0) {
            double factor = 55.0;
            Vec3 yawLook = Vec3.m_82498_((float)0.0f, (float)playerEntity.m_146908_());
            Vec3 look = new Vec3(yawLook.f_82479_, 0.0, yawLook.f_82481_);
            Vec3 desiredDirection = look.m_82524_((float)Math.toRadians(90.0)).m_82541_();
            Vec3 sidewaysVelocity = desiredDirection.m_82490_(movement.m_82526_(desiredDirection));
            double speedAndDirection = sidewaysVelocity.m_82553_() * -Math.signum(desiredDirection.m_82526_(sidewaysVelocity)) / wagSpeed;
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(speedAndDirection * factor)));
        }
        float ambientFactor = playerEntity.m_6144_() ? 2.0f : 6.0f;
        double ambientXRotation = Math.sin((float)playerEntity.m_9236_().m_46467_() / 18.0f) * (double)ambientFactor;
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)ambientXRotation));
        double ambientYRotation = Math.cos((float)playerEntity.m_9236_().m_46467_() / 24.0f) * (double)(-ambientFactor);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)ambientYRotation));
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)stack.m_41790_());
        ModelRegistry.TAIL_MODEL.setupAnim((Player)playerEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelRegistry.TAIL_MODEL.m_6839_((Entity)playerEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurioRenderer.translateIfSneaking((PoseStack)poseStack, (LivingEntity)playerEntity);
        ICurioRenderer.rotateIfSneaking((PoseStack)poseStack, (LivingEntity)playerEntity);
        ModelRegistry.TAIL_MODEL.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static void renderScarf(AbstractClientPlayer playerEntity, ResourceLocation texture, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light) {
        LivingEntityRenderer livingEntityRenderer;
        EntityModel model;
        VertexConsumer vertexconsumer = renderTypeBuffer.m_6299_(RenderType.m_110431_((ResourceLocation)texture));
        float pticks = Minecraft.m_91087_().m_91296_();
        float f = Mth.m_14189_((float)pticks, (float)playerEntity.f_20884_, (float)playerEntity.f_20883_);
        float f1 = Mth.m_14189_((float)pticks, (float)playerEntity.f_20886_, (float)playerEntity.f_20885_);
        float netHeadYaw = f1 - f;
        float netHeadPitch = Mth.m_14179_((float)pticks, (float)playerEntity.f_19860_, (float)playerEntity.m_146909_());
        EntityRenderer render = Minecraft.m_91087_().m_91290_().m_114382_((Entity)playerEntity);
        if (render instanceof LivingEntityRenderer && (model = (livingEntityRenderer = (LivingEntityRenderer)render).m_7200_()) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ModelRegistry.SCARF.copyFromDefault(humanoidModel);
        }
        ModelRegistry.SCARF.setupAnim((Player)playerEntity, playerEntity.f_267362_.m_267756_(), playerEntity.f_267362_.m_267731_(), (float)playerEntity.f_19797_ + pticks, netHeadYaw, netHeadPitch);
        ModelRegistry.SCARF.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

