/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.thrown.ThrownConcentratedGluttony;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ThrownConcentratedGluttonyRenderer
extends EntityRenderer<ThrownConcentratedGluttony> {
    private static final RenderType TRANSPARENT_TRAIL_TYPE = LodestoneRenderTypeRegistry.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.apply(RenderTypeToken.createCachedToken((ResourceLocation)MalumMod.malumPath("textures/vfx/concentrated_trail.png")), ShaderUniformHandler.LUMITRANSPARENT);
    private static final Color GLUTTONY_GREEN = new Color(47, 81, 28);
    private static final Color GLUTTONY_DARK = new Color(31, 35, 30);
    private static final Color GLUTTONY_SHADE = new Color(14, 14, 16);
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final boolean fullBright;

    public ThrownConcentratedGluttonyRenderer(EntityRendererProvider.Context pContext, float pScale, boolean pFullBright) {
        super(pContext);
        this.itemRenderer = pContext.m_174025_();
        this.scale = pScale;
        this.fullBright = pFullBright;
    }

    public ThrownConcentratedGluttonyRenderer(EntityRendererProvider.Context pContext) {
        this(pContext, 1.0f, false);
    }

    protected int getBlockLightLevel(ThrownConcentratedGluttony entity, BlockPos pPos) {
        return this.fullBright ? 15 : super.m_6086_((Entity)entity, pPos);
    }

    public void render(ThrownConcentratedGluttony entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (entity.f_19797_ >= 2 || !(this.f_114476_.f_114358_.m_90592_().m_20280_((Entity)entity) < 12.25)) {
            if (!entity.fadingAway) {
                poseStack.m_85836_();
                poseStack.m_85841_(this.scale, this.scale, this.scale);
                poseStack.m_252781_(this.f_114476_.m_253208_());
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                this.itemRenderer.m_269128_(entity.m_7846_(), ItemDisplayContext.GROUND, packedLightIn, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget(), entity.m_9236_(), entity.m_19879_());
                poseStack.m_85849_();
            }
            float scale = entity.getVisualEffectScalar();
            LodestoneRenderType additive = LodestoneRenderTypeRegistry.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.applyAndCache(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
            LodestoneRenderType transparent = LodestoneRenderTypeRegistry.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.applyAndCache(MalumRenderTypeTokens.CONCENTRATED_TRAIL, ShaderUniformHandler.LUMITRANSPARENT);
            VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType((RenderType)additive);
            for (TrailPointBuilder trail : entity.trails) {
                RenderUtils.renderEntityTrail(poseStack, builder, trail, (Entity)entity, GLUTTONY_GREEN, GLUTTONY_DARK, scale * 0.5f, scale * 0.5f, partialTicks);
            }
            builder.setRenderType(TRANSPARENT_TRAIL_TYPE);
            for (TrailPointBuilder trail : entity.trails) {
                RenderUtils.renderEntityTrail(poseStack, builder, trail, (Entity)entity, GLUTTONY_GREEN, GLUTTONY_SHADE, scale * 0.75f, scale * 2.0f, partialTicks);
                RenderUtils.renderEntityTrail(poseStack, builder, trail, (Entity)entity, GLUTTONY_DARK, GLUTTONY_SHADE, scale, scale * 3.0f, partialTicks);
            }
            super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        }
    }

    public ResourceLocation getTextureLocation(ThrownConcentratedGluttony entity) {
        return TextureAtlas.f_118259_;
    }
}

