/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.scythe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.ISpiritAffiliatedItem;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class ScytheBoomerangEntityRenderer
extends EntityRenderer<ScytheBoomerangEntity> {
    public final ItemRenderer itemRenderer;

    public ScytheBoomerangEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
    }

    public void render(ScytheBoomerangEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        MalumSpiritType malumSpiritType;
        poseStack.m_85836_();
        ItemStack itemstack = entityIn.m_7846_();
        BakedModel model = this.itemRenderer.m_174264_(itemstack, entityIn.m_9236_(), null, 1);
        if (entityIn.isEnhanced()) {
            Vec3 direction = entityIn.m_20184_().m_82541_();
            float yRot = (float)Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252961_(yRot + 1.57f));
        } else {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        poseStack.m_252781_(Axis.f_252403_.m_252961_(((float)entityIn.age + partialTicks) * 0.9f));
        poseStack.m_85841_(2.0f, 2.0f, 1.5f);
        this.itemRenderer.m_115143_(itemstack, itemstack.m_41720_() instanceof MalumScytheItem ? ItemDisplayContext.NONE : ItemDisplayContext.FIXED, false, poseStack, bufferIn, packedLightIn, OverlayTexture.f_118083_, model);
        poseStack.m_85849_();
        Item item = entityIn.m_7846_().m_41720_();
        if (item instanceof ISpiritAffiliatedItem) {
            ISpiritAffiliatedItem affiliatedItem = (ISpiritAffiliatedItem)item;
            malumSpiritType = affiliatedItem.getDefiningSpiritType();
        } else {
            malumSpiritType = null;
        }
        MalumSpiritType spirit = malumSpiritType;
        boolean isMagical = spirit != null;
        LodestoneRenderType renderType = isMagical ? LodestoneRenderTypeRegistry.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.applyAndCache(MalumRenderTypeTokens.CONCENTRATED_TRAIL) : LodestoneRenderTypeRegistry.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.applyAndCache(MalumRenderTypeTokens.CONCENTRATED_TRAIL, ShaderUniformHandler.LUMITRANSPARENT);
        Color primaryColor = isMagical ? spirit.getPrimaryColor() : new Color(0.9f, 0.9f, 0.9f);
        Color secondaryColor = isMagical ? spirit.getSecondaryColor() : new Color(0.5f, 0.5f, 0.5f);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType((RenderType)renderType);
        float scalar = Math.min((float)entityIn.age / 20.0f, 1.0f);
        RenderUtils.renderEntityTrail(poseStack, builder, entityIn.theFormer, (Entity)entityIn, primaryColor, secondaryColor, scalar, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, entityIn.theLatter, (Entity)entityIn, primaryColor, secondaryColor, scalar, partialTicks);
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(ScytheBoomerangEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

