/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ShaderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.joml.Vector4f;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.IRecipeComponent;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class ArcanaCodexHelper {
    public static final VFXBuilders.ScreenVFXBuilder VFX_BUILDER = VFXBuilders.createScreen().setPosTexDefaultFormat();

    public static <T extends AbstractProgressionCodexScreen> void renderTransitionFade(T screen, PoseStack stack) {
        float pct = (float)screen.transitionTimer / (float)screen.getTransitionDuration();
        float overlayAlpha = Easing.SINE_IN_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectStrength = Easing.QUAD_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectAlpha = Math.min(1.0f, effectStrength * 1.0f);
        float zoom = 0.5f + Math.min(0.35f, effectStrength);
        float intensity = 1.0f + (effectStrength > 0.5f ? (effectStrength - 0.5f) * 2.5f : 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPositionWithWidth((float)screen.getInsideLeft(), (float)screen.getInsideTop(), (float)screen.bookInsideWidth, (float)screen.bookInsideHeight).setColor(0.0f, 0.0f, 0.0f).setAlpha(overlayAlpha).setZLevel(200).setPosColorDefaultFormat().setShader(GameRenderer::m_172811_).draw(stack);
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)ShaderRegistry.TOUCH_OF_DARKNESS.getInstance().get();
        shaderInstance.m_173356_("Speed").m_5985_(1000.0f);
        Consumer<Float> setZoom = f -> shaderInstance.m_173356_("Zoom").m_5985_(f.floatValue());
        Consumer<Float> setIntensity = f -> shaderInstance.m_173356_("Intensity").m_5985_(f.floatValue());
        builder.setPosColorTexDefaultFormat().setAlpha(effectAlpha).setShader(ShaderRegistry.TOUCH_OF_DARKNESS.getInstance());
        setZoom.accept(Float.valueOf(zoom));
        setIntensity.accept(Float.valueOf(intensity));
        builder.draw(stack);
        setZoom.accept(Float.valueOf(zoom * 1.25f + 0.15f));
        setIntensity.accept(Float.valueOf(intensity * 0.8f + 0.5f));
        builder.draw(stack);
        shaderInstance.setUniformDefaults();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderRitualIcon(MalumRitualType rite, PoseStack stack, boolean corrupted, float glowAlpha, int x, int y) {
        ArcanaCodexHelper.renderRiteIcon(rite.getIcon(), rite.spirit, stack, corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(TotemicRiteType rite, PoseStack stack, boolean corrupted, float glowAlpha, int x, int y) {
        ArcanaCodexHelper.renderRiteIcon(rite.getIcon(), rite.getIdentifyingSpirit(), stack, corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(ResourceLocation texture, MalumSpiritType spiritType, PoseStack stack, boolean corrupted, float glowAlpha, int x, int y) {
        ArcanaCodexHelper.renderRiteIcon(texture, spiritType, stack, corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(ResourceLocation texture, MalumSpiritType spiritType, PoseStack stack, boolean corrupted, float glowAlpha, int x, int y, int z) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaderRegistry.DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.m_173356_("YFrequency").m_5985_(corrupted ? 5.0f : 11.0f);
        shaderInstance.m_173356_("XFrequency").m_5985_(corrupted ? 12.0f : 17.0f);
        shaderInstance.m_173356_("Speed").m_5985_(2000.0f * (corrupted ? -0.75f : 1.0f));
        shaderInstance.m_173356_("Intensity").m_5985_(corrupted ? 14.0f : 50.0f);
        Supplier<ShaderInstance> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexLightmapDefaultFormat().setShader(shaderInstanceSupplier).setColor(spiritType.getPrimaryColor()).setAlpha(0.9f).setZLevel(z);
        RenderSystem.blendFunc((int)770, (int)1);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        builder.setAlpha(glowAlpha);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x - 1, y, 0.0f, 0.0f, 16, 16, 16, 16);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x + 1, y, 0.0f, 0.0f, 16, 16, 16, 16);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y - 1, 0.0f, 0.0f, 16, 16, 16, 16);
        if (corrupted) {
            builder.setColor(spiritType.getSecondaryColor());
        }
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, int x, int y) {
        ArcanaCodexHelper.renderWavyIcon(location, stack, x, y, 0);
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, int x, int y, int z) {
        ArcanaCodexHelper.renderWavyIcon(location, stack, x, y, 0, 16, 16);
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, int x, int y, int z, int textureWidth, int textureHeight) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaderRegistry.DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.m_173356_("YFrequency").m_5985_(10.0f);
        shaderInstance.m_173356_("XFrequency").m_5985_(12.0f);
        shaderInstance.m_173356_("Speed").m_5985_(1000.0f);
        shaderInstance.m_173356_("Intensity").m_5985_(50.0f);
        shaderInstance.m_173356_("UVCoordinates").m_142558_(new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        Supplier<ShaderInstance> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexLightmapDefaultFormat().setShader(shaderInstanceSupplier).setAlpha(0.7f).setZLevel(z).setShader(() -> shaderInstance);
        RenderSystem.blendFunc((int)770, (int)1);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setAlpha(0.1f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x - 1, y, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x + 1, y, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y - 1, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y + 1, 0.0f, 0.0f, textureWidth, textureHeight);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, int x, int y, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, x, y, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, int x, int y, int z, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, 0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, int z, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        builder.setPositionWithWidth((float)x, (float)y, (float)width, (float)height).setZLevel(z).setShaderTexture(texture).setUVWithWidth(u, v, (float)width, (float)height, (float)textureWidth, (float)textureHeight).draw(poseStack);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderComponents(AbstractMalumScreen screen, GuiGraphics guiGraphics, List<? extends IRecipeComponent> components, int left, int top, int mouseX, int mouseY, boolean vertical) {
        List<ItemStack> items = components.stream().map(IRecipeComponent::getStack).collect(Collectors.toList());
        ArcanaCodexHelper.renderItemList(screen, guiGraphics, items, left, top, mouseX, mouseY, vertical).run();
    }

    public static Runnable renderBufferedComponents(AbstractMalumScreen screen, GuiGraphics guiGraphics, List<? extends IRecipeComponent> components, int left, int top, int mouseX, int mouseY, boolean vertical) {
        List<ItemStack> items = components.stream().map(IRecipeComponent::getStack).collect(Collectors.toList());
        return ArcanaCodexHelper.renderItemList(screen, guiGraphics, items, left, top, mouseX, mouseY, vertical);
    }

    public static void renderComponent(AbstractMalumScreen screen, GuiGraphics guiGraphics, IRecipeComponent component, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, component.getStacks(), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, Ingredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, List.of(ingredient.m_43908_()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, List<ItemStack> stacks, int posX, int posY, int mouseX, int mouseY) {
        if (stacks.size() == 1) {
            ArcanaCodexHelper.renderItem(screen, guiGraphics, stacks.get(0), posX, posY, mouseX, mouseY);
            return;
        }
        int index = (int)(Minecraft.m_91087_().f_91073_.m_46467_() % (20L * (long)stacks.size()) / 20L);
        ItemStack stack = stacks.get(index);
        ArcanaCodexHelper.renderItem(screen, guiGraphics, stack, posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, ItemStack stack, int posX, int posY, int mouseX, int mouseY) {
        if (!stack.m_41619_()) {
            guiGraphics.m_280480_(stack, posX, posY);
            guiGraphics.m_280302_(Minecraft.m_91087_().f_91062_, stack, posX, posY, null);
            if (screen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
                guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack), mouseX, mouseY);
            }
        }
    }

    public static Runnable renderItemList(AbstractMalumScreen screen, GuiGraphics guiGraphics, List<ItemStack> items, int left, int top, int mouseX, int mouseY, boolean vertical) {
        int slots = items.size();
        ArcanaCodexHelper.renderItemFrames(guiGraphics.m_280168_(), slots, left, top, vertical);
        return () -> {
            int finalLeft = left;
            int finalTop = top;
            if (vertical) {
                finalTop -= 10 * (slots - 1);
            } else {
                finalLeft -= 10 * (slots - 1);
            }
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = (ItemStack)items.get(i);
                int offset = i * 20;
                int oLeft = finalLeft + 2 + (vertical ? 0 : offset);
                int oTop = finalTop + 2 + (vertical ? offset : 0);
                ArcanaCodexHelper.renderItem(screen, guiGraphics, stack, oLeft, oTop, mouseX, mouseY);
            }
        };
    }

    public static void renderItemFrames(PoseStack poseStack, int slots, int left, int top, boolean vertical) {
        int startingOffset = 10 * (slots - 1);
        if (vertical) {
            top -= startingOffset;
        } else {
            left -= startingOffset;
        }
        for (int i = 0; i < slots; ++i) {
            int offset = i * 20;
            int oLeft = left + (vertical ? 0 : offset);
            int oTop = top + (vertical ? offset : 0);
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft, oTop, 18.0f, 16.0f, 20, 20, 38, 44);
            if (vertical) {
                int v = i == slots - 1 ? 40 : 37;
                ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft + 1, oTop + 19, 16.0f, (float)v, 18, 2, 38, 44);
                continue;
            }
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft + 1, top + 19, 16.0f, 40.0f, 18, 2, 38, 44);
            if (slots <= 1 || i == slots - 1) continue;
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft + 19, top, 16.0f, 16.0f, 2, 20, 38, 44);
        }
        int crownLeft = left + 5 + (vertical ? 0 : startingOffset);
        ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, crownLeft, top - 5, 28.0f, 0.0f, 10, 6, 38, 44);
        if (vertical) {
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left - 4, top - 4, 0.0f, 0.0f, 28, 7, 38, 44);
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left - 4, top + 17 + 20 * (slots - 1), 0.0f, 8.0f, 28, 7, 38, 44);
        } else {
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left - 4, top - 4, 0.0f, 16.0f, 7, 28, 38, 44);
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left + 17 + 20 * (slots - 1), top - 4, 8.0f, 16.0f, 7, 28, 38, 44);
        }
    }

    public static MutableComponent convertToComponent(String text) {
        return ArcanaCodexHelper.convertToComponent(text, UnaryOperator.identity());
    }

    public static MutableComponent convertToComponent(String text, UnaryOperator<Style> styleModifier) {
        text = Component.m_237115_((String)text).getString();
        MutableComponent raw = Component.m_237119_();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char peek;
            char chr = text.charAt(i);
            if (chr == '$') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            line.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                line.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    if (peek == '$') {
                        line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        ++i;
                        continue;
                    }
                    line.append(chr);
                    continue;
                }
                line.append(chr);
                continue;
            }
            line.append(chr);
        }
        ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
        return raw;
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, String text, int x, int y, int w) {
        int i;
        Font font = Minecraft.m_91087_().f_91062_;
        text = Component.m_237115_((String)text).getString() + "\n";
        ArrayList<String> lines = new ArrayList<String>();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (i = 0; i < ((String)text).length(); ++i) {
            char chr = ((String)text).charAt(i);
            if (chr == ' ' || chr == '\n') {
                if (word.length() > 0) {
                    if (font.m_92895_(line.toString()) + font.m_92895_(word.toString()) > w) {
                        line = ArcanaCodexHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                    }
                    line.append((CharSequence)word).append(' ');
                    word = new StringBuilder();
                }
                String noFormatting = ChatFormatting.m_126649_((String)line.toString());
                if (chr != '\n' || noFormatting == null) continue;
                line = ArcanaCodexHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                continue;
            }
            if (chr == '$') {
                if (i != ((String)text).length() - 1) {
                    char peek = ((String)text).charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            word.append(ChatFormatting.ITALIC);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            word.append(ChatFormatting.BOLD);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            word.append(ChatFormatting.STRIKETHROUGH);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            word.append(ChatFormatting.UNDERLINE);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            word.append(ChatFormatting.OBFUSCATED);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            word.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                word.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != ((String)text).length() - 1) {
                    char peek = ((String)text).charAt(i + 1);
                    if (peek == '$') {
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        word.append(ChatFormatting.RESET);
                        ++i;
                        continue;
                    }
                    word.append(chr);
                    continue;
                }
                word.append(chr);
                continue;
            }
            word.append(chr);
        }
        for (i = 0; i < lines.size(); ++i) {
            String currentLine = (String)lines.get(i);
            Objects.requireNonNull(font);
            ArcanaCodexHelper.renderRawText(guiGraphics, currentLine, x, y + i * (9 + 1), ArcanaCodexHelper.getTextGlow((float)i / 4.0f));
        }
    }

    private static StringBuilder commitComponent(MutableComponent component, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line, UnaryOperator<Style> styleModifier) {
        component.m_7220_((Component)Component.m_237113_((String)line.toString()).m_130938_(style -> style.m_131155_(Boolean.valueOf(italic)).m_131136_(Boolean.valueOf(bold)).m_178522_(Boolean.valueOf(strikethrough)).m_131162_(Boolean.valueOf(underline)).m_178524_(Boolean.valueOf(obfuscated))).m_130938_(styleModifier));
        line = new StringBuilder();
        return line;
    }

    private static StringBuilder newLine(List<String> lines, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line) {
        lines.add(line.toString());
        line = new StringBuilder();
        if (italic) {
            line.append(ChatFormatting.ITALIC);
        }
        if (bold) {
            line.append(ChatFormatting.BOLD);
        }
        if (strikethrough) {
            line.append(ChatFormatting.STRIKETHROUGH);
        }
        if (underline) {
            line.append(ChatFormatting.UNDERLINE);
        }
        if (obfuscated) {
            line.append(ChatFormatting.OBFUSCATED);
        }
        return line;
    }

    public static void renderText(GuiGraphics guiGraphics, String text, int x, int y) {
        ArcanaCodexHelper.renderText(guiGraphics, (Component)Component.m_237115_((String)text), x, y, ArcanaCodexHelper.getTextGlow(0.0f));
    }

    public static void renderText(GuiGraphics guiGraphics, Component component, int x, int y) {
        String text = component.getString();
        ArcanaCodexHelper.renderRawText(guiGraphics, text, x, y, ArcanaCodexHelper.getTextGlow(0.0f));
    }

    public static void renderText(GuiGraphics guiGraphics, String text, int x, int y, float glow) {
        ArcanaCodexHelper.renderText(guiGraphics, (Component)Component.m_237115_((String)text), x, y, glow);
    }

    public static void renderText(GuiGraphics guiGraphics, Component component, int x, int y, float glow) {
        String text = component.getString();
        ArcanaCodexHelper.renderRawText(guiGraphics, text, x, y, glow);
    }

    private static void renderRawText(GuiGraphics guiGraphics, String text, int x, int y, float glow) {
        Font font = Minecraft.m_91087_().f_91062_;
        if (((BookTheme)((Object)ClientConfig.BOOK_THEME.getConfigValue())).equals((Object)BookTheme.EASY_READING)) {
            guiGraphics.m_280056_(font, text, x, y, 0, false);
            return;
        }
        glow = Easing.CUBIC_IN.ease(glow, 0.0f, 1.0f, 1.0f);
        int r = (int)Mth.m_14179_((float)glow, (float)163.0f, (float)227.0f);
        int g = (int)Mth.m_14179_((float)glow, (float)44.0f, (float)39.0f);
        int b = (int)Mth.m_14179_((float)glow, (float)191.0f, (float)228.0f);
        guiGraphics.drawString(font, text, (float)x - 1.0f, (float)y, FastColor.ARGB32.m_13660_((int)96, (int)255, (int)210, (int)243), false);
        guiGraphics.drawString(font, text, (float)x + 1.0f, (float)y, FastColor.ARGB32.m_13660_((int)128, (int)240, (int)131, (int)232), false);
        guiGraphics.drawString(font, text, (float)x, (float)y - 1.0f, FastColor.ARGB32.m_13660_((int)128, (int)255, (int)183, (int)236), false);
        guiGraphics.drawString(font, text, (float)x, (float)y + 1.0f, FastColor.ARGB32.m_13660_((int)96, (int)236, (int)110, (int)226), false);
        guiGraphics.m_280056_(font, text, x, y, FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b), false);
    }

    public static float getTextGlow(float offset) {
        return Mth.m_14031_((float)(offset + (float)Minecraft.m_91087_().f_91074_.m_9236_().m_46467_() / 40.0f)) / 2.0f + 0.5f;
    }

    public static boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        return mouseX > (double)posX && mouseX < (double)(posX + (float)width) && mouseY > (double)posY && mouseY < (double)(posY + (float)height);
    }

    public static enum BookTheme {
        DEFAULT,
        EASY_READING;

    }
}

