/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.repair_pylon;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonComponentBlock;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonSoundInstance;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.visual_effects.RepairPylonParticleEffects;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.pylon.PylonPrepareRepairParticleEffect;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class RepairPylonCoreBlockEntity
extends MultiBlockCoreEntity {
    private static final Vec3 PYLON_ITEM_OFFSET = new Vec3(0.5, 2.5, 0.5);
    private static final int HORIZONTAL_RANGE = 6;
    private static final int VERTICAL_RANGE = 4;
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)BlockRegistry.REPAIR_PYLON_COMPONENT.get()).m_49966_()), new MultiBlockStructure.StructurePiece(0, 2, 0, (BlockState)((Block)BlockRegistry.REPAIR_PYLON_COMPONENT.get()).m_49966_().m_61124_((Property)RepairPylonComponentBlock.TOP, (Comparable)Boolean.valueOf(true)))});
    public static final StringRepresentable.EnumCodec<RepairPylonState> CODEC = StringRepresentable.m_216439_(RepairPylonState::values);
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public SpiritRepairRecipe recipe;
    public RepairPylonState state = RepairPylonState.IDLE;
    public BlockPos repairablePosition;
    public int timer;
    public float spiritAmount;
    public float spiritSpin;
    private final LazyOptional<IItemHandler> combinedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory}));

    public RepairPylonCoreBlockEntity(BlockEntityType<? extends RepairPylonCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 64, t -> !(t.m_41720_() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                RepairPylonCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((Level)RepairPylonCoreBlockEntity.this.f_58857_, (BlockPos)RepairPylonCoreBlockEntity.this.f_58858_);
            }
        };
        this.spiritInventory = new MalumBlockEntityInventory(4, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                RepairPylonCoreBlockEntity.this.needsSync = true;
                RepairPylonCoreBlockEntity.this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.15f, (float)RepairPylonCoreBlockEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((Level)RepairPylonCoreBlockEntity.this.f_58857_, (BlockPos)RepairPylonCoreBlockEntity.this.f_58858_);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                Item item = stack.m_41720_();
                if (!(item instanceof SpiritShardItem)) {
                    return false;
                }
                SpiritShardItem spiritItem = (SpiritShardItem)item;
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack stackInSlot;
                    if (i == slot || (stackInSlot = this.getStackInSlot(i)).m_41619_() || stackInSlot.m_41720_() != spiritItem) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public RepairPylonCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends RepairPylonCoreBlockEntity>)((BlockEntityType)BlockEntityRegistry.REPAIR_PYLON.get()), STRUCTURE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128359_("state", this.state.name);
        if (this.spiritAmount != 0.0f) {
            compound.m_128350_("spiritAmount", this.spiritAmount);
        }
        if (this.repairablePosition != null) {
            compound.m_128365_("targetedBlock", (Tag)BlockHelper.saveBlockPos((CompoundTag)new CompoundTag(), (BlockPos)this.repairablePosition));
        }
        if (this.timer != 0) {
            compound.m_128405_("timer", this.timer);
        }
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
    }

    public void m_142466_(CompoundTag compound) {
        this.state = compound.m_128441_("state") ? (RepairPylonState)CODEC.m_216455_(compound.m_128461_("state")) : RepairPylonState.IDLE;
        this.spiritAmount = compound.m_128457_("spiritAmount");
        this.repairablePosition = BlockHelper.loadBlockPos((CompoundTag)compound.m_128469_("targetedBlock"));
        this.timer = compound.m_128451_("timer");
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        super.m_142466_(compound);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            ItemStack stack;
            ItemStack heldStack = player.m_21205_();
            boolean isEmpty = heldStack.m_41619_();
            ItemStack spiritStack = this.spiritInventory.interact(this.f_58857_, player, hand);
            if (!spiritStack.m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            if (!(heldStack.m_41720_() instanceof SpiritShardItem) && !(stack = this.inventory.interact(this.f_58857_, player, hand)).m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            if (isEmpty) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.onUse(player, hand);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.f_58857_, this.f_58858_);
        this.spiritInventory.dumpItems(this.f_58857_, this.f_58858_);
        super.onBreak(player);
    }

    public void init() {
        if (this.state.equals((Object)RepairPylonState.COOLDOWN)) {
            return;
        }
        this.recipe = SpiritRepairRecipe.getRecipe(this.f_58857_, c -> c.doesRepairMatch(this.inventory.getStackInSlot(0)) && c.doSpiritsMatch(this.spiritInventory.nonEmptyItemStacks));
        if (this.recipe != null) {
            if (this.state.equals((Object)RepairPylonState.IDLE)) {
                this.setState(RepairPylonState.SEARCHING);
            }
            if (this.f_58857_.f_46443_) {
                RepairPylonSoundInstance.playSound(this);
            }
        }
    }

    public void tick() {
        super.tick();
        this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (this.f_58857_.f_46443_) {
            this.spiritSpin += 1.0f;
            if (this.state.equals((Object)RepairPylonState.COOLDOWN) && this.timer < 1200) {
                ++this.timer;
            }
            RepairPylonParticleEffects.passiveRepairPylonParticles(this);
        } else {
            if (!this.state.equals((Object)RepairPylonState.IDLE) && !this.state.equals((Object)RepairPylonState.COOLDOWN) && this.recipe == null) {
                this.setState(RepairPylonState.IDLE);
                return;
            }
            switch (this.state) {
                case IDLE: {
                    if (this.recipe == null) break;
                    this.setState(RepairPylonState.SEARCHING);
                    break;
                }
                case SEARCHING: {
                    ++this.timer;
                    if (this.timer < 40) break;
                    boolean success = this.tryRepair();
                    if (success) {
                        this.setState(RepairPylonState.CHARGING);
                        break;
                    }
                    this.timer = 0;
                    break;
                }
                case CHARGING: {
                    IMalumSpecialItemAccessPoint provider;
                    ++this.timer;
                    if (this.timer < 600) break;
                    if (this.repairablePosition == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.repairablePosition);
                    if (!(blockEntity instanceof IMalumSpecialItemAccessPoint) || !this.tryRepair(provider = (IMalumSpecialItemAccessPoint)blockEntity)) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    this.prepareRepair(provider);
                    break;
                }
                case REPAIRING: {
                    IMalumSpecialItemAccessPoint provider;
                    ++this.timer;
                    if (this.timer < 40) break;
                    if (this.repairablePosition == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.repairablePosition);
                    if (!(blockEntity instanceof IMalumSpecialItemAccessPoint) || !this.tryRepair(provider = (IMalumSpecialItemAccessPoint)blockEntity)) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    this.repairItem(provider);
                    break;
                }
                case COOLDOWN: {
                    ++this.timer;
                    if (this.timer < 1200) break;
                    this.setState(RepairPylonState.IDLE);
                }
            }
        }
    }

    public boolean tryRepair() {
        Collection altarProviders = BlockHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)6, (int)4, (int)6);
        for (IMalumSpecialItemAccessPoint provider : altarProviders) {
            boolean success = this.tryRepair(provider);
            if (!success) continue;
            this.repairablePosition = provider.getAccessPointBlockPos();
            return true;
        }
        return false;
    }

    public boolean tryRepair(IMalumSpecialItemAccessPoint provider) {
        LodestoneBlockEntityInventory inventoryForAltar = provider.getSuppliedInventory();
        SpiritRepairRecipe newRecipe = SpiritRepairRecipe.getRecipe(this.f_58857_, inventoryForAltar.getStackInSlot(0), this.inventory.getStackInSlot(0), this.spiritInventory.nonEmptyItemStacks);
        return newRecipe != null;
    }

    public void prepareRepair(IMalumSpecialItemAccessPoint provider) {
        ParticleEffectTypeRegistry.REPAIR_PYLON_PREPARES.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), ColorEffectData.fromRecipe(this.recipe.spirits), PylonPrepareRepairParticleEffect.createData(provider.getAccessPointBlockPos()));
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.REPAIR_PYLON_REPAIR_START.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
        this.setState(RepairPylonState.REPAIRING);
    }

    public void repairItem(IMalumSpecialItemAccessPoint provider) {
        LodestoneBlockEntityInventory suppliedInventory = provider.getSuppliedInventory();
        ItemStack damagedItem = suppliedInventory.getStackInSlot(0);
        ItemStack repairMaterial = this.inventory.getStackInSlot(0);
        repairMaterial.m_41774_(this.recipe.repairMaterial.getCount());
        block0: for (SpiritWithCount spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.m_41774_(spirit.count);
                continue block0;
            }
        }
        this.spiritInventory.updateData();
        ItemStack result = SpiritRepairRecipe.getRepairRecipeOutput(damagedItem);
        result.m_41721_(Math.max(0, result.m_41773_() - (int)((float)result.m_41776_() * this.recipe.durabilityPercentage)));
        suppliedInventory.setStackInSlot(0, result);
        ParticleEffectTypeRegistry.REPAIR_PYLON_REPAIRS.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), ColorEffectData.fromRecipe(this.recipe.spirits), PylonPrepareRepairParticleEffect.createData(provider.getAccessPointBlockPos()));
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.REPAIR_PYLON_REPAIR_FINISH.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
        this.setState(RepairPylonState.COOLDOWN);
    }

    public void setState(RepairPylonState state) {
        this.state = state;
        this.timer = state.equals((Object)RepairPylonState.SEARCHING) ? 100 : 0;
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public Vec3 getItemPos() {
        BlockPos blockPos = this.m_58899_();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
    }

    public Vec3 getCentralItemOffset() {
        return PYLON_ITEM_OFFSET;
    }

    public Vec3 getSpiritItemOffset(int slot, float partialTicks) {
        float distance = 0.75f + (float)Math.sin((this.spiritSpin + partialTicks) % 6.28f / 20.0f) * 0.025f;
        float height = 2.75f;
        if (this.state.equals((Object)RepairPylonState.COOLDOWN)) {
            int relativeCooldown = this.timer < 1110 ? Math.min(this.timer, 90) : 1200 - this.timer;
            distance += this.getCooldownOffset(relativeCooldown, Easing.SINE_OUT) * 0.25f;
            height -= this.getCooldownOffset(relativeCooldown, Easing.QUARTIC_OUT) * this.getCooldownOffset(relativeCooldown, (Easing)Easing.BACK_OUT) * 0.5f;
        }
        return DataHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (long)((long)(this.spiritSpin + partialTicks)), (float)360.0f);
    }

    public float getCooldownOffset(int relativeCooldown, Easing easing) {
        return easing.ease((float)relativeCooldown / 90.0f, 0.0f, 1.0f, 1.0f);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.combinedInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 4), (double)(pos.m_123343_() + 1));
    }

    public static enum RepairPylonState implements StringRepresentable
    {
        IDLE("idle"),
        SEARCHING("searching"),
        CHARGING("active"),
        REPAIRING("repairing"),
        COOLDOWN("cooldown");

        final String name;

        private RepairPylonState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

