/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.enchantment.staff;

import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.packets.SyncStaffCooldownChangesPacket;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.item.EnchantmentRegistry;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.network.PacketDistributor;

public class ReplenishingEnchantment
extends Enchantment {
    public ReplenishingEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentRegistry.STAFF_ONLY, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
    }

    public int m_6586_() {
        return 2;
    }

    public static void replenishStaffCooldown(LivingEntity attacker, ItemStack stack) {
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            Item item = stack.m_41720_();
            if (item instanceof AbstractStaffItem) {
                AbstractStaffItem staff = (AbstractStaffItem)item;
                if (player.m_36403_(0.0f) > 0.8f) {
                    ItemCooldowns cooldowns = player.m_36335_();
                    int level = stack.getEnchantmentLevel((Enchantment)EnchantmentRegistry.REPLENISHING.get());
                    if (cooldowns.m_41519_((Item)staff)) {
                        ReplenishingEnchantment.replenishStaffCooldown(staff, (Player)player, level);
                        PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncStaffCooldownChangesPacket((Item)staff, level));
                    }
                }
            }
        }
    }

    public static void replenishStaffCooldown(AbstractStaffItem staff, Player player, int pLevel) {
        ItemCooldowns cooldowns = player.m_36335_();
        int ratio = (int)((float)staff.getCooldownDuration(player.m_9236_(), (LivingEntity)player) * (0.25f * (float)pLevel));
        cooldowns.f_41516_ += ratio;
        for (Map.Entry itemCooldownInstanceEntry : cooldowns.f_41515_.entrySet()) {
            if (((Item)itemCooldownInstanceEntry.getKey()).equals(staff)) continue;
            ItemCooldowns.CooldownInstance value = (ItemCooldowns.CooldownInstance)itemCooldownInstanceEntry.getValue();
            ItemCooldowns.CooldownInstance cooldownInstance = new ItemCooldowns.CooldownInstance(value.f_41533_ + ratio, value.f_41534_ + ratio);
            cooldowns.f_41515_.put((Item)itemCooldownInstanceEntry.getKey(), cooldownInstance);
        }
    }
}

