/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class HexBoltEntity
extends AbstractBoltProjectileEntity {
    public HexBoltEntity(Level level) {
        super((EntityType<? extends AbstractBoltProjectileEntity>)((EntityType)EntityRegistry.HEX_BOLT.get()), level);
        this.f_19794_ = false;
    }

    public HexBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.m_6034_(pX, pY, pZ);
        this.f_19794_ = false;
    }

    @Override
    public int getMaxAge() {
        return 40;
    }

    @Override
    public ParticleEffectType getImpactParticleEffect() {
        return ParticleEffectTypeRegistry.HEX_BOLT_IMPACT;
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.MNEMONIC_HEX_STAFF.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.m_9236_();
        Vec3 position = this.m_20182_();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.m_20184_().m_82541_().m_82490_((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, SpiritTypeRegistry.WICKED_SPIRIT);
        lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.spawnParticles();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)this.f_19796_, (float)RandomHelper.randomBetween((RandomSource)this.f_19796_, (float)0.25f, (float)0.5f)).randomSpinOffset(this.f_19796_).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.95f));
        WorldParticleBuilder.create(ParticleRegistry.SAW, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(this.m_20184_().m_82541_())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.9f * scalar), (float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(SpiritTypeRegistry.WICKED_SPIRIT.createColorData().build()).setLifetime(Math.min(6 + this.age * 3, 30)).enableNoClip().enableForcedSpawn().addTickActor(behavior).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }
}

