/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.entity.hidden_blade.HiddenBladeDelayedImpactEntity;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.common.item.ISpiritAffiliatedItem;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.helpers.ParticleHelper;
import com.sammy.malum.registry.common.DamageTypeTagRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class CurioHiddenBladeNecklace
extends MalumCurioItem
implements IMalumEventResponderItem,
IVoidItem {
    public static final int COOLDOWN_DURATION = 200;

    public CurioHiddenBladeNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(CurioHiddenBladeNecklace.positiveEffect("scythe_counterattack", new Object[0]));
        consumer.accept(CurioHiddenBladeNecklace.positiveEffect("enhanced_maneuvers", new Object[0]));
        consumer.accept(CurioHiddenBladeNecklace.negativeEffect("pacifist_recharge", new Object[0]));
        consumer.accept(CurioHiddenBladeNecklace.negativeEffect("no_sweep", new Object[0]));
    }

    public void takeDamageEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity attacked, ItemStack stack) {
        if (attacked.m_9236_().m_5776_()) {
            return;
        }
        MalumLivingEntityDataCapability.getCapabilityOptional(attacked).ifPresent(c -> {
            if (c.hiddenBladeCounterCooldown == 0) {
                float damage = event.getAmount();
                int amplifier = Math.min(1 + Mth.m_14143_((float)(damage / 6.0f)), 10);
                MobEffect effect = (MobEffect)MobEffectRegistry.WICKED_INTENT.get();
                attacked.m_7292_(new MobEffectInstance(effect, 100, amplifier));
                SoundHelper.playSound((Entity)attacked, (SoundEvent)((SoundEvent)SoundRegistry.HIDDEN_BLADE_PRIMED.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)attacked.m_9236_().m_213780_(), (float)1.4f, (float)1.6f));
            }
        });
    }

    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        DamageSource source = event.getSource();
        Level level = attacker.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!source.m_269533_(DamageTypeTagRegistry.IS_SCYTHE)) {
            return;
        }
        if (CurioHelper.hasCurioEquipped((LivingEntity)attacker, (Item)((Item)ItemRegistry.NECKLACE_OF_THE_HIDDEN_BLADE.get()))) {
            MalumLivingEntityDataCapability.getCapabilityOptional(attacker).ifPresent(c -> {
                RandomSource random = level.m_213780_();
                if (c.hiddenBladeCounterCooldown != 0) {
                    if (c.hiddenBladeCounterCooldown <= 200) {
                        SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)SoundRegistry.HIDDEN_BLADE_DISRUPTED.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.7f, (float)0.8f));
                    }
                    c.hiddenBladeCounterCooldown = 300;
                    MalumLivingEntityDataCapability.syncSelf((ServerPlayer)attacker);
                    return;
                }
                MobEffectInstance effect = attacker.m_21124_((MobEffect)MobEffectRegistry.WICKED_INTENT.get());
                if (effect == null) {
                    return;
                }
                ItemStack scytheWeapon = SoulDataHandler.getScytheWeapon(source, attacker);
                boolean isRanged = source.m_7640_() != null;
                LivingEntity damageDealer = isRanged ? source.m_7640_() : attacker;
                Vec3 direction = isRanged ? damageDealer.m_20184_().m_82541_() : attacker.m_20154_();
                Vec3 damageCenter = damageDealer.m_20182_().m_82549_(direction);
                AttributeMap attributes = attacker.m_21204_();
                float multiplier = (float)Mth.m_14008_((double)attributes.m_22181_(Attributes.f_22283_), (double)0.0, (double)2.0) * (float)(effect.f_19504_ * 2 + 1);
                int duration = 25;
                float physicalDamage = (float)(attributes.m_22181_(Attributes.f_22281_) / (double)duration) * multiplier;
                float magicDamage = (float)(attributes.m_22181_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get()) / (double)duration) * multiplier;
                HiddenBladeDelayedImpactEntity entity = new HiddenBladeDelayedImpactEntity(level, damageCenter.f_82479_, damageCenter.f_82480_ - 3.0 + (double)(attacker.m_20206_() / 2.0f), damageCenter.f_82481_);
                entity.setData((Entity)attacker, physicalDamage, magicDamage, duration);
                entity.m_37446_(scytheWeapon);
                level.m_7967_((Entity)entity);
                c.hiddenBladeCounterCooldown = 200;
                if (!effect.m_267577_()) {
                    attacker.m_21195_(effect.m_19544_());
                }
                for (int i = 0; i < 3; ++i) {
                    SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)SoundRegistry.HIDDEN_BLADE_UNLEASHED.get()), (float)3.0f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.25f));
                }
                ParticleHelper.SlashParticleEffectBuilder particle = ParticleHelper.createSlashingEffect(ParticleEffectTypeRegistry.HIDDEN_BLADE_COUNTER_FLURRY);
                Item patt6311$temp = scytheWeapon.m_41720_();
                if (patt6311$temp instanceof ISpiritAffiliatedItem) {
                    ISpiritAffiliatedItem spiritAffiliatedItem = (ISpiritAffiliatedItem)patt6311$temp;
                    particle.setSpiritType(spiritAffiliatedItem);
                }
                particle.setRandomSlashAngle(random).mirrorRandomly(random).spawnForwardSlashingParticle((Entity)damageDealer, direction);
                MalumLivingEntityDataCapability.syncSelf((ServerPlayer)attacker);
                event.setCanceled(true);
            });
        }
    }

    public static void entityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        MalumLivingEntityDataCapability.getCapabilityOptional(entity).ifPresent(c -> {
            if (c.hiddenBladeCounterCooldown > 0) {
                --c.hiddenBladeCounterCooldown;
                if (!level.m_5776_() && c.hiddenBladeCounterCooldown == 0) {
                    SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)SoundRegistry.HIDDEN_BLADE_CHARGED.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)level.m_213780_(), (float)1.0f, (float)1.2f));
                }
            }
        });
    }

    public static class ClientOnly {
        public static int fadeOut;

        public static void tick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                int cooldown = MalumLivingEntityDataCapability.getCapability((LivingEntity)player).hiddenBladeCounterCooldown;
                if (cooldown == 0) {
                    if (player.m_21023_((MobEffect)MobEffectRegistry.WICKED_INTENT.get())) {
                        if (fadeOut > 30) {
                            fadeOut = 30;
                        }
                        fadeOut -= 2;
                        return;
                    }
                    if (fadeOut < 0) {
                        fadeOut = 20;
                    }
                    if (fadeOut < 80) {
                        ++fadeOut;
                    }
                } else {
                    fadeOut = 0;
                }
            }
        }

        public static void renderHiddenBladeCooldown(ForgeGui gui, GuiGraphics guiGraphics, int width, int height) {
            int cooldown;
            LocalPlayer player;
            Minecraft minecraft = Minecraft.m_91087_();
            PoseStack poseStack = guiGraphics.m_280168_();
            if (!(minecraft.f_91066_.f_92062_ || !gui.shouldDrawSurvivalElements() || (player = minecraft.f_91074_).m_7500_() || player.m_5833_() || (cooldown = MalumLivingEntityDataCapability.getCapability((LivingEntity)player).hiddenBladeCounterCooldown) <= 0 && fadeOut > 80)) {
                int yOffset;
                int left = width / 2 - 8;
                int top = height - 52;
                poseStack.m_85836_();
                gui.setupOverlayRenderState(true, false);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientOnly.getTexture());
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaderRegistry.DISTORTED_TEXTURE.getInstance().get();
                shaderInstance.m_173356_("YFrequency").m_5985_(15.0f);
                shaderInstance.m_173356_("XFrequency").m_5985_(15.0f);
                shaderInstance.m_173356_("Speed").m_5985_(550.0f);
                shaderInstance.m_173356_("Intensity").m_5985_(120.0f);
                VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexDefaultFormat().setShader(() -> shaderInstance);
                float size = 16.0f;
                double delta = Mth.m_14036_((float)((float)(200 - cooldown) / 200.0f), (float)0.0f, (float)1.0f);
                boolean secondRow = (delta -= 0.125) >= 0.5;
                int xOffset = 16 * Mth.m_14107_((double)(delta * 8.0)) - (secondRow ? 64 : 0);
                int n = yOffset = secondRow ? 16 : 0;
                if (fadeOut > 20) {
                    boolean hasEffect = player.m_21023_((MobEffect)MobEffectRegistry.WICKED_INTENT.get());
                    builder.setAlpha((float)(80 - fadeOut) / (hasEffect ? 10.0f : 60.0f));
                }
                builder.setPosColorTexDefaultFormat().setPositionWithWidth((float)left, (float)top, size, size).setUVWithWidth((float)xOffset, (float)yOffset, 16.0f, 16.0f, 64.0f).draw(poseStack);
                if (fadeOut > 0 && fadeOut < 20) {
                    float glow = (float)(10 - Math.abs(10 - fadeOut)) / 10.0f;
                    RenderSystem.blendFunc((int)770, (int)1);
                    builder.setAlpha(glow).draw(poseStack);
                }
                shaderInstance.setUniformDefaults();
                RenderSystem.disableBlend();
                poseStack.m_85849_();
            }
        }

        public static ResourceLocation getTexture() {
            return MalumMod.malumPath("textures/gui/hud/hidden_blade.png");
        }
    }
}

