/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons;

import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.helpers.ParticleHelper;
import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.tools.LodestoneSwordItem;

public class TyrvingItem
extends LodestoneSwordItem
implements IMalumEventResponderItem {
    public TyrvingItem(Tier material, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!event.getSource().m_269533_(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
            return;
        }
        float damage = (float)SpiritHarvestHandler.getSpiritData(target).map(d -> d.totalSpirits).orElse(0).intValue() * 2.0f;
        if (target instanceof Player) {
            damage = 4.0f * Math.max(1.0f, (1.0f + (float)target.m_21230_() / 12.0f) * (1.0f + (1.0f - 1.0f / (float)target.m_21230_())) / 12.0f);
        }
        if (target.m_6084_()) {
            target.f_19802_ = 0;
            target.m_6469_(DamageTypeHelper.create((Level)level, DamageTypeRegistry.VOODOO, (Entity)attacker), damage);
        }
        SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)SoundRegistry.TYRVING_SLASH.get()), (float)1.0f, (float)RandomHelper.randomBetween((RandomSource)attacker.m_217043_(), (float)1.0f, (float)1.5f));
        ParticleHelper.createSlashingEffect(ParticleEffectTypeRegistry.TYRVING_SLASH).setSpiritType(SpiritTypeRegistry.WICKED_SPIRIT).setVerticalSlashAngle().spawnForwardSlashingParticle((Entity)attacker);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }
}

