/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractMalumRecipe;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class FavorOfTheVoidRecipe
extends AbstractMalumRecipe {
    public static final String NAME = "favor_of_the_void";
    public final Ingredient input;
    public final ItemStack output;

    public FavorOfTheVoidRecipe(ResourceLocation id, Ingredient input, ItemStack output) {
        super(id, (RecipeSerializer)RecipeSerializerRegistry.VOID_FAVOR_RECIPE_SERIALIZER.get(), (RecipeType)RecipeTypeRegistry.VOID_FAVOR.get());
        this.input = input;
        this.output = output;
    }

    public boolean doesInputMatch(ItemStack input) {
        return this.input.test(input);
    }

    public boolean doesOutputMatch(ItemStack output) {
        return output.m_41720_().equals(this.output.m_41720_());
    }

    public static FavorOfTheVoidRecipe getRecipe(Level level, ItemStack stack) {
        return FavorOfTheVoidRecipe.getRecipe(level, (FavorOfTheVoidRecipe c) -> c.doesInputMatch(stack));
    }

    public static FavorOfTheVoidRecipe getRecipe(Level level, Predicate<FavorOfTheVoidRecipe> predicate) {
        return FavorOfTheVoidRecipe.getRecipe(level, (RecipeType)RecipeTypeRegistry.VOID_FAVOR.get(), predicate);
    }

    public static List<FavorOfTheVoidRecipe> getRecipes(Level level) {
        return FavorOfTheVoidRecipe.getRecipes(level, (RecipeType)RecipeTypeRegistry.VOID_FAVOR.get());
    }

    public static class Serializer
    implements RecipeSerializer<FavorOfTheVoidRecipe> {
        public FavorOfTheVoidRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputObject = json.getAsJsonObject("input");
            Ingredient input = Ingredient.m_43917_((JsonElement)inputObject);
            JsonObject outputObject = json.getAsJsonObject("output");
            ItemStack output = CraftingHelper.getItemStack((JsonObject)outputObject, (boolean)true);
            return new FavorOfTheVoidRecipe(recipeId, input, output);
        }

        @Nullable
        public FavorOfTheVoidRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            return new FavorOfTheVoidRecipe(recipeId, input, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, FavorOfTheVoidRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
        }
    }
}

