/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.common.recipe.AbstractMalumRecipe;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import com.sammy.malum.registry.common.recipe.RecipeTypeRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class SpiritTransmutationRecipe
extends AbstractMalumRecipe {
    public static final String NAME = "spirit_transmutation";
    public final Ingredient ingredient;
    public final ItemStack output;
    @Nullable
    public final String group;

    public SpiritTransmutationRecipe(ResourceLocation id, Ingredient ingredient, ItemStack output, @Nullable String group) {
        super(id, (RecipeSerializer)RecipeSerializerRegistry.SPIRIT_TRANSMUTATION_RECIPE_SERIALIZER.get(), (RecipeType)RecipeTypeRegistry.SPIRIT_TRANSMUTATION.get());
        this.ingredient = ingredient;
        this.output = output;
        this.group = group;
    }

    public boolean doesInputMatch(ItemStack input) {
        return this.ingredient.test(input);
    }

    public boolean doesOutputMatch(ItemStack output) {
        return output.m_41720_().equals(this.output.m_41720_());
    }

    public static SpiritTransmutationRecipe getRecipe(Level level, Item item) {
        return SpiritTransmutationRecipe.getRecipe(level, item.m_7968_());
    }

    public static SpiritTransmutationRecipe getRecipe(Level level, ItemStack item) {
        return SpiritTransmutationRecipe.getRecipe(level, (SpiritTransmutationRecipe r) -> r.doesInputMatch(item));
    }

    public static SpiritTransmutationRecipe getRecipe(Level level, Predicate<SpiritTransmutationRecipe> predicate) {
        return SpiritTransmutationRecipe.getRecipe(level, (RecipeType)RecipeTypeRegistry.SPIRIT_TRANSMUTATION.get(), predicate);
    }

    public static List<SpiritTransmutationRecipe> getRecipes(Level level) {
        return SpiritTransmutationRecipe.getRecipes(level, (RecipeType)RecipeTypeRegistry.SPIRIT_TRANSMUTATION.get());
    }

    public static class Serializer
    implements RecipeSerializer<SpiritTransmutationRecipe> {
        public SpiritTransmutationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("input"));
            ItemStack output = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("output"), (boolean)true);
            String group = json.has("group") ? json.get("group").getAsString() : null;
            return new SpiritTransmutationRecipe(recipeId, input, output, group);
        }

        @Nullable
        public SpiritTransmutationRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            String group = buffer.readBoolean() ? buffer.m_130277_() : null;
            return new SpiritTransmutationRecipe(recipeId, ingredient, output, group);
        }

        public void toNetwork(FriendlyByteBuf buffer, SpiritTransmutationRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.writeBoolean(recipe.group != null);
            if (recipe.group != null) {
                buffer.m_130070_(recipe.group);
            }
        }
    }
}

