/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.sound;

import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.sound.ExtendedSoundType;

public class RareEarthSoundType
extends ExtendedSoundType {
    public RareEarthSoundType(float volumeIn, float pitchIn, Supplier<SoundEvent> breakSoundIn, Supplier<SoundEvent> stepSoundIn, Supplier<SoundEvent> placeSoundIn, Supplier<SoundEvent> hitSoundIn, Supplier<SoundEvent> fallSoundIn) {
        super(volumeIn, pitchIn, breakSoundIn, stepSoundIn, placeSoundIn, hitSoundIn, fallSoundIn);
    }

    public void onPlayBreakSound(Level level, BlockPos pos) {
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)SoundRegistry.CTHONIC_GOLD_BREAK.get(), SoundSource.BLOCKS, (this.m_56773_() + 1.0f) / 2.0f, this.m_56774_() - level.f_46441_.m_188501_() * 0.4f, false);
    }

    public void onPlayPlaceSound(Level level, BlockPos pos, Player player) {
        level.m_5594_(player, pos, (SoundEvent)SoundRegistry.CTHONIC_GOLD_PLACE.get(), SoundSource.BLOCKS, (this.m_56773_() + 2.0f) / 2.0f, this.m_56774_() - level.f_46441_.m_188501_() * 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPlayHitSound(BlockPos pos) {
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (gameMode != null) {
            float progress = gameMode.f_105193_;
            float volume = (this.m_56773_() + progress * progress * 4.0f) / 8.0f;
            float pitch = this.m_56774_() * (0.5f + 0.15f * progress);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)SoundRegistry.QUARTZ_CLUSTER_BLOCK_HIT.get(), SoundSource.BLOCKS, volume, pitch, MalumMod.RANDOM, pos));
        }
    }
}

