/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.tree;

import com.sammy.malum.common.block.blight.BlightedGrowthBlock;
import com.sammy.malum.common.block.nature.MalumHangingLeavesBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.common.block.nature.MalumSaplingBlock;
import com.sammy.malum.common.worldgen.WorldgenHelper;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeConfiguration;
import com.sammy.malum.registry.common.block.BlockRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class RunewoodTreeFeature
extends Feature<RunewoodTreeConfiguration> {
    public static final LodestoneBlockFiller.LodestoneLayerToken LOGS = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken HANGING_LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();

    public RunewoodTreeFeature() {
        super(RunewoodTreeConfiguration.CODEC);
    }

    private int getSapBlockCount(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)2, (int)3);
    }

    private int getTrunkHeight(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)7, (int)10);
    }

    private int getSideTrunkHeight(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)0, (int)2);
    }

    private int getDownwardsBranchOffset(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)2, (int)4);
    }

    private int getBranchLength(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)2, (int)3);
    }

    private int getBranchHeight(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)3, (int)5);
    }

    public boolean m_142674_(FeaturePlaceContext<RunewoodTreeConfiguration> context) {
        Direction direction;
        int i;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RunewoodTreeConfiguration config = (RunewoodTreeConfiguration)context.m_159778_();
        if (level.m_46859_(pos.m_7495_()) || !config.sapling.m_49966_().m_60710_((LevelReader)level, pos)) {
            return false;
        }
        RandomSource rand = context.m_225041_();
        Block log = config.log;
        BlockState logState = log.m_49966_();
        LodestoneBlockFiller filler = new LodestoneBlockFiller().addLayers(new LodestoneBlockFiller.LodestoneLayerToken[]{LOGS, LEAVES, HANGING_LEAVES});
        int sapBlockCount = this.getSapBlockCount(rand);
        int trunkHeight = this.getTrunkHeight(rand);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (i = 0; i <= trunkHeight; ++i) {
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                return false;
            }
            filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
            mutable.m_122173_(Direction.UP);
        }
        for (i = 0; i < 4; ++i) {
            direction = Direction.m_122407_((int)i);
            int sideTrunkHeight = this.getSideTrunkHeight(rand);
            if (sideTrunkHeight == 0) continue;
            mutable.m_122190_((Vec3i)pos).m_122173_(direction);
            this.addDownwardsTrunkConnections(logState, level, filler, (BlockPos)mutable);
            for (int j = 0; j < sideTrunkHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
                mutable.m_122173_(Direction.UP);
            }
        }
        for (i = 0; i < 4; ++i) {
            int j;
            direction = Direction.m_122407_((int)i);
            int downwardsBranchOffset = this.getDownwardsBranchOffset(rand);
            int branchLength = this.getBranchLength(rand);
            int branchHeight = this.getBranchHeight(rand);
            mutable.m_122190_((Vec3i)pos);
            mutable.m_122175_(Direction.UP, trunkHeight - downwardsBranchOffset);
            for (j = 0; j < branchLength; ++j) {
                mutable.m_122173_(direction);
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)((BlockState)logState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()))));
            }
            for (j = 0; j < branchHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
                mutable.m_122173_(Direction.UP);
            }
            this.makeLeafBlob(config, filler, (BlockPos)mutable.m_122175_(Direction.DOWN, branchHeight));
        }
        this.makeLeafBlob(config, filler, (BlockPos)mutable.m_122190_((Vec3i)pos).m_122175_(Direction.UP, trunkHeight - 1));
        ArrayList sapBlockPositions = new ArrayList(filler.getLayer(LOGS).keySet());
        Collections.shuffle(sapBlockPositions);
        for (BlockPos blockPos : sapBlockPositions.subList(0, sapBlockCount)) {
            filler.getLayer(LOGS).replace(blockPos, e -> LodestoneBlockFiller.create((BlockState)BlockHelper.getBlockStateWithExistingProperties((BlockState)e.getState(), (BlockState)((Block)BlockRegistry.EXPOSED_RUNEWOOD_LOG.get()).m_49966_())).build());
        }
        filler.fill((LevelAccessor)level);
        WorldgenHelper.updateLeaves((LevelAccessor)level, filler.getLayer(LOGS).keySet());
        return true;
    }

    public void addDownwardsTrunkConnections(BlockState logState, WorldGenLevel level, LodestoneBlockFiller filler, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (true) {
            mutable.m_122173_(Direction.DOWN);
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) break;
            filler.getLayer(LOGS).put(mutable.m_7949_(), LodestoneBlockFiller.create((BlockState)logState));
        }
    }

    public void makeLeafBlob(RunewoodTreeConfiguration config, LodestoneBlockFiller filler, BlockPos pos) {
        int i;
        int[] leafSizes = new int[]{1, 2, 2, 2, 1};
        int[] leafColors = new int[]{0, 1, 2, 3, 4};
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        BlockState leavesState = config.leaves.m_49966_();
        BlockState hangingLeavesState = config.hangingLeaves.m_49966_();
        for (i = 0; i < 5; ++i) {
            mutable.m_122173_(Direction.UP);
            LodestoneBlockFiller.BlockStateEntry leavesEntry = LodestoneBlockFiller.create((BlockState)((BlockState)leavesState.m_61124_((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(leafColors[i])))).build();
            this.makeLeafSlice(filler.getLayer(LEAVES), (BlockPos)mutable, leafSizes[i], leavesEntry);
        }
        mutable.m_122190_((Vec3i)pos).m_122173_(Direction.DOWN);
        for (i = 0; i < 2; ++i) {
            mutable.m_122173_(Direction.UP);
            LodestoneBlockFiller.BlockStateEntry hangingLeavesEntry = LodestoneBlockFiller.create((BlockState)((BlockState)hangingLeavesState.m_61124_((Property)MalumHangingLeavesBlock.COLOR, (Comparable)Integer.valueOf(leafColors[i])))).setDiscardPredicate((l, p, s) -> !filler.getLayer(LEAVES).containsKey((Object)p.m_7494_())).build();
            this.makeLeafSlice(filler.getLayer(HANGING_LEAVES), (BlockPos)mutable, leafSizes[i], hangingLeavesEntry);
        }
    }

    public void makeLeafSlice(LodestoneBlockFiller.LodestoneBlockFillerLayer layer, BlockPos pos, int leavesSize, LodestoneBlockFiller.BlockStateEntry entry) {
        this.makeLeafSlice(layer, pos, leavesSize, () -> entry);
    }

    public void makeLeafSlice(LodestoneBlockFiller.LodestoneBlockFillerLayer layer, BlockPos pos, int leavesSize, Supplier<LodestoneBlockFiller.BlockStateEntry> entry) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                layer.put((Object)pos.m_7918_(x, 0, z), (Object)entry.get());
            }
        }
    }

    public static boolean canPlace(WorldGenLevel level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() instanceof MalumSaplingBlock || state.m_60734_() instanceof BlightedGrowthBlock || level.m_46859_(pos) || state.m_247087_();
    }
}

