/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei;

import com.google.common.collect.Maps;
import com.sammy.malum.common.recipe.FavorOfTheVoidRecipe;
import com.sammy.malum.common.recipe.RunicWorkbenchRecipe;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.common.recipe.SpiritTransmutationRecipe;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.compability.farmersdelight.FarmersDelightCompat;
import com.sammy.malum.compability.jei.HiddenRecipeSet;
import com.sammy.malum.compability.jei.categories.RuneworkingRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritFocusingRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritInfusionRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritRepairRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritRiteRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritTransmutationRecipeCategory;
import com.sammy.malum.compability.jei.categories.WeepingWellRecipeCategory;
import com.sammy.malum.compability.jei.recipes.SpiritTransmutationWrapper;
import com.sammy.malum.core.handlers.hiding.HiddenTagHandler;
import com.sammy.malum.registry.client.HiddenTagRegistry;
import com.sammy.malum.registry.common.SpiritRiteRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.compress.utils.Lists;
import team.lodestar.lodestone.systems.recipe.IRecipeComponent;

@JeiPlugin
public class JEIHandler
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("malum", "main");
    public static final RecipeType<SpiritInfusionRecipe> SPIRIT_INFUSION = new RecipeType(SpiritInfusionRecipeCategory.UID, SpiritInfusionRecipe.class);
    public static final RecipeType<SpiritTransmutationWrapper> TRANSMUTATION = new RecipeType(SpiritTransmutationRecipeCategory.UID, SpiritTransmutationWrapper.class);
    public static final RecipeType<SpiritFocusingRecipe> FOCUSING = new RecipeType(SpiritFocusingRecipeCategory.UID, SpiritFocusingRecipe.class);
    public static final RecipeType<TotemicRiteType> RITES = new RecipeType(SpiritRiteRecipeCategory.UID, TotemicRiteType.class);
    public static final RecipeType<SpiritRepairRecipe> SPIRIT_REPAIR = new RecipeType(SpiritRepairRecipeCategory.UID, SpiritRepairRecipe.class);
    public static final RecipeType<FavorOfTheVoidRecipe> WEEPING_WELL = new RecipeType(WeepingWellRecipeCategory.UID, FavorOfTheVoidRecipe.class);
    public static final RecipeType<RunicWorkbenchRecipe> RUNEWORKING = new RecipeType(RuneworkingRecipeCategory.UID, RunicWorkbenchRecipe.class);
    private static final Map<RecipeType<?>, HiddenRecipeSet<?>> hiddenRecipeSets = new HashMap();
    private static final List<UUID> callbacks = new ArrayList<UUID>();
    private static final Set<ItemStack> hiddenStacks = new LinkedHashSet<ItemStack>();

    public JEIHandler() {
        HiddenTagRegistry.blankOutHidingTags();
    }

    public static void addItemsToJei(IRecipeLayoutBuilder iRecipeLayout, RecipeIngredientRole role, int left, int top, boolean vertical, List<? extends IRecipeComponent> components) {
        int slots = components.size();
        if (vertical) {
            top -= 10 * (slots - 1);
        } else {
            left -= 10 * (slots - 1);
        }
        for (int i = 0; i < slots; ++i) {
            int offset = i * 20;
            int oLeft = left + 1 + (vertical ? 0 : offset);
            int oTop = top + 1 + (vertical ? offset : 0);
            iRecipeLayout.addSlot(role, oLeft, oTop).addItemStacks(components.get(i).getStacks());
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritInfusionRecipeCategory(guiHelper), new SpiritTransmutationRecipeCategory(guiHelper), new SpiritFocusingRecipeCategory(guiHelper), new SpiritRiteRecipeCategory(guiHelper), new SpiritRepairRecipeCategory(guiHelper), new RuneworkingRecipeCategory(guiHelper), new WeepingWellRecipeCategory(guiHelper)});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            registry.addRecipes(SPIRIT_INFUSION, SpiritInfusionRecipe.getRecipes((Level)level));
            List<SpiritTransmutationRecipe> transmutation = SpiritTransmutationRecipe.getRecipes((Level)level);
            ArrayList leftovers = Lists.newArrayList();
            LinkedHashMap groups = Maps.newLinkedHashMap();
            for (SpiritTransmutationRecipe recipe : transmutation) {
                if (recipe.group != null) {
                    List group = groups.computeIfAbsent(recipe.group, k -> Lists.newArrayList());
                    group.add(recipe);
                    continue;
                }
                leftovers.add(recipe);
            }
            registry.addRecipes(TRANSMUTATION, groups.values().stream().map(list -> list.stream().filter(it -> !it.output.m_41619_() && !it.ingredient.m_43947_()).collect(Collectors.toList())).map(SpiritTransmutationWrapper::new).collect(Collectors.toList()));
            registry.addRecipes(TRANSMUTATION, leftovers.stream().filter(it -> !it.output.m_41619_() && !it.ingredient.m_43947_()).map(List::of).map(SpiritTransmutationWrapper::new).collect(Collectors.toList()));
            registry.addRecipes(FOCUSING, SpiritFocusingRecipe.getRecipes((Level)level).stream().filter(it -> !it.output.m_41619_()).collect(Collectors.toList()));
            registry.addRecipes(RITES, SpiritRiteRegistry.RITES);
            registry.addRecipes(SPIRIT_REPAIR, SpiritRepairRecipe.getRecipes((Level)level).stream().filter(it -> !it.inputs.isEmpty()).collect(Collectors.toList()));
            registry.addRecipes(WEEPING_WELL, FavorOfTheVoidRecipe.getRecipes((Level)level).stream().filter(it -> !it.output.m_41619_()).collect(Collectors.toList()));
            registry.addRecipes(RUNEWORKING, RunicWorkbenchRecipe.getRecipes((Level)level).stream().filter(it -> !it.output.m_41619_()).collect(Collectors.toList()));
            if (FarmersDelightCompat.LOADED) {
                FarmersDelightCompat.AndJeiLoadedOnly.addInfo(registry);
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.SPIRIT_ALTAR.get()), new RecipeType[]{SPIRIT_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.SPIRIT_CRUCIBLE.get()), new RecipeType[]{FOCUSING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.REPAIR_PYLON.get()), new RecipeType[]{SPIRIT_REPAIR});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.RUNEWOOD_TOTEM_BASE.get()), new RecipeType[]{RITES});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.SOULWOOD_TOTEM_BASE.get()), new RecipeType[]{TRANSMUTATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.RUNIC_WORKBENCH.get()), new RecipeType[]{RUNEWORKING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.VOID_DEPOT.get()), new RecipeType[]{WEEPING_WELL});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
        IJeiHelpers helpers = jeiRuntime.getJeiHelpers();
        IFocusFactory focusFactory = helpers.getFocusFactory();
        HiddenTagRegistry.rebuildHidingTags();
        callbacks.add(HiddenTagHandler.registerHiddenItemListener(() -> {
            List<TagKey<Item>> output = HiddenTagHandler.tagsToHide();
            if (!hiddenStacks.isEmpty()) {
                ingredientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hiddenStacks);
                hiddenStacks.clear();
            }
            if (!output.isEmpty()) {
                Collection ingredients = ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
                for (ItemStack stack : ingredients) {
                    if (!output.stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0))) continue;
                    hiddenStacks.add(stack);
                }
                if (!hiddenStacks.isEmpty()) {
                    ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hiddenStacks);
                }
            }
            helpers.getAllRecipeTypes().forEach(it -> {
                HiddenRecipeSet hiddenRecipes = hiddenRecipeSets.computeIfAbsent((RecipeType<?>)it, HiddenRecipeSet::createSet);
                hiddenRecipes.unhidePreviouslyHiddenRecipes(recipeRegistry);
                if (!output.isEmpty()) {
                    hiddenRecipes.scanAndHideRecipes(recipeRegistry, focusFactory, output);
                }
            });
        }));
    }

    public void onRuntimeUnavailable() {
        callbacks.forEach(HiddenTagHandler::removeListener);
        callbacks.clear();
        hiddenRecipeSets.clear();
        hiddenStacks.clear();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

