/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.compability.tetra.TetraCompat;
import com.sammy.malum.registry.common.DamageTypeTagRegistry;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;

public class SoulDataHandler {
    public static final String SOUL_SHATTER_ENTITY_TAG = "malum:can_shatter_souls";
    public float exposedSoulDuration;
    public boolean soulless;
    public boolean spawnerSpawned;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.exposedSoulDuration != 0.0f) {
            tag.m_128350_("exposedSoulDuration", this.exposedSoulDuration);
        }
        tag.m_128379_("soulless", this.soulless);
        tag.m_128379_("spawnerSpawned", this.spawnerSpawned);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.exposedSoulDuration = tag.m_128457_("exposedSoulDuration");
        this.soulless = tag.m_128471_("soulless");
        this.spawnerSpawned = tag.m_128471_("spawnerSpawned");
    }

    public static void markAsSpawnerSpawned(MobSpawnEvent.PositionCheck event) {
        if (event.getSpawner() != null) {
            MalumLivingEntityDataCapability.getCapabilityOptional((LivingEntity)event.getEntity()).ifPresent(ec -> {
                SoulDataHandler soulData = ec.soulData;
                soulData.spawnerSpawned = true;
            });
        }
    }

    public static void updateAi(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            MalumLivingEntityDataCapability.getCapabilityOptional(livingEntity).ifPresent(ec -> {
                SoulDataHandler soulData = ec.soulData;
                if (livingEntity instanceof Mob) {
                    Mob mob = (Mob)livingEntity;
                    if (soulData.soulless) {
                        SoulDataHandler.removeSentience(mob);
                    }
                }
            });
        }
    }

    public static void preventTargeting(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            MalumLivingEntityDataCapability.getCapabilityOptional((LivingEntity)mob).ifPresent(ec -> {
                SoulDataHandler soulData = ec.soulData;
                if (soulData.soulless) {
                    event.setNewTarget(null);
                }
            });
        }
    }

    public static void exposeSoul(LivingHurtEvent event) {
        Entity directEntity;
        LivingEntity attacker;
        ItemStack stack;
        Entity entity;
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTagRegistry.SOUL_SHATTER_DAMAGE)) {
            SoulDataHandler.exposeSoul(target);
        }
        if ((entity = source.m_7639_()) instanceof LivingEntity && ((stack = SoulDataHandler.getSoulHunterWeapon(source, attacker = (LivingEntity)entity)).m_204117_(ItemTagRegistry.SOUL_HUNTER_WEAPON) || TetraCompat.hasSoulStrikeModifier(stack))) {
            SoulDataHandler.exposeSoul(target);
        }
        if ((directEntity = source.m_7640_()) != null && directEntity.m_19880_().contains(SOUL_SHATTER_ENTITY_TAG)) {
            SoulDataHandler.exposeSoul(target);
        }
    }

    public static void exposeSoul(LivingEntity entity) {
        SoulDataHandler soulData = MalumLivingEntityDataCapability.getCapability((LivingEntity)entity).soulData;
        soulData.exposedSoulDuration = 200.0f;
    }

    public static void livingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        SoulDataHandler soulData = MalumLivingEntityDataCapability.getCapability((LivingEntity)entity).soulData;
        if (soulData.exposedSoulDuration > 0.0f) {
            soulData.exposedSoulDuration -= 1.0f;
        }
    }

    public static void removeSentience(Mob mob) {
        mob.f_21345_.m_148105_().removeIf(g -> g.m_26015_() instanceof LookAtPlayerGoal || g.m_26015_() instanceof MeleeAttackGoal || g.m_26015_() instanceof SwellGoal || g.m_26015_() instanceof PanicGoal || g.m_26015_() instanceof RandomLookAroundGoal || g.m_26015_() instanceof AvoidEntityGoal);
    }

    public static ItemStack getScytheWeapon(DamageSource source, LivingEntity attacker) {
        ItemStack soulHunterWeapon = SoulDataHandler.getSoulHunterWeapon(source, attacker);
        return soulHunterWeapon.m_41720_() instanceof MalumScytheItem ? soulHunterWeapon : ItemStack.f_41583_;
    }

    public static ItemStack getSoulHunterWeapon(DamageSource source, LivingEntity attacker) {
        ItemStack stack = attacker.m_21205_();
        Entity entity = source.m_7640_();
        if (entity instanceof ScytheBoomerangEntity) {
            ScytheBoomerangEntity scytheBoomerang = (ScytheBoomerangEntity)entity;
            stack = scytheBoomerang.m_7846_();
        }
        return stack;
    }
}

