/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.mana_mote.SpiritMoteBlock;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.SpiritTypeBuilder;
import com.sammy.malum.core.systems.spirit.SpiritVisualMotif;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public class MalumSpiritType {
    public final String identifier;
    public final Supplier<SpiritShardItem> spiritShard;
    private final SpiritVisualMotif visualMotif;
    private final Color itemColor;
    protected Rarity itemRarity;
    protected Component spiritItemDescription;

    public static SpiritTypeBuilder create(String identifier, SpiritVisualMotif visualMotif, Supplier<SpiritShardItem> spiritShard) {
        return new SpiritTypeBuilder(identifier, visualMotif, spiritShard);
    }

    public MalumSpiritType(String identifier, SpiritVisualMotif visualMotif, Supplier<SpiritShardItem> spiritShard, Color itemColor) {
        this.identifier = identifier;
        this.spiritShard = spiritShard;
        this.visualMotif = visualMotif;
        this.itemColor = itemColor;
    }

    public float getAlphaMultiplier() {
        return this.visualMotif.getAlphaMultiplier();
    }

    public Color getPrimaryColor() {
        return this.visualMotif.getPrimaryColor();
    }

    public Color getSecondaryColor() {
        return this.visualMotif.getSecondaryColor();
    }

    public float getColorCoefficient() {
        return this.visualMotif.getColorCoefficient();
    }

    public ColorParticleDataBuilder createColorData() {
        return this.createColorData(1.0f);
    }

    public ColorParticleDataBuilder createColorData(float coefficientMultiplier) {
        return this.visualMotif.createColorData(coefficientMultiplier);
    }

    public Color getItemColor() {
        return this.itemColor;
    }

    public TextColor getTextColor(boolean isTooltip) {
        Color color = isTooltip ? ColorHelper.darker((Color)this.getPrimaryColor(), (int)1, (float)0.75f) : ColorHelper.brighter((Color)this.getPrimaryColor(), (int)1, (float)0.85f);
        return TextColor.m_131266_((int)color.getRGB());
    }

    public Rarity getItemRarity() {
        if (this.itemRarity == null) {
            TextColor textColor = this.getTextColor(false);
            this.itemRarity = Rarity.create((String)("malum$" + this.identifier), style -> style.m_131148_(textColor));
        }
        return this.itemRarity;
    }

    public Component getSpiritShardFlavourTextComponent() {
        if (this.spiritItemDescription == null) {
            this.spiritItemDescription = Component.m_237115_((String)this.getSpiritFlavourText()).m_130940_(ChatFormatting.ITALIC).m_130948_(Style.f_131099_.m_131148_(this.getTextColor(true)));
        }
        return this.spiritItemDescription;
    }

    public String getSpiritFlavourText() {
        return "malum.spirit.flavour." + this.identifier;
    }

    public Component getSpiritJarCounterComponent(int count) {
        return Component.m_237113_((String)(" " + count + " ")).m_7220_((Component)Component.m_237115_((String)this.getSpiritDescription())).m_130948_(Style.f_131099_.m_178520_(this.getPrimaryColor().getRGB()));
    }

    public String getSpiritDescription() {
        return "malum.spirit.description." + this.identifier;
    }

    public ResourceLocation getTotemGlowTexture() {
        return MalumMod.malumPath("textures/vfx/totem_poles/" + this.identifier + "_glow.png");
    }

    public BlockState getTotemPoleBlockState(boolean isCorrupt, BlockHitResult hit) {
        Block base = isCorrupt ? (Block)BlockRegistry.SOULWOOD_TOTEM_POLE.get() : (Block)BlockRegistry.RUNEWOOD_TOTEM_POLE.get();
        return (BlockState)((BlockState)base.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hit.m_82434_())).m_61124_((Property)SpiritTypeRegistry.SPIRIT_TYPE_PROPERTY, (Comparable)((Object)this.identifier));
    }

    public BlockState getSpiritMoteBlockState() {
        return (BlockState)((Block)BlockRegistry.SPIRIT_MOTE.get()).m_49966_().m_61124_((Property)SpiritMoteBlock.SPIRIT_TYPE, (Comparable)((Object)this.identifier));
    }
}

