/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class SpiritTransmutationRecipeBuilder {
    private final Ingredient ingredient;
    private final ItemStack output;
    @Nullable
    private String group = null;

    public SpiritTransmutationRecipeBuilder(Ingredient input, ItemStack output) {
        this.ingredient = input;
        this.output = output;
    }

    public SpiritTransmutationRecipeBuilder(RegistryObject<? extends ItemLike> input, RegistryObject<? extends ItemLike> output) {
        this((ItemLike)input.get(), (ItemLike)output.get());
    }

    public SpiritTransmutationRecipeBuilder(Ingredient input, Item output) {
        this(input, new ItemStack((ItemLike)output));
    }

    public SpiritTransmutationRecipeBuilder(ItemLike input, ItemStack output) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), output);
    }

    public SpiritTransmutationRecipeBuilder(ItemStack input, ItemStack output) {
        this(Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), output);
    }

    public SpiritTransmutationRecipeBuilder(ItemLike input, ItemLike output) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), new ItemStack(output));
    }

    public SpiritTransmutationRecipeBuilder(ItemStack input, ItemLike output) {
        this(Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), new ItemStack(output));
    }

    public SpiritTransmutationRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("spirit_transmutation/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, RecipeBuilder.m_176493_((ItemLike)this.output.m_41720_()).m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id));
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", SpiritTransmutationRecipeBuilder.this.ingredient.m_43942_());
            JsonElement outputObject = Ingredient.m_43927_((ItemStack[])new ItemStack[]{SpiritTransmutationRecipeBuilder.this.output}).m_43942_();
            if (SpiritTransmutationRecipeBuilder.this.output.m_41613_() != 1) {
                outputObject.getAsJsonObject().addProperty("count", (Number)SpiritTransmutationRecipeBuilder.this.output.m_41613_());
            }
            json.add("output", outputObject);
            if (SpiritTransmutationRecipeBuilder.this.group != null) {
                json.addProperty("group", SpiritTransmutationRecipeBuilder.this.group);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.SPIRIT_TRANSMUTATION_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

