/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class VoidFavorRecipeBuilder {
    private final Ingredient input;
    private final ItemStack output;

    public VoidFavorRecipeBuilder(Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public VoidFavorRecipeBuilder(Ingredient input, ItemLike output, int outputCount) {
        this(input, new ItemStack(output, outputCount));
    }

    public VoidFavorRecipeBuilder(ItemLike input, ItemStack output) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), output);
    }

    public VoidFavorRecipeBuilder(ItemLike input, ItemLike output, int outputCount) {
        this(input, new ItemStack(output, outputCount));
    }

    public VoidFavorRecipeBuilder(ItemLike input, ItemLike output) {
        this(input, new ItemStack(output));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("void_favor/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id));
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            JsonElement inputObject = VoidFavorRecipeBuilder.this.input.m_43942_();
            JsonObject outputObject = new JsonObject();
            outputObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)VoidFavorRecipeBuilder.this.output.m_41720_()).toString());
            if (VoidFavorRecipeBuilder.this.output.m_41613_() != 1) {
                outputObject.getAsJsonObject().addProperty("count", (Number)VoidFavorRecipeBuilder.this.output.m_41613_());
            }
            if (VoidFavorRecipeBuilder.this.output.m_41782_()) {
                outputObject.getAsJsonObject().addProperty("nbt", VoidFavorRecipeBuilder.this.output.m_41783_().toString());
            }
            json.add("input", inputObject);
            json.add("output", (JsonElement)outputObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.VOID_FAVOR_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

