/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.crafting;

import com.sammy.malum.data.item.MalumItemTags;
import com.sammy.malum.data.recipe.MalumVanillaRecipes;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MalumRockSetDatagen {
    private static final MalumDatagenRockSet TAINTED_ROCK = new MalumDatagenRockSet("tainted_rock", (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.SMOOTH_TAINTED_ROCK.get(), (Item)ItemRegistry.POLISHED_TAINTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK_STAIRS.get(), (Item)ItemRegistry.SMOOTH_TAINTED_ROCK_STAIRS.get(), (Item)ItemRegistry.POLISHED_TAINTED_ROCK_STAIRS.get(), (Item)ItemRegistry.TAINTED_ROCK_SLAB.get(), (Item)ItemRegistry.SMOOTH_TAINTED_ROCK_SLAB.get(), (Item)ItemRegistry.POLISHED_TAINTED_ROCK_SLAB.get(), (Item)ItemRegistry.TAINTED_ROCK_BRICKS.get(), (Item)ItemRegistry.TAINTED_ROCK_TILES.get(), (Item)ItemRegistry.SMALL_TAINTED_ROCK_BRICKS.get(), (Item)ItemRegistry.TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.TAINTED_ROCK_TILES_STAIRS.get(), (Item)ItemRegistry.SMALL_TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.TAINTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.TAINTED_ROCK_TILES_SLAB.get(), (Item)ItemRegistry.SMALL_TAINTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_BRICKS.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_TILES.get(), (Item)ItemRegistry.RUNIC_SMALL_TAINTED_ROCK_BRICKS.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_TILES_STAIRS.get(), (Item)ItemRegistry.RUNIC_SMALL_TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_TILES_SLAB.get(), (Item)ItemRegistry.RUNIC_SMALL_TAINTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.TAINTED_ROCK_WALL.get(), (Item)ItemRegistry.SMOOTH_TAINTED_ROCK_WALL.get(), (Item)ItemRegistry.POLISHED_TAINTED_ROCK_WALL.get(), (Item)ItemRegistry.TAINTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.TAINTED_ROCK_TILES_WALL.get(), (Item)ItemRegistry.SMALL_TAINTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.RUNIC_TAINTED_ROCK_TILES_WALL.get(), (Item)ItemRegistry.RUNIC_SMALL_TAINTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.TAINTED_ROCK_COLUMN.get(), (Item)ItemRegistry.TAINTED_ROCK_COLUMN_CAP.get(), (Item)ItemRegistry.CUT_TAINTED_ROCK.get(), (Item)ItemRegistry.CHECKERED_TAINTED_ROCK.get(), (Item)ItemRegistry.CHISELED_TAINTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK_PRESSURE_PLATE.get(), (Item)ItemRegistry.TAINTED_ROCK_BUTTON.get(), (Item)ItemRegistry.TAINTED_ROCK_ITEM_PEDESTAL.get(), (Item)ItemRegistry.TAINTED_ROCK_ITEM_STAND.get(), ItemTagRegistry.TAINTED_ROCK, ItemTagRegistry.TAINTED_BLOCKS, ItemTagRegistry.TAINTED_STAIRS, ItemTagRegistry.TAINTED_SLABS, ItemTagRegistry.TAINTED_WALLS);
    private static final MalumDatagenRockSet TWISTED_ROCK = new MalumDatagenRockSet("twisted_rock", (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.SMOOTH_TWISTED_ROCK.get(), (Item)ItemRegistry.POLISHED_TWISTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK_STAIRS.get(), (Item)ItemRegistry.SMOOTH_TWISTED_ROCK_STAIRS.get(), (Item)ItemRegistry.POLISHED_TWISTED_ROCK_STAIRS.get(), (Item)ItemRegistry.TWISTED_ROCK_SLAB.get(), (Item)ItemRegistry.SMOOTH_TWISTED_ROCK_SLAB.get(), (Item)ItemRegistry.POLISHED_TWISTED_ROCK_SLAB.get(), (Item)ItemRegistry.TWISTED_ROCK_BRICKS.get(), (Item)ItemRegistry.TWISTED_ROCK_TILES.get(), (Item)ItemRegistry.SMALL_TWISTED_ROCK_BRICKS.get(), (Item)ItemRegistry.TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.TWISTED_ROCK_TILES_STAIRS.get(), (Item)ItemRegistry.SMALL_TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.TWISTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.TWISTED_ROCK_TILES_SLAB.get(), (Item)ItemRegistry.SMALL_TWISTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_BRICKS.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_TILES.get(), (Item)ItemRegistry.RUNIC_SMALL_TWISTED_ROCK_BRICKS.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_TILES_STAIRS.get(), (Item)ItemRegistry.RUNIC_SMALL_TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_TILES_SLAB.get(), (Item)ItemRegistry.RUNIC_SMALL_TWISTED_ROCK_BRICKS_SLAB.get(), (Item)ItemRegistry.TWISTED_ROCK_WALL.get(), (Item)ItemRegistry.SMOOTH_TWISTED_ROCK_WALL.get(), (Item)ItemRegistry.POLISHED_TWISTED_ROCK_WALL.get(), (Item)ItemRegistry.TWISTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.TWISTED_ROCK_TILES_WALL.get(), (Item)ItemRegistry.SMALL_TWISTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.RUNIC_TWISTED_ROCK_TILES_WALL.get(), (Item)ItemRegistry.RUNIC_SMALL_TWISTED_ROCK_BRICKS_WALL.get(), (Item)ItemRegistry.TWISTED_ROCK_COLUMN.get(), (Item)ItemRegistry.TWISTED_ROCK_COLUMN_CAP.get(), (Item)ItemRegistry.CUT_TWISTED_ROCK.get(), (Item)ItemRegistry.CHECKERED_TWISTED_ROCK.get(), (Item)ItemRegistry.CHISELED_TWISTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK_PRESSURE_PLATE.get(), (Item)ItemRegistry.TWISTED_ROCK_BUTTON.get(), (Item)ItemRegistry.TWISTED_ROCK_ITEM_PEDESTAL.get(), (Item)ItemRegistry.TWISTED_ROCK_ITEM_STAND.get(), ItemTagRegistry.TWISTED_ROCK, ItemTagRegistry.TWISTED_BLOCKS, ItemTagRegistry.TWISTED_STAIRS, ItemTagRegistry.TWISTED_SLABS, ItemTagRegistry.TWISTED_WALLS);
    private static MalumDatagenRockSet cachedRockSet;

    public static void addTags(MalumItemTags provider) {
        MalumRockSetDatagen.addTags(provider, TAINTED_ROCK);
        MalumRockSetDatagen.addTags(provider, TWISTED_ROCK);
    }

    public static void buildRecipes(Consumer<FinishedRecipe> consumer) {
        MalumRockSetDatagen.buildRecipes(consumer, TAINTED_ROCK);
        MalumRockSetDatagen.buildRecipes(consumer, TWISTED_ROCK);
    }

    protected static void addTags(MalumItemTags provider, MalumDatagenRockSet rockSet) {
        provider.safeCopy(rockSet.setEncompassingTag);
        provider.safeCopy(rockSet.blockTag);
        provider.safeCopy(rockSet.stairTag);
        provider.safeCopy(rockSet.slabTag);
        provider.safeCopy(rockSet.wallTag);
    }

    protected static void buildRecipes(Consumer<FinishedRecipe> consumer, MalumDatagenRockSet rockSet) {
        InventoryChangeTrigger.TriggerInstance condition = MalumVanillaRecipes.has((ItemLike)rockSet.rock);
        cachedRockSet = rockSet;
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.rockSlab, rockSet.rock);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.smoothRockSlab, rockSet.smoothRock);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.polishedRockSlab, rockSet.polishedRock);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.rockStairs, rockSet.rock);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.smoothRockStairs, rockSet.smoothRock);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.polishedRockStairs, rockSet.polishedRock);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.rockWall, rockSet.rock);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.smoothRockWall, rockSet.smoothRock);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.polishedRockWall, rockSet.polishedRock);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.bricksSlab, rockSet.bricks);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.tilesSlab, rockSet.tiles);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.smallBricksSlab, rockSet.smallBricks);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.bricksStairs, rockSet.bricks);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.tilesStairs, rockSet.tiles);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.smallBricksStairs, rockSet.smallBricks);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.bricksWall, rockSet.bricks);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.tilesWall, rockSet.tiles);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.smallBricksWall, rockSet.smallBricks);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.runicBricksSlab, rockSet.runicBricks);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.runicTilesSlab, rockSet.runicTiles);
        MalumRockSetDatagen.shapedSlab(consumer, (ItemLike)rockSet.runicSmallBricksSlab, rockSet.runicSmallBricks);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.runicBricksStairs, rockSet.runicBricks);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.runicTilesStairs, rockSet.runicTiles);
        MalumRockSetDatagen.shapedStairs(consumer, (ItemLike)rockSet.runicSmallBricksStairs, rockSet.runicSmallBricks);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.runicBricksWall, rockSet.bricks);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.runicTilesWall, rockSet.tiles);
        MalumRockSetDatagen.shapedWall(consumer, (ItemLike)rockSet.runicSmallBricksWall, rockSet.smallBricks);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.bricks, (ItemLike)rockSet.rock);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.tiles, (ItemLike)rockSet.bricks);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.smallBricks, (ItemLike)rockSet.tiles);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.bricks, (ItemLike)rockSet.smallBricks);
        MalumRockSetDatagen.runicExchange(consumer, (ItemLike)rockSet.runicBricks, (ItemLike)rockSet.bricks);
        MalumRockSetDatagen.runicExchange(consumer, (ItemLike)rockSet.runicTiles, (ItemLike)rockSet.tiles);
        MalumRockSetDatagen.runicExchange(consumer, (ItemLike)rockSet.runicSmallBricks, (ItemLike)rockSet.smallBricks);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.runicTiles, (ItemLike)rockSet.runicBricks);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.runicSmallBricks, (ItemLike)rockSet.runicTiles);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.runicBricks, (ItemLike)rockSet.runicSmallBricks);
        MalumRockSetDatagen.shapelessButton(consumer, (ItemLike)rockSet.button, rockSet.rock);
        MalumRockSetDatagen.shapedPressurePlate(consumer, (ItemLike)rockSet.pressurePlate, rockSet.rock);
        MalumRockSetDatagen.runicExchange(consumer, (ItemLike)rockSet.smoothRock, (ItemLike)rockSet.rock);
        MalumRockSetDatagen.rockExchange(consumer, (ItemLike)rockSet.polishedRock, (ItemLike)rockSet.smoothRock);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.chiseledRock, (int)1).m_126127_(Character.valueOf('#'), (ItemLike)rockSet.polishedRockSlab).m_126130_("#").m_126130_("#").m_126132_("has_input", (CriterionTriggerInstance)condition).m_176498_(consumer);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.rock, (ItemLike)rockSet.chiseledRock);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.cutRock, (int)2).m_126127_(Character.valueOf('X'), (ItemLike)rockSet.polishedRock).m_126127_(Character.valueOf('Y'), (ItemLike)rockSet.rock).m_126130_("X").m_126130_("Y").m_126132_("has_input", (CriterionTriggerInstance)condition).m_176498_(consumer);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.rock, (ItemLike)rockSet.cutRock);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.polishedRock, (ItemLike)rockSet.cutRock);
        MalumRockSetDatagen.runicExchange(consumer, (ItemLike)rockSet.checkeredRock, (ItemLike)rockSet.cutRock);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.column, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)rockSet.rock).m_126130_("#").m_126130_("#").m_126130_("#").m_126132_("has_input", (CriterionTriggerInstance)condition).m_176498_(consumer);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.rock, (ItemLike)rockSet.column);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.columnCap, (int)2).m_126127_(Character.valueOf('X'), (ItemLike)rockSet.polishedRock).m_126127_(Character.valueOf('Y'), (ItemLike)rockSet.column).m_126130_("X").m_126130_("Y").m_126132_("has_input", (CriterionTriggerInstance)condition).m_176498_(consumer);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.rock, (ItemLike)rockSet.columnCap);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.polishedRock, (ItemLike)rockSet.columnCap);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.itemStand, (int)2).m_126127_(Character.valueOf('X'), (ItemLike)rockSet.rock).m_126127_(Character.valueOf('Y'), (ItemLike)rockSet.rockSlab).m_126130_("YYY").m_126130_("XXX").m_126132_("has_input", (CriterionTriggerInstance)condition).m_176498_(consumer);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.rock, (ItemLike)rockSet.itemStand);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.itemPedestal).m_126127_(Character.valueOf('X'), (ItemLike)rockSet.rock).m_126127_(Character.valueOf('Y'), (ItemLike)rockSet.rockSlab).m_126130_("YYY").m_126130_(" X ").m_126130_("YYY").m_126132_("has_input", (CriterionTriggerInstance)condition).m_176498_(consumer);
        MalumRockSetDatagen.stoneCutting(consumer, (ItemLike)rockSet.rock, (ItemLike)rockSet.itemPedestal);
    }

    private static void rockExchange(Consumer<FinishedRecipe> recipeConsumer, ItemLike output, ItemLike input) {
        ResourceLocation recipeID = RecipeBuilder.m_176493_((ItemLike)output).m_266382_("_from_" + RecipeBuilder.m_176493_((ItemLike)input).m_135815_());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).m_126127_(Character.valueOf('#'), input).m_126130_("##").m_126130_("##").m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has(input)).m_126140_(recipeConsumer, recipeID);
        MalumRockSetDatagen.stoneCutting(recipeConsumer, input, output);
    }

    private static void runicExchange(Consumer<FinishedRecipe> recipeConsumer, ItemLike output, ItemLike input) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)200).m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has(input)).m_176498_(recipeConsumer);
        MalumRockSetDatagen.stoneCutting(recipeConsumer, input, output);
    }

    private static void shapelessButton(Consumer<FinishedRecipe> recipeConsumer, ItemLike button, Item input) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)button).m_126209_((ItemLike)input).m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has((ItemLike)input)).m_176498_(recipeConsumer);
        MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)input, button);
    }

    private static void shapedPressurePlate(Consumer<FinishedRecipe> recipeConsumer, ItemLike pressurePlate, Item input) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)pressurePlate).m_126127_(Character.valueOf('#'), (ItemLike)input).m_126130_("##").m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has((ItemLike)input)).m_176498_(recipeConsumer);
        MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)input, pressurePlate);
    }

    private static void shapedSlab(Consumer<FinishedRecipe> recipeConsumer, ItemLike slab, Item input) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)slab, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)input).m_126130_("###").m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has((ItemLike)input)).m_176498_(recipeConsumer);
        MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)input, slab, 2);
        if (!input.equals(MalumRockSetDatagen.cachedRockSet.rock)) {
            MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)MalumRockSetDatagen.cachedRockSet.rock, slab, 2);
        }
    }

    private static void shapedStairs(Consumer<FinishedRecipe> recipeConsumer, ItemLike stairs, Item input) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)stairs, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)input).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has((ItemLike)input)).m_176498_(recipeConsumer);
        MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)input, stairs);
        if (!input.equals(MalumRockSetDatagen.cachedRockSet.rock)) {
            MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)MalumRockSetDatagen.cachedRockSet.rock, stairs);
        }
    }

    private static void shapedWall(Consumer<FinishedRecipe> recipeConsumer, ItemLike wall, Item input) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)wall, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)input).m_126130_("###").m_126130_("###").m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has((ItemLike)input)).m_176498_(recipeConsumer);
        MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)input, wall, 1);
        if (!input.equals(MalumRockSetDatagen.cachedRockSet.rock)) {
            MalumRockSetDatagen.stoneCutting(recipeConsumer, (ItemLike)MalumRockSetDatagen.cachedRockSet.rock, wall, 1);
        }
    }

    private static void stoneCutting(Consumer<FinishedRecipe> recipeConsumer, ItemLike input, ItemLike output) {
        MalumRockSetDatagen.stoneCutting(recipeConsumer, input, output, 1);
    }

    private static void stoneCutting(Consumer<FinishedRecipe> recipeConsumer, ItemLike input, ItemLike output, int outputCount) {
        ResourceLocation recipeID = RecipeBuilder.m_176493_((ItemLike)output).m_266382_("_stonecutting_from_" + RecipeBuilder.m_176493_((ItemLike)input).m_135815_());
        SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)outputCount).m_126132_("has_input", (CriterionTriggerInstance)MalumVanillaRecipes.has(input)).m_126140_(recipeConsumer, recipeID);
    }

    public record MalumDatagenRockSet(String prefix, Item rock, Item smoothRock, Item polishedRock, Item rockStairs, Item smoothRockStairs, Item polishedRockStairs, Item rockSlab, Item smoothRockSlab, Item polishedRockSlab, Item bricks, Item tiles, Item smallBricks, Item bricksStairs, Item tilesStairs, Item smallBricksStairs, Item bricksSlab, Item tilesSlab, Item smallBricksSlab, Item runicBricks, Item runicTiles, Item runicSmallBricks, Item runicBricksStairs, Item runicTilesStairs, Item runicSmallBricksStairs, Item runicBricksSlab, Item runicTilesSlab, Item runicSmallBricksSlab, Item rockWall, Item smoothRockWall, Item polishedRockWall, Item bricksWall, Item tilesWall, Item smallBricksWall, Item runicBricksWall, Item runicTilesWall, Item runicSmallBricksWall, Item column, Item columnCap, Item cutRock, Item checkeredRock, Item chiseledRock, Item pressurePlate, Item button, Item itemPedestal, Item itemStand, TagKey<Item> setEncompassingTag, TagKey<Item> blockTag, TagKey<Item> stairTag, TagKey<Item> slabTag, TagKey<Item> wallTag) {
    }
}

