/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common;

import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.core.systems.spirit.SpiritTypeProperty;
import com.sammy.malum.core.systems.spirit.SpiritVisualMotif;
import com.sammy.malum.core.systems.spirit.UmbralSpiritType;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.easing.Easing;

@Mod.EventBusSubscriber(modid="malum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpiritTypeRegistry {
    public static Map<String, MalumSpiritType> SPIRITS = new LinkedHashMap<String, MalumSpiritType>();
    public static MalumSpiritType SACRED_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("sacred", new SpiritVisualMotif(new Color(238, 44, 136), new Color(40, 143, 243), 0.8f, Easing.LINEAR), ItemRegistry.SACRED_SPIRIT).setItemColor(SpiritVisualMotif::getPrimaryColor).build());
    public static MalumSpiritType WICKED_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("wicked", new SpiritVisualMotif(new Color(121, 44, 236), new Color(72, 21, 255), 0.8f, Easing.LINEAR), ItemRegistry.WICKED_SPIRIT).setItemColor(SpiritVisualMotif::getPrimaryColor).build());
    public static MalumSpiritType ARCANE_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("arcane", new SpiritVisualMotif(new Color(213, 70, 255), new Color(32, 222, 229), 1.1f, Easing.SINE_IN_OUT), ItemRegistry.ARCANE_SPIRIT).setItemColor(c -> ColorHelper.brighter((Color)c.getPrimaryColor(), (int)1)).build());
    public static MalumSpiritType ELDRITCH_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("eldritch", new SpiritVisualMotif(new Color(203, 12, 248), new Color(24, 78, 164), 0.9f, Easing.LINEAR), ItemRegistry.ELDRITCH_SPIRIT).setItemColor(c -> ColorHelper.darker((Color)c.getPrimaryColor(), (int)1)).build());
    public static MalumSpiritType AERIAL_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("aerial", new SpiritVisualMotif(new Color(75, 243, 218), new Color(243, 218, 75), 1.1f, Easing.SINE_IN), ItemRegistry.AERIAL_SPIRIT).setItemColor(c -> ColorHelper.brighter((Color)c.getPrimaryColor(), (int)1)).build());
    public static MalumSpiritType AQUEOUS_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("aqueous", new SpiritVisualMotif(new Color(29, 100, 232), new Color(41, 238, 133), 0.8f, Easing.SINE_IN_OUT), ItemRegistry.AQUEOUS_SPIRIT).setItemColor(c -> ColorHelper.brighter((Color)c.getPrimaryColor(), (int)1)).build());
    public static MalumSpiritType EARTHEN_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("earthen", new SpiritVisualMotif(new Color(72, 238, 25), new Color(208, 26, 65), 0.9f, Easing.SINE_IN), ItemRegistry.EARTHEN_SPIRIT).setItemColor(c -> ColorHelper.brighter((Color)c.getPrimaryColor(), (int)1)).build());
    public static MalumSpiritType INFERNAL_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("infernal", new SpiritVisualMotif(new Color(250, 154, 31), new Color(210, 39, 150), 0.9f, Easing.SINE_IN_OUT), ItemRegistry.INFERNAL_SPIRIT).setItemColor(c -> ColorHelper.brighter((Color)c.getPrimaryColor(), (int)1)).build());
    public static SpiritTypeProperty SPIRIT_TYPE_PROPERTY = new SpiritTypeProperty("spirit_type", SPIRITS.values());
    public static MalumSpiritType UMBRAL_SPIRIT = SpiritTypeRegistry.register(MalumSpiritType.create("umbral", new SpiritVisualMotif(4.0f, new Color(19, 5, 24), new Color(7, 1, 1), 0.9f, Easing.SINE_IN_OUT), ItemRegistry.UMBRAL_SPIRIT).setItemColor(SpiritVisualMotif::getPrimaryColor).build(UmbralSpiritType::new));

    public static MalumSpiritType register(MalumSpiritType spiritType) {
        SPIRITS.put(spiritType.identifier, spiritType);
        return spiritType;
    }

    public static int getIndexForSpiritType(MalumSpiritType type) {
        List<MalumSpiritType> types = SPIRITS.values().stream().toList();
        return types.indexOf(type);
    }
}

