/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked;

import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class SapCollectionParticleEffect
extends ParticleEffectType {
    public SapCollectionParticleEffect(String id) {
        super(id);
    }

    public static NBTEffectData createData(Direction clickedFace) {
        NBTEffectData effectData = new NBTEffectData(new CompoundTag());
        effectData.compoundTag.m_128359_("direction", clickedFace.m_122433_());
        return effectData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.m_128441_("direction")) {
                return;
            }
            Direction direction = Direction.m_122402_((String)nbtData.compoundTag.m_128461_("direction"));
            ColorEffectData.ColorRecord colorRecord = colorData.getDefaultColorRecord();
            Color primaryColor = colorData.getPrimaryColor(colorRecord);
            Color secondaryColor = colorData.getSecondaryColor(colorRecord);
            BlockPos blockPos = positionData.getAsBlockPos();
            Vec3 pos = blockPos.m_252807_().m_231075_(direction, 0.5);
            Vec3 playerPosition = Minecraft.m_91087_().f_91074_.m_20182_();
            Vec3i normal = direction.m_122436_();
            float yRot = (float)(Mth.m_14136_((double)normal.m_123341_(), (double)normal.m_123343_()) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_()));
            Consumer<LodestoneWorldParticle> acceleration = p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)1.2f));
            for (int i = 0; i < 12; ++i) {
                float leftOffset = (random.m_188501_() - 0.5f) * 0.75f;
                float upOffset = (random.m_188501_() - 0.5f) * 0.75f;
                Vec3 particlePosition = pos.m_82549_(left.m_82490_((double)leftOffset)).m_82549_(up.m_82490_((double)upOffset));
                Vec3 particleMotion = playerPosition.m_82546_(particlePosition).m_82541_();
                Vec3 targetPosition = pos.m_82549_(particleMotion.m_82490_(0.75));
                Vec3 actualMotion = targetPosition.m_82546_(particlePosition).m_82541_().m_82490_((double)0.01f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).build());
                lightSpecs.getBuilder().act(b -> b.addTickActor(acceleration).setMotion(actualMotion).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f))));
                lightSpecs.getBloomBuilder().act(b -> b.addTickActor(acceleration).setMotion(actualMotion).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f))));
                lightSpecs.spawnParticles();
            }
        };
    }
}

