/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.config;

import com.qendolin.betterclouds.config.Config;
import com.qendolin.betterclouds.config.ConfigGUI;
import com.qendolin.betterclouds.config.ShaderPresetConfig;
import com.qendolin.betterclouds.gui.CustomButtonOption;
import com.qendolin.betterclouds.gui.CustomIntegerFieldController;
import com.qendolin.betterclouds.gui.SelectController;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.gui.controllers.ColorController;
import dev.isxander.yacl3.gui.controllers.TickBoxController;
import dev.isxander.yacl3.gui.controllers.slider.FloatSliderController;
import dev.isxander.yacl3.gui.controllers.slider.IntegerSliderController;
import dev.isxander.yacl3.gui.controllers.string.StringController;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;

public class ShaderPresetGUI {
    private final Config config;
    public final Option<Float> opacity;
    public final Option<Float> opacityFactor;
    public final Option<Float> opacityExponent;
    public final Option<Float> sunPathAngle;
    public final Option<Float> upscaleResolutionFactor;
    public final Option<Integer> selectedPreset;
    public final Option<String> presetTitle;
    public final List<Integer> worldCurvatureValues = List.of(0, -256, -512, -1024, -2048, -4096, -8192, -16384, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16);
    public final Option<Integer> worldCurvatureSize;
    public final Option<Float> saturation;
    public final Option<Color> tint;
    public final Option<Float> gamma;
    public final Option<Float> dayBrightness;
    public final Option<Float> nightBrightness;
    public final Option<Integer> sunriseStartTime;
    public final Option<Integer> sunriseEndTime;
    public final Option<Integer> sunsetStartTime;
    public final Option<Integer> sunsetEndTime;
    public final LabelOption irisDisclaimer;
    public final Option<Boolean> irisSupport;
    public final Option<Boolean> cloudOverride;
    public final Option<Boolean> useIrisFBO;
    public final ButtonOption copyPresetButton;
    public final ButtonOption removePresetButton;
    public final List<Tuple<OptionGroup.Builder, List<Option<?>>>> shadersCategory = new ArrayList();
    public final List<Option<?>> commonShadersGroup = new ArrayList();
    public final List<Option<?>> shadersGeneralGroup = new ArrayList();
    public final List<Option<?>> shadersPresetGroup = new ArrayList();
    public final List<Option<?>> shadersColorGroup = new ArrayList();
    public final List<Option<?>> shadersMiscGroup = new ArrayList();
    public final List<Option<?>> shadersTechnicalGroup = new ArrayList();
    private final List<Option<?>> shaderConfigPresetOptions = new ArrayList();
    private final List<ShaderPresetConfig> presetsToBeDeleted = new ArrayList<ShaderPresetConfig>();

    public ShaderPresetGUI(Config defaults, Config config) {
        this.config = config;
        config.addFirstPreset();
        config.sortPresets();
        this.selectedPreset = ConfigGUI.createOption(Integer.TYPE, "shaderPreset").binding(defaults.selectedPreset, () -> config.selectedPreset, val -> {
            config.selectedPreset = val;
        }).customController(opt -> new SelectController<ShaderPresetConfig>((Option<Integer>)opt, config.presets, (i, preset) -> {
            boolean deleted = this.presetsToBeDeleted.contains(preset);
            if (preset.title.isBlank()) {
                return Component.m_237115_((String)"betterclouds.config.entry.shaderPreset.untitled").m_130938_(style -> style.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)).m_178522_(Boolean.valueOf(deleted)));
            }
            if (!preset.editable) {
                return Component.m_237113_((String)preset.title).m_130938_(style -> style.m_131155_(Boolean.valueOf(true)));
            }
            return Component.m_237113_((String)preset.title).m_130938_(style -> style.m_178522_(Boolean.valueOf(deleted)));
        })).listener((opt, i) -> {
            opt.applyValue();
            Controller patt0$temp = opt.controller();
            if (patt0$temp instanceof SelectController) {
                SelectController select = (SelectController)patt0$temp;
                select.updateValues();
            }
            for (Option<?> option : this.shaderConfigPresetOptions) {
                option.forgetPendingValue();
                option.setAvailable(config.preset().editable);
            }
            this.updateNonResponsiveOptions();
        }).build();
        this.presetTitle = ConfigGUI.createOption(String.class, "presetTitle", false).binding("", () -> config.preset().title, val -> {
            config.preset().title = val;
        }).customController(StringController::new).build();
        this.saturation = ConfigGUI.createOption(Float.TYPE, "saturation").binding(Float.valueOf(defaults.preset().saturation), () -> Float.valueOf(config.preset().saturation), val -> {
            config.preset().saturation = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 2.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.tint = ConfigGUI.createOption(Color.class, "tint").binding(new Color(defaults.preset().tintRed, defaults.preset().tintGreen, defaults.preset().tintBlue), () -> new Color(config.preset().tintRed, config.preset().tintGreen, config.preset().tintBlue), val -> {
            config.preset().tintRed = (float)val.getRed() / 255.0f;
            config.preset().tintGreen = (float)val.getGreen() / 255.0f;
            config.preset().tintBlue = (float)val.getBlue() / 255.0f;
        }).customController(ColorController::new).build();
        this.gamma = ConfigGUI.createOption(Float.TYPE, "gamma").binding(Float.valueOf(defaults.preset().gamma), () -> Float.valueOf(config.preset().gamma), val -> {
            config.preset().gamma = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, -5.0f, 5.0f, 0.01f, ConfigGUI::formatAsTwoDecimals)).build();
        this.dayBrightness = ConfigGUI.createOption(Float.TYPE, "dayBrightness").binding(Float.valueOf(defaults.preset().dayBrightness), () -> Float.valueOf(config.preset().dayBrightness), val -> {
            config.preset().dayBrightness = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.1f, 4.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.nightBrightness = ConfigGUI.createOption(Float.TYPE, "nightBrightness").binding(Float.valueOf(defaults.preset().nightBrightness), () -> Float.valueOf(config.preset().nightBrightness), val -> {
            config.preset().nightBrightness = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.1f, 4.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.sunriseStartTime = ConfigGUI.createOption(Integer.TYPE, "sunriseStartTime").binding(defaults.preset().sunriseStartTime, () -> config.preset().sunriseStartTime, val -> {
            config.preset().sunriseStartTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, -6000, 6000)).build();
        this.sunriseEndTime = ConfigGUI.createOption(Integer.TYPE, "sunriseEndTime").binding(defaults.preset().sunriseEndTime, () -> config.preset().sunriseEndTime, val -> {
            config.preset().sunriseEndTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, -6000, 6000)).build();
        this.sunsetStartTime = ConfigGUI.createOption(Integer.TYPE, "sunsetStartTime").binding(defaults.preset().sunsetStartTime, () -> config.preset().sunsetStartTime, val -> {
            config.preset().sunsetStartTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, 6000, 18000)).build();
        this.sunsetEndTime = ConfigGUI.createOption(Integer.TYPE, "sunsetEndTime").binding(defaults.preset().sunsetEndTime, () -> config.preset().sunsetEndTime, val -> {
            config.preset().sunsetEndTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, 6000, 18000)).build();
        this.upscaleResolutionFactor = ConfigGUI.createOption(Float.TYPE, "upscaleResolutionFactor").binding(Float.valueOf(defaults.preset().upscaleResolutionFactor), () -> Float.valueOf(config.preset().upscaleResolutionFactor), val -> {
            config.preset().upscaleResolutionFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.25f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.sunPathAngle = ConfigGUI.createOption(Float.TYPE, "sunPathAngle").binding(Float.valueOf(defaults.preset().sunPathAngle), () -> Float.valueOf(config.preset().sunPathAngle), val -> {
            config.preset().sunPathAngle = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, -60.0f, 60.0f, 1.0f, ConfigGUI::formatAsDegrees)).build();
        this.opacityFactor = ConfigGUI.createOption(Float.TYPE, "opacityFactor").binding(Float.valueOf(defaults.preset().opacityFactor), () -> Float.valueOf(config.preset().opacityFactor), val -> {
            config.preset().opacityFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.opacityExponent = ConfigGUI.createOption(Float.TYPE, "opacityExponent").binding(Float.valueOf(defaults.preset().opacityExponent), () -> Float.valueOf(config.preset().opacityExponent), val -> {
            config.preset().opacityExponent = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.25f, 4.0f, 0.01f, ConfigGUI::formatAsTwoDecimals)).build();
        this.opacity = ConfigGUI.createOption(Float.TYPE, "opacity").binding(Float.valueOf(defaults.preset().opacity), () -> Float.valueOf(config.preset().opacity), val -> {
            config.preset().opacity = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.worldCurvatureSize = ConfigGUI.createOption(Integer.TYPE, "worldCurvatureSize").binding(Math.max(this.worldCurvatureValues.indexOf(defaults.preset().worldCurvatureSize), 0), () -> Math.max(this.worldCurvatureValues.indexOf(config.preset().worldCurvatureSize), 0), val -> {
            config.preset().worldCurvatureSize = this.worldCurvatureValues.get((int)val);
        }).customController(opt -> new IntegerSliderController(opt, 0, this.worldCurvatureValues.size() - 1, 1, i -> i == 0 ? Component.m_237115_((String)"options.off") : Component.m_237113_((String)this.worldCurvatureValues.get((int)i).toString()))).build();
        this.shaderConfigPresetOptions.addAll(List.of(this.presetTitle, this.saturation, this.tint, this.gamma, this.dayBrightness, this.nightBrightness, this.sunriseStartTime, this.sunriseEndTime, this.sunsetStartTime, this.sunsetEndTime, this.upscaleResolutionFactor, this.sunPathAngle, this.opacityFactor, this.opacityExponent, this.opacity, this.worldCurvatureSize));
        this.shaderConfigPresetOptions.forEach(opt -> opt.setAvailable(config.preset().editable));
        MutableComponent removeButtonRemoveText = Component.m_237115_((String)"betterclouds.config.entry.shaderPreset.remove");
        MutableComponent removeButtonRestoreText = Component.m_237115_((String)"betterclouds.config.entry.shaderPreset.restore");
        this.removePresetButton = CustomButtonOption.createBuilder().name(() -> this.lambda$new$56(config, (Component)removeButtonRestoreText, (Component)removeButtonRemoveText)).available(config.presets.size() > 1).action((screen, option) -> {
            if (config.presets.size() <= 1 || !config.preset().editable) {
                option.setAvailable(false);
                return;
            }
            if (this.presetsToBeDeleted.contains(config.preset())) {
                this.presetsToBeDeleted.remove(config.preset());
            } else {
                this.presetsToBeDeleted.add(config.preset());
            }
        }).build();
        this.updateNonResponsiveOptions();
        this.copyPresetButton = CustomButtonOption.createBuilder().name(() -> Component.m_237115_((String)"betterclouds.config.entry.shaderPreset.copy")).action((screen, buttonOption) -> {
            ShaderPresetConfig preset = new ShaderPresetConfig(config.preset());
            preset.title = Component.m_237110_((String)"betterclouds.config.entry.shaderPreset.copyOf", (Object[])new Object[]{config.preset().title}).getString();
            preset.markAsCopy();
            config.presets.add(0, preset);
            this.selectedPreset.requestSet((Object)0);
            Controller patt0$temp = this.selectedPreset.controller();
            if (patt0$temp instanceof SelectController) {
                SelectController select = (SelectController)patt0$temp;
                select.updateValues();
            }
            this.updateNonResponsiveOptions();
        }).build();
        this.irisDisclaimer = LabelOption.create((Component)Component.m_237115_((String)"betterclouds.config.text.shaders"));
        this.irisSupport = ConfigGUI.createOption(Boolean.TYPE, "irisSupport").binding(defaults.irisSupport, () -> config.irisSupport, val -> {
            config.irisSupport = val;
        }).customController(TickBoxController::new).build();
        this.cloudOverride = ConfigGUI.createOption(Boolean.TYPE, "cloudOverride").binding(defaults.cloudOverride, () -> config.cloudOverride, val -> {
            config.cloudOverride = val;
        }).customController(TickBoxController::new).build();
        this.useIrisFBO = ConfigGUI.createOption(Boolean.TYPE, "useIrisFBO").binding(defaults.useIrisFBO, () -> config.useIrisFBO, val -> {
            config.useIrisFBO = val;
        }).customController(TickBoxController::new).build();
        this.commonShadersGroup.addAll(List.of(this.irisDisclaimer, this.irisSupport, this.gamma, this.dayBrightness, this.nightBrightness, this.sunPathAngle));
        this.shadersCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.general")), this.shadersGeneralGroup));
        this.shadersGeneralGroup.addAll(List.of(this.irisDisclaimer, this.irisSupport, this.cloudOverride));
        this.shadersCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.presets")), this.shadersPresetGroup));
        this.shadersPresetGroup.addAll(List.of(this.selectedPreset, this.presetTitle, this.copyPresetButton, this.removePresetButton));
        this.shadersCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.color")), this.shadersColorGroup));
        this.shadersColorGroup.addAll(List.of(this.gamma, this.dayBrightness, this.nightBrightness, this.saturation, this.tint));
        this.shadersCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.misc")), this.shadersMiscGroup));
        this.shadersMiscGroup.add(this.worldCurvatureSize);
        this.shadersCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.technical")), this.shadersTechnicalGroup));
        this.shadersTechnicalGroup.addAll(List.of(this.sunPathAngle, this.sunriseStartTime, this.sunriseEndTime, this.sunsetStartTime, this.sunsetEndTime, this.upscaleResolutionFactor, this.useIrisFBO));
    }

    private void updateNonResponsiveOptions() {
        if (this.removePresetButton != null) {
            this.removePresetButton.setAvailable(this.config.preset().editable && this.config.presets.size() > 1);
        }
        if (this.presetTitle != null) {
            String title = this.config.preset().title;
            this.presetTitle.stateManager().set((Object)(title + " "));
            this.presetTitle.stateManager().set((Object)title);
        }
    }

    public void onSave() {
        for (ShaderPresetConfig preset : this.presetsToBeDeleted) {
            this.config.presets.remove(preset);
        }
    }

    private /* synthetic */ Component lambda$new$56(Config config, Component removeButtonRestoreText, Component removeButtonRemoveText) {
        return this.presetsToBeDeleted.contains(config.preset()) ? removeButtonRestoreText : removeButtonRemoveText;
    }
}

