/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.platform;

import com.qendolin.betterclouds.platform.ModVersion;
import com.qendolin.betterclouds.platform.forge.ModVersionImpl;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public final class ModLoader {
    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static boolean isModLoaded(String modId) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modId);
        }
        LoadingModList loadingModList = LoadingModList.get();
        if (loadingModList != null) {
            return loadingModList.getModFileById(modId) != null;
        }
        return false;
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static boolean isClientEnvironment() {
        return FMLLoader.getDist().isClient();
    }

    public static ModVersion getModVersion(String modId) {
        ModList modList = ModList.get();
        if (modList == null) {
            LoadingModList loadingModList = LoadingModList.get();
            for (ModInfo mod : loadingModList.getMods()) {
                if (!Objects.equals(mod.getModId(), modId)) continue;
                return new ModVersionImpl(mod.getVersion());
            }
            return ModVersion.NONE;
        }
        Optional mod = modList.getModContainerById(modId);
        if (mod.isEmpty()) {
            return ModVersion.NONE;
        }
        return new ModVersionImpl(((ModContainer)mod.get()).getModInfo().getVersion());
    }
}

