/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.compat.emi.stack;

import cc.abbie.emi_ores.EmiOres;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.biome.Biome;

public class BiomeEmiStack
extends EmiStack {
    private static final ResourceLocation missingSpriteId = EmiOres.id("emi_ores/biome_icon/missing");
    private final Biome biome;
    private final TextureAtlasSprite sprite;

    private BiomeEmiStack(Biome biome) {
        TextureAtlasSprite sprite;
        this.biome = biome;
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        ResourceLocation id = this.getId();
        if (id == null) {
            sprite = atlas.m_118316_(missingSpriteId);
        } else {
            sprite = atlas.m_118316_(this.getId().m_246208_("emi_ores/biome_icon/"));
            if (MissingTextureAtlasSprite.m_118071_().equals((Object)sprite.m_245424_().m_246162_())) {
                sprite = atlas.m_118316_(missingSpriteId);
            }
        }
        this.sprite = sprite;
    }

    public static EmiStack of(Biome biome, CompoundTag tag, long amount) {
        return new BiomeEmiStack(biome);
    }

    public static EmiStack of(Biome biome) {
        return BiomeEmiStack.of(biome, null, 0L);
    }

    public EmiStack copy() {
        return new BiomeEmiStack(this.biome);
    }

    public void render(GuiGraphics gui, int x, int y, float delta, int flags) {
        if ((flags & 1) != 0) {
            PoseStack pose = gui.m_280168_();
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 150.0f);
            gui.m_280159_(x, y, 0, 16, 16, this.sprite);
            pose.m_85849_();
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public CompoundTag getNbt() {
        return null;
    }

    public Object getKey() {
        return this.biome;
    }

    public ResourceLocation getId() {
        return Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)this.biome);
    }

    public List<Component> getTooltipText() {
        return null;
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
        list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)this.getName().m_7532_()));
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)this.getId().toString()).m_130940_(ChatFormatting.DARK_GRAY).m_7532_()));
        }
        EmiTooltipComponents.appendModName(list, (String)this.getId().m_135827_());
        list.addAll(super.getTooltip());
        return list;
    }

    public Component getName() {
        return Component.m_237115_((String)this.getId().m_214296_("biome"));
    }

    public static class Serializer
    implements EmiStackSerializer<BiomeEmiStack> {
        public String getType() {
            return "biome";
        }

        public EmiStack create(ResourceLocation id, CompoundTag nbt, long amount) {
            Registry biomeRegistry = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_);
            return BiomeEmiStack.of((Biome)biomeRegistry.m_123013_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id)), nbt, amount);
        }
    }
}

