/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.LeafCarpetBlock;
import org.violetmoon.quark.content.world.block.BlossomLeavesBlock;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;
import org.violetmoon.zeta.client.AlikeColorHandler;
import org.violetmoon.zeta.client.event.load.ZAddBlockColorHandlers;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZLoadComplete;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.VanillaWoods;

@ZetaLoadModule(category="building", antiOverlap={"woodworks", "immersive_weathering"})
public class LeafCarpetModule
extends ZetaModule {
    public static List<LeafCarpetBlock> carpets = new LinkedList<LeafCarpetBlock>();

    @LoadEvent
    public final void register(ZRegister event) {
        for (VanillaWoods.Wood wood : VanillaWoods.OVERWORLD_WITH_TREE) {
            this.carpet(wood.leaf());
        }
        this.carpet(Blocks.f_152470_);
        this.carpet(Blocks.f_152471_);
    }

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        BlossomTreesModule.blossomTrees.stream().map(t -> t.leaves).forEach(this::blossomCarpet);
        this.carpetBlock(AncientWoodModule.ancient_leaves).setCondition(() -> Quark.ZETA.modules.isEnabled(AncientWoodModule.class));
    }

    @LoadEvent
    public void loadComplete(ZLoadComplete event) {
        event.enqueueWork(() -> {
            for (LeafCarpetBlock c : carpets) {
                if (c.m_5456_() == null) continue;
                ComposterBlock.f_51914_.put((Object)c.m_5456_(), 0.2f);
            }
        });
    }

    private void carpet(Block base) {
        this.carpetBlock(base);
    }

    private void blossomCarpet(BlossomLeavesBlock base) {
        this.carpetBlock((Block)base).setCondition(() -> ((BlossomLeavesBlock)base).isEnabled());
    }

    private LeafCarpetBlock carpetBlock(Block base) {
        LeafCarpetBlock carpet = new LeafCarpetBlock(Quark.ZETA.registryUtil.inherit(base, s -> s.replaceAll("_leaves", "_leaf_carpet")), base, this);
        carpets.add(carpet);
        return carpet;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends LeafCarpetModule {
        @LoadEvent
        public void blockColorHandlers(ZAddBlockColorHandlers event) {
            event.registerNamed(this.zeta(), b -> new AlikeColorHandler((Block)((LeafCarpetBlock)((Object)b)), LeafCarpetBlock::getBaseState), new String[]{"leaf_carpet"});
        }

        @LoadEvent
        public void itemColorHandlers(ZAddItemColorHandlers event) {
            event.registerNamed(this.zeta(), i -> new AlikeColorHandler(i, LeafCarpetBlock::getBaseState), new String[]{"leaf_carpet"});
        }
    }
}

