/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.mobs.entity.Stoneling;

public class StonelingModel
extends EntityModel<Stoneling> {
    private final ModelPart body;
    private final ModelPart arm_right;
    private final ModelPart arm_left;
    private final ModelPart leg_right;
    private final ModelPart leg_left;

    public StonelingModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.arm_right = root.m_171324_("arm_right");
        this.arm_left = root.m_171324_("arm_left");
        this.leg_right = root.m_171324_("leg_right");
        this.leg_left = root.m_171324_("leg_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -9.0f, -3.0f, 8.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(36, 13).m_171488_(-4.0f, -2.0f, -4.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 7).m_171488_(-4.0f, -9.0f, -5.0f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(23, 0).m_171488_(-2.0f, -12.0f, -1.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(30, 7).m_171488_(-2.0f, -9.0f, -6.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(25, 24).m_171488_(-2.0f, -12.0f, -5.0f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(36, 17).m_171488_(-2.0f, -11.0f, 3.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-2.0f, -2.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)0.0f));
        body.m_171599_("lychen", CubeListBuilder.m_171558_().m_171514_(10, 12).m_171488_(0.0f, -4.0f, -2.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(10, 16).m_171488_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-9.0f, (float)3.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        body.m_171599_("dripstone", CubeListBuilder.m_171558_().m_171514_(14, 16).m_171488_(0.0f, -5.0f, -3.0f, 0.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(14, 22).m_171488_(-3.0f, -5.0f, 0.0f, 6.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        root.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(27, 13).m_171488_(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.25f, (float)19.0f, (float)0.5f));
        root.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(27, 13).m_171480_().m_171488_(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.25f, (float)19.0f, (float)0.5f));
        root.m_171599_("arm_right", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, 0.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)15.0f, (float)0.5f));
        root.m_171599_("arm_left", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(0.0f, 0.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)15.0f, (float)0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Stoneling stoneling, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leg_right.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leg_left.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        ItemStack carry = stoneling.getCarryingItem();
        if (carry.m_41619_() && !stoneling.m_20160_()) {
            this.arm_right.f_104203_ = 0.0f;
            this.arm_left.f_104203_ = 0.0f;
        } else {
            this.arm_right.f_104203_ = 3.1416f;
            this.arm_left.f_104203_ = 3.1416f;
        }
    }

    public void m_7695_(@NotNull PoseStack matrix, @NotNull VertexConsumer vb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.body.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.arm_right.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.arm_left.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leg_right.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leg_left.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

