/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class IotaType<T extends Iota> {
    @javax.annotation.Nullable
    public abstract T deserialize(Tag var1, ServerLevel var2) throws IllegalArgumentException;

    public abstract Component display(Tag var1);

    public abstract int color();

    public Component typeName() {
        ResourceLocation key = HexIotaTypes.REGISTRY.m_7981_((Object)this);
        return Component.m_237115_((String)("hexcasting.iota." + key)).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)this.color())));
    }

    public static CompoundTag serialize(Iota iota) {
        IotaType<?> type = iota.getType();
        ResourceLocation typeId = HexIotaTypes.REGISTRY.m_7981_(type);
        if (typeId == null) {
            throw new IllegalStateException("Tried to serialize an unregistered iota type. Iota: " + iota + " ; Type" + type.getClass().getTypeName());
        }
        if (IotaType.isTooLargeToSerialize(List.of(iota), 0)) {
            return IotaType.serialize(new GarbageIota());
        }
        Tag dataTag = iota.serialize();
        CompoundTag out = new CompoundTag();
        out.m_128359_("hexcasting:type", typeId.toString());
        out.m_128365_("hexcasting:data", dataTag);
        return out;
    }

    public static boolean isTooLargeToSerialize(Iterable<Iota> examinee) {
        return IotaType.isTooLargeToSerialize(examinee, 1);
    }

    private static boolean isTooLargeToSerialize(Iterable<Iota> examinee, int startingCount) {
        int totalSize = startingCount;
        for (Iota iota : examinee) {
            if (iota.depth() >= 256) {
                return true;
            }
            totalSize += iota.size();
        }
        return totalSize >= 1024;
    }

    @Nullable
    public static IotaType<?> getTypeFromTag(CompoundTag tag) {
        if (!tag.m_128425_("hexcasting:type", 8)) {
            return null;
        }
        String typeKey = tag.m_128461_("hexcasting:type");
        if (!ResourceLocation.m_135830_((String)typeKey)) {
            return null;
        }
        ResourceLocation typeLoc = new ResourceLocation(typeKey);
        return (IotaType)HexIotaTypes.REGISTRY.m_7745_(typeLoc);
    }

    public static Iota deserialize(CompoundTag tag, ServerLevel world) {
        Iota deserialized;
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return new GarbageIota();
        }
        Tag data = tag.m_128423_("hexcasting:data");
        if (data == null) {
            return new GarbageIota();
        }
        try {
            deserialized = Objects.requireNonNullElse(type.deserialize(data, world), new NullIota());
        }
        catch (IllegalArgumentException exn) {
            HexAPI.LOGGER.warn("Caught an exception deserializing an iota", (Throwable)exn);
            deserialized = new GarbageIota();
        }
        return deserialized;
    }

    private static Component brokenIota() {
        return Component.m_237115_((String)"hexcasting.spelldata.unknown").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    public static Component getDisplay(CompoundTag tag) {
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return IotaType.brokenIota();
        }
        Tag data = tag.m_128423_("hexcasting:data");
        if (data == null) {
            return IotaType.brokenIota();
        }
        return type.display(data);
    }

    public static FormattedCharSequence getDisplayWithMaxWidth(CompoundTag tag, int maxWidth, Font font) {
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return IotaType.brokenIota().m_7532_();
        }
        Tag data = tag.m_128423_("hexcasting:data");
        if (data == null) {
            return IotaType.brokenIota().m_7532_();
        }
        Component display = type.display(data);
        List splitted = font.m_92923_((FormattedText)display, maxWidth - font.m_92895_("..."));
        if (splitted.isEmpty()) {
            return FormattedCharSequence.f_13691_;
        }
        if (splitted.size() == 1) {
            return (FormattedCharSequence)splitted.get(0);
        }
        FormattedCharSequence first = (FormattedCharSequence)splitted.get(0);
        return FormattedCharSequence.m_13733_((FormattedCharSequence)first, (FormattedCharSequence)Component.m_237113_((String)"...").m_130940_(ChatFormatting.GRAY).m_7532_());
    }

    public static int getColor(CompoundTag tag) {
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return -524040;
        }
        return type.color();
    }
}

