/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.client.render.HexPatternLike;
import at.petrak.hexcasting.client.render.HexPatternPoints;
import at.petrak.hexcasting.client.render.PatternSettings;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec2;

public class PatternTextureManager {
    public static boolean useTextures = true;
    public static int repaintIndex = 0;
    private static final ConcurrentMap<String, Map<String, ResourceLocation>> patternTexturesToAdd = new ConcurrentHashMap<String, Map<String, ResourceLocation>>();
    private static final Set<String> inProgressPatterns = new HashSet<String>();
    private static final ExecutorService executor = new ThreadPoolExecutor(0, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    private static final HashMap<String, Map<String, ResourceLocation>> patternTextures = new HashMap();

    public static Optional<Map<String, ResourceLocation>> getTextures(HexPatternLike patternlike, PatternSettings patSets, double seed, int resPerUnit) {
        String patCacheKey = patSets.getCacheKey(patternlike, seed) + "_" + resPerUnit;
        if (patternTexturesToAdd.containsKey(patCacheKey)) {
            Map patternTexture = (Map)patternTexturesToAdd.remove(patCacheKey);
            Map<String, ResourceLocation> oldPatternTexture = patternTextures.put(patCacheKey, patternTexture);
            inProgressPatterns.remove(patCacheKey);
            if (oldPatternTexture != null) {
                for (ResourceLocation oldPatternTextureSingle : oldPatternTexture.values()) {
                    Minecraft.m_91087_().m_91097_().m_118506_(oldPatternTextureSingle).close();
                }
            }
            return Optional.empty();
        }
        if (patternTextures.containsKey(patCacheKey)) {
            return Optional.of(patternTextures.get(patCacheKey));
        }
        if (!inProgressPatterns.contains(patCacheKey)) {
            inProgressPatterns.add(patCacheKey);
            executor.submit(() -> {
                Map<String, DynamicTexture> slowTextures = PatternTextureManager.createTextures(patternlike, patSets, seed, resPerUnit);
                Minecraft.m_91087_().execute(() -> PatternTextureManager.registerTextures(patCacheKey, slowTextures));
            });
        }
        return Optional.empty();
    }

    private static Map<String, DynamicTexture> createTextures(HexPatternLike patternlike, PatternSettings patSets, double seed, int resPerUnit) {
        HexPatternPoints staticPoints = HexPatternPoints.getStaticPoints(patternlike, patSets, seed);
        List<Vec2> zappyRenderSpace = staticPoints.scaleVecs((List<Vec2>)staticPoints.zappyPoints);
        HashMap<String, DynamicTexture> patTexts = new HashMap<String, DynamicTexture>();
        NativeImage innerLines = PatternTextureManager.drawLines(zappyRenderSpace, staticPoints, (float)patSets.getInnerWidth(staticPoints.finalScale), resPerUnit);
        patTexts.put("inner", new DynamicTexture(innerLines));
        NativeImage outerLines = PatternTextureManager.drawLines(zappyRenderSpace, staticPoints, (float)patSets.getOuterWidth(staticPoints.finalScale), resPerUnit);
        patTexts.put("outer", new DynamicTexture(outerLines));
        return patTexts;
    }

    private static Map<String, ResourceLocation> registerTextures(String patTextureKeyBase, Map<String, DynamicTexture> dynamicTextures) {
        HashMap<String, ResourceLocation> resLocs = new HashMap<String, ResourceLocation>();
        for (Map.Entry<String, DynamicTexture> textureEntry : dynamicTextures.entrySet()) {
            String name = "hex_pattern_texture_" + patTextureKeyBase + "_" + textureEntry.getKey() + "_" + repaintIndex + ".png";
            ResourceLocation resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_(name, textureEntry.getValue());
            resLocs.put(textureEntry.getKey(), resourceLocation);
        }
        patternTexturesToAdd.put(patTextureKeyBase, resLocs);
        return resLocs;
    }

    private static NativeImage drawLines(List<Vec2> points, HexPatternPoints staticPoints, float unscaledLineWidth, int resPerUnit) {
        NativeImage nativeImage = new NativeImage((int)(staticPoints.fullWidth * (double)resPerUnit), (int)(staticPoints.fullHeight * (double)resPerUnit), true);
        for (int i = 0; i < points.size() - 1; ++i) {
            Tuple<Integer, Integer> pointFrom = PatternTextureManager.getTextureCoordinates(points.get(i), staticPoints, resPerUnit);
            Tuple<Integer, Integer> pointTo = PatternTextureManager.getTextureCoordinates(points.get(i + 1), staticPoints, resPerUnit);
            PatternTextureManager.drawLine(nativeImage, (Integer)pointFrom.m_14418_(), (Integer)pointFrom.m_14419_(), (Integer)pointTo.m_14418_(), (Integer)pointTo.m_14419_(), unscaledLineWidth * (float)resPerUnit);
        }
        return nativeImage;
    }

    private static void drawLine(NativeImage image, int x0, int y0, int x1, int y1, float width) {
        Line2D.Float line = new Line2D.Float(x0, y0, x1, y1);
        Rectangle bounds = line.getBounds();
        double halfWidth = width / 2.0f;
        for (int x = (int)((float)bounds.x - width - 1.0f); x < (int)((float)(bounds.x + bounds.width) + width + 1.0f); ++x) {
            for (int y = (int)((float)bounds.y - width - 1.0f); y < (int)((float)(bounds.y + bounds.height) + width + 1.0f); ++y) {
                double dist = line.ptSegDist(x, y);
                int alpha = (int)(Mth.m_14008_((double)(halfWidth - dist + 0.5), (double)0.0, (double)1.0) * 255.0);
                if (alpha <= 0) continue;
                int oldAlpha = FastColor.ARGB32.m_13655_((int)image.m_84985_(x, y));
                int newAlpha = Math.max(oldAlpha, alpha);
                image.m_84988_(x, y, 0xFFFFFF | newAlpha << 24);
            }
        }
    }

    private static Tuple<Integer, Integer> getTextureCoordinates(Vec2 point, HexPatternPoints staticPoints, int resPerUnit) {
        int x = (int)(point.f_82470_ * (float)resPerUnit);
        int y = (int)(point.f_82471_ * (float)resPerUnit);
        return new Tuple((Object)x, (Object)y);
    }

    public static void repaint() {
        ++repaintIndex;
        patternTexturesToAdd.clear();
        patternTextures.clear();
    }
}

