/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen.xplat;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockBooleanDirectrix;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockRedstoneDirectrix;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.paucal.api.forge.datagen.PaucalBlockStateAndModelProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class HexBlockStatesAndModels
extends PaucalBlockStateAndModelProvider {
    public HexBlockStatesAndModels(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "hexcasting", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModelFile.ExistingModelFile slateModel = this.models().getExistingFile(this.modLoc("slate"));
        this.getVariantBuilder(HexBlocks.SLATE).forAllStatesExcept(bs -> {
            int rotationX = 0;
            int rotationY = 0;
            switch ((AttachFace)bs.m_61143_(BlockSlate.ATTACH_FACE)) {
                case CEILING: {
                    rotationX = 180;
                    break;
                }
                case WALL: {
                    rotationX = 90;
                    rotationY = ((Direction)bs.m_61143_((Property)BlockSlate.FACING)).m_122424_().m_122416_() * 90;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)slateModel).rotationX(rotationX).rotationY(rotationY).uvLock(true).build();
        }, new Property[]{BlockSlate.WATERLOGGED});
        this.impetus(HexBlocks.IMPETUS_EMPTY, "impetus/empty", "empty", false);
        this.impetus(HexBlocks.IMPETUS_RIGHTCLICK, "impetus/rightclick", "rightclick", true);
        this.impetus(HexBlocks.IMPETUS_LOOK, "impetus/look", "look", true);
        this.impetus(HexBlocks.IMPETUS_REDSTONE, "impetus/redstone", "redstone", true);
        this.doAllTheDirectrices();
        BlockModelBuilder akashicRecordModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("akashic_record", "block/block")).renderType("translucent")).texture("inner", this.modLoc("block/akashic_ligature"))).texture("outer", this.modLoc("block/akashic_record"))).texture("particle", this.modLoc("block/akashic_ligature"))).element().cube("#outer").end()).element().from(15.75f, 15.75f, 15.75f).to(0.25f, 0.25f, 0.25f).allFaces((dir, builder) -> builder.texture("#inner").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN)).end();
        this.simpleBlock(HexBlocks.AKASHIC_RECORD, (ModelFile)akashicRecordModel);
        this.simpleBlockItem(HexBlocks.AKASHIC_RECORD, (ModelFile)akashicRecordModel);
        this.blockAndItem(HexBlocks.AKASHIC_LIGATURE, (BlockModelBuilder)this.models().cubeAll("akashic_ligature", this.modLoc("block/akashic_ligature")));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("akashic_bookshelf")).renderType("cutout")).texture("front", this.modLoc("block/akashic_bookshelf"))).texture("side", this.modLoc("block/akashic_bookshelf_horiz"))).texture("top_bottom", this.modLoc("block/akashic_bookshelf_vert"))).texture("particle", this.modLoc("block/akashic_bookshelf_vert"))).element().allFaces((dir, builder) -> builder.texture(switch (dir) {
            case Direction.DOWN, Direction.UP -> "#top_bottom";
            case Direction.EAST, Direction.SOUTH, Direction.WEST -> "#side";
            default -> "#front";
        }).cullface(dir)).end()).element().face(Direction.NORTH).texture("#overlay").cullface(Direction.NORTH).tintindex(0);
        this.getVariantBuilder(HexBlocks.AKASHIC_BOOKSHELF).forAllStates(bs -> {
            Direction dir = (Direction)bs.m_61143_((Property)BlockAkashicBookshelf.FACING);
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            if (((Boolean)bs.m_61143_((Property)BlockAkashicBookshelf.HAS_BOOKS)).booleanValue()) {
                for (int i = 1; i <= 4; ++i) {
                    BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("akashic_bookshelf_" + i, this.modLoc("block/akashic_bookshelf"))).texture("overlay", this.modLoc("block/akashic_bookshelf_overlay_" + i));
                    builder.modelFile((ModelFile)model).rotationY(dir.m_122424_().m_122416_() * 90).uvLock(true);
                    if (i >= 4) continue;
                    builder = builder.nextModel();
                }
            } else {
                BlockModelBuilder model = (BlockModelBuilder)this.models().orientable("akashic_bookshelf_empty", this.modLoc("block/akashic_bookshelf_horiz"), this.modLoc("block/akashic_bookshelf"), this.modLoc("block/akashic_bookshelf_vert"));
                if (dir == Direction.NORTH) {
                    this.simpleBlockItem(HexBlocks.AKASHIC_BOOKSHELF, (ModelFile)model);
                }
                builder.modelFile((ModelFile)model).rotationY(dir.m_122424_().m_122416_() * 90).uvLock(true);
            }
            return builder.build();
        });
        this.blockAndItem(HexBlocks.SLATE_BLOCK, (BlockModelBuilder)this.models().cubeAll("slate_block", this.modLoc("block/slate")));
        this.blockAndItem(HexBlocks.SLATE_TILES, (BlockModelBuilder)this.models().cubeAll("block/deco/slate_tiles", this.modLoc("block/deco/slate_tiles")));
        this.blockAndItem(HexBlocks.SLATE_BRICKS, (BlockModelBuilder)this.models().cubeAll("block/deco/slate_bricks", this.modLoc("block/deco/slate_bricks")));
        this.blockAndItem(HexBlocks.SLATE_BRICKS_SMALL, (BlockModelBuilder)this.models().cubeAll("block/deco/slate_bricks_small", this.modLoc("block/deco/slate_bricks_small")));
        this.axisBlock(HexBlocks.SLATE_PILLAR, this.modLoc("block/deco/slate_pillar"));
        this.blockAndItem((Block)HexBlocks.AMETHYST_DUST_BLOCK, (BlockModelBuilder)this.models().singleTexture("amethyst_dust_block", this.modLoc("block/cube_half_mirrored"), "all", this.modLoc("block/amethyst_dust_block")));
        this.blockAndItem((Block)HexBlocks.AMETHYST_TILES, (BlockModelBuilder)this.models().cubeAll("block/deco/amethyst_tiles", this.modLoc("block/deco/amethyst_tiles")));
        this.blockAndItem((Block)HexBlocks.AMETHYST_BRICKS, (BlockModelBuilder)this.models().cubeAll("block/deco/amethyst_bricks", this.modLoc("block/deco/amethyst_bricks")));
        this.blockAndItem((Block)HexBlocks.AMETHYST_BRICKS_SMALL, (BlockModelBuilder)this.models().cubeAll("block/deco/amethyst_bricks_small", this.modLoc("block/deco/amethyst_bricks_small")));
        this.directionalBlock((Block)HexBlocks.AMETHYST_PILLAR, (ModelFile)this.models().cubeBottomTop("block/deco/amethyst_pillar", this.modLoc("block/deco/amethyst_pillar_side"), this.modLoc("block/deco/amethyst_pillar_bottom"), this.modLoc("block/deco/amethyst_pillar_top")));
        this.blockAndItem(HexBlocks.SLATE_AMETHYST_TILES, (BlockModelBuilder)this.models().cubeAll("block/deco/slate_amethyst_tiles", this.modLoc("block/deco/slate_amethyst_tiles")));
        this.simpleBlock(HexBlocks.SLATE_AMETHYST_BRICKS, new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_0", this.modLoc("block/deco/slate_amethyst_bricks_0"))), new ConfiguredModel((ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_1", this.modLoc("block/deco/slate_amethyst_bricks_1"))), new ConfiguredModel((ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_2", this.modLoc("block/deco/slate_amethyst_bricks_2")))});
        this.simpleBlockItem(HexBlocks.SLATE_AMETHYST_BRICKS, (ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_0", this.modLoc("block/deco/slate_amethyst_bricks_0")));
        this.simpleBlock(HexBlocks.SLATE_AMETHYST_BRICKS_SMALL, new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_small_0", this.modLoc("block/deco/slate_amethyst_bricks_small_0"))), new ConfiguredModel((ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_small_1", this.modLoc("block/deco/slate_amethyst_bricks_small_1"))), new ConfiguredModel((ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_small_2", this.modLoc("block/deco/slate_amethyst_bricks_small_2")))});
        this.simpleBlockItem(HexBlocks.SLATE_AMETHYST_BRICKS_SMALL, (ModelFile)this.models().cubeAll("block/deco/slate_amethyst_bricks_small_0", this.modLoc("block/deco/slate_amethyst_bricks_small_0")));
        this.axisBlock(HexBlocks.SLATE_AMETHYST_PILLAR, this.modLoc("block/deco/slate_amethyst_pillar"));
        this.cubeBlockAndItem(HexBlocks.SCROLL_PAPER, "scroll_paper");
        this.cubeBlockAndItem(HexBlocks.ANCIENT_SCROLL_PAPER, "ancient_scroll_paper");
        this.blockAndItem(HexBlocks.SCROLL_PAPER_LANTERN, (BlockModelBuilder)this.models().cubeBottomTop("scroll_paper_lantern", this.modLoc("block/scroll_paper_lantern_side"), this.modLoc("block/scroll_paper_lantern_bottom"), this.modLoc("block/scroll_paper_lantern_top")));
        this.blockAndItem(HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, (BlockModelBuilder)this.models().cubeBottomTop("ancient_scroll_paper_lantern", this.modLoc("block/ancient_scroll_paper_lantern_side"), this.modLoc("block/ancient_scroll_paper_lantern_bottom"), this.modLoc("block/ancient_scroll_paper_lantern_top")));
        this.axisBlock(HexBlocks.EDIFIED_LOG, this.modLoc("block/edified_log"), this.modLoc("block/edified_log_top"));
        this.axisBlock(HexBlocks.EDIFIED_LOG_AMETHYST, this.modLoc("block/deco/edified_log_amethyst"), this.modLoc("block/edified_log_top"));
        this.axisBlock(HexBlocks.EDIFIED_LOG_AVENTURINE, this.modLoc("block/deco/edified_log_aventurine"), this.modLoc("block/edified_log_top"));
        this.axisBlock(HexBlocks.EDIFIED_LOG_CITRINE, this.modLoc("block/deco/edified_log_citrine"), this.modLoc("block/edified_log_top"));
        this.axisBlock(HexBlocks.EDIFIED_LOG_PURPLE, this.modLoc("block/deco/edified_log_purple"), this.modLoc("block/edified_log_top"));
        this.axisBlock(HexBlocks.STRIPPED_EDIFIED_LOG, this.modLoc("block/stripped_edified_log"), this.modLoc("block/stripped_edified_log_top"));
        this.axisBlock(HexBlocks.EDIFIED_WOOD, this.modLoc("block/edified_log"), this.modLoc("block/edified_log"));
        this.axisBlock(HexBlocks.STRIPPED_EDIFIED_WOOD, this.modLoc("block/stripped_edified_log"), this.modLoc("block/stripped_edified_log"));
        this.blockAndItem(HexBlocks.EDIFIED_PANEL, (BlockModelBuilder)this.models().cubeAll("edified_panel", this.modLoc("block/edified_panel")));
        this.blockAndItem(HexBlocks.EDIFIED_TILE, (BlockModelBuilder)this.models().cubeAll("edified_tile", this.modLoc("block/edified_tile")));
        ResourceLocation leavesParent = new ResourceLocation("block/leaves");
        this.blockAndItem((Block)HexBlocks.AMETHYST_EDIFIED_LEAVES, (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("amethyst_edified_leaves", leavesParent)).texture("all", this.modLoc("block/amethyst_edified_leaves"))).renderType("cutout_mipped"));
        this.blockAndItem((Block)HexBlocks.AVENTURINE_EDIFIED_LEAVES, (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("aventurine_edified_leaves", leavesParent)).texture("all", this.modLoc("block/aventurine_edified_leaves"))).renderType("cutout_mipped"));
        this.blockAndItem((Block)HexBlocks.CITRINE_EDIFIED_LEAVES, (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("citrine_edified_leaves", leavesParent)).texture("all", this.modLoc("block/citrine_edified_leaves"))).renderType("cutout_mipped"));
        this.doorBlockWithRenderType(HexBlocks.EDIFIED_DOOR, this.modLoc("block/edified_door_lower"), this.modLoc("block/edified_door_upper"), "cutout");
        this.trapdoorBlockWithRenderType(HexBlocks.EDIFIED_TRAPDOOR, this.modLoc("block/edified_trapdoor"), true, "cutout");
        ResourceLocation planks1 = this.modLoc("block/edified_planks");
        BlockModelBuilder planksModel = (BlockModelBuilder)this.models().cubeAll("edified_planks", planks1);
        this.simpleBlock(HexBlocks.EDIFIED_PLANKS, ConfiguredModel.builder().modelFile((ModelFile)planksModel).weight(3).nextModel().modelFile((ModelFile)this.models().cubeAll("edified_planks_2", this.modLoc("block/edified_planks_2"))).weight(3).nextModel().modelFile((ModelFile)this.models().cubeAll("edified_planks_3", this.modLoc("block/edified_planks_3"))).build());
        this.simpleBlockItem(HexBlocks.EDIFIED_PLANKS, (ModelFile)planksModel);
        this.stairsBlock(HexBlocks.EDIFIED_STAIRS, planks1);
        this.fenceBlock(HexBlocks.EDIFIED_FENCE, planks1);
        this.fenceGateBlock(HexBlocks.EDIFIED_FENCE_GATE, planks1);
        this.slabBlock(HexBlocks.EDIFIED_SLAB, planks1, planks1);
        this.buttonBlock(HexBlocks.EDIFIED_BUTTON, planks1);
        this.pressurePlateBlock(HexBlocks.EDIFIED_PRESSURE_PLATE, planks1);
        ModelFile.ExistingModelFile sconceModel = this.models().getExistingFile(this.modLoc("amethyst_sconce"));
        this.directionalBlock((Block)HexBlocks.SCONCE, (ModelFile)sconceModel);
        this.simpleBlockItem((Block)HexBlocks.SCONCE, (ModelFile)sconceModel);
        BlockModelBuilder conjuredModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("conjured")).texture("particle", this.mcLoc("block/amethyst_block"))).renderType("cutout");
        this.simpleBlock(HexBlocks.CONJURED_BLOCK, (ModelFile)conjuredModel);
        this.simpleBlock(HexBlocks.CONJURED_LIGHT, (ModelFile)conjuredModel);
        this.simpleBlock(HexBlocks.QUENCHED_ALLAY, (ModelFile)this.models().cubeAll("quenched_allay", this.modLoc("block/quenched_allay_0")));
        this.simpleBlock(HexBlocks.QUENCHED_ALLAY_TILES, (ModelFile)this.models().cubeAll("quenched_allay_tiles", this.modLoc("block/deco/quenched_allay_tiles_0")));
        this.simpleBlock(HexBlocks.QUENCHED_ALLAY_BRICKS, (ModelFile)this.models().cubeAll("quenched_allay_bricks", this.modLoc("block/deco/quenched_allay_bricks_0")));
        this.simpleBlock(HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL, (ModelFile)this.models().cubeAll("quenched_allay_bricks_small", this.modLoc("block/deco/quenched_allay_bricks_small_0")));
    }

    private void arrowCircleBlock(Block block, String name, ResourceLocation particle, String frontStub, String topStob, String leftStub, String rightStub, String backStub, boolean itemModelIsLit) {
        this.getVariantBuilder(block).forAllStates(bs -> {
            boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit ? "lit" : "dim";
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            String front = "block/circle/" + frontStub + "_" + litness;
            String top = "block/circle/" + topStob + "_" + litness;
            String left = "block/circle/" + leftStub + "_" + litness;
            String right = "block/circle/" + rightStub + "_" + litness;
            String back = "block/circle/" + backStub + "_" + litness;
            String bottom = "block/circle/bottom";
            String modelName = "block/circle/" + name + "/" + litness + "_" + dir.m_122433_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, this.modLoc(bottom), this.modLoc(top), this.modLoc(front), this.modLoc(back), this.modLoc(left), this.modLoc(right))).texture("particle", particle);
            if (isLit == itemModelIsLit && dir == Direction.EAST) {
                ((ItemModelBuilder)this.itemModels().getBuilder("item/" + name)).parent((ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationX(dir.m_122434_() == Direction.Axis.Y ? dir.m_122421_().m_122540_() * -90 : 0).rotationY(dir.m_122434_() != Direction.Axis.Y ? (dir.m_122416_() + 2) % 4 * 90 : 0).build();
        });
    }

    private void impetus(Block block, String name, String stub, boolean itemModelIsLit) {
        this.arrowCircleBlock(block, name, this.modLoc("block/slate"), "impetus/" + stub + "/front", "impetus/" + stub + "/top", "impetus/" + stub + "/left", "impetus/" + stub + "/right", "impetus/back", itemModelIsLit);
    }

    private void doAllTheDirectrices() {
        this.arrowCircleBlock(HexBlocks.EMPTY_DIRECTRIX, "directrix/empty", this.modLoc("block/slate"), "directrix/empty/front", "directrix/empty/top", "directrix/empty/left", "directrix/empty/right", "directrix/empty/back", false);
        this.getVariantBuilder(HexBlocks.DIRECTRIX_REDSTONE).forAllStates(bs -> {
            Object backEnding;
            Object frontEnding;
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            Boolean isPowered = (Boolean)bs.m_61143_((Property)BlockRedstoneDirectrix.REDSTONE_POWERED);
            String poweredness = isPowered != false ? "powered" : "unpowered";
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            String top = "block/circle/directrix/redstone/top_" + poweredness;
            String left = "block/circle/directrix/redstone/left_" + poweredness;
            String right = "block/circle/directrix/redstone/right_" + poweredness;
            if (isLit.booleanValue()) {
                if (isPowered.booleanValue()) {
                    frontEnding = "lit_powered";
                    backEnding = "dim_powered";
                } else {
                    frontEnding = "dim_unpowered";
                    backEnding = "lit_unpowered";
                }
            } else {
                frontEnding = "dim_" + poweredness;
                backEnding = "dim_" + poweredness;
            }
            String front = "block/circle/directrix/redstone/front_" + (String)frontEnding;
            String back = "block/circle/directrix/redstone/back_" + (String)backEnding;
            String bottom = "block/circle/bottom";
            String modelName = "block/circle/directrix/redstone/" + litness + "_" + poweredness + "_" + dir.m_122433_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, this.modLoc(bottom), this.modLoc(top), this.modLoc(front), this.modLoc(back), this.modLoc(left), this.modLoc(right))).texture("particle", this.modLoc("block/slate"));
            if (isLit.booleanValue() && !isPowered.booleanValue() && dir == Direction.EAST) {
                ((ItemModelBuilder)this.itemModels().getBuilder("item/directrix/redstone")).parent((ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationX(dir.m_122434_() == Direction.Axis.Y ? dir.m_122421_().m_122540_() * -90 : 0).rotationY(dir.m_122434_() != Direction.Axis.Y ? (dir.m_122416_() + 2) % 4 * 90 : 0).build();
        });
        this.getVariantBuilder(HexBlocks.DIRECTRIX_BOOLEAN).forAllStates(bs -> {
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            BlockBooleanDirectrix.State boolState = (BlockBooleanDirectrix.State)((Object)((Object)bs.m_61143_(BlockBooleanDirectrix.STATE)));
            String boolStateString = boolState.toString().toLowerCase();
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            String top = "block/circle/directrix/boolean/top_" + boolStateString;
            String left = "block/circle/directrix/boolean/left_" + boolStateString;
            String right = "block/circle/directrix/boolean/right_" + boolStateString;
            Object frontEnding = null;
            Object backEnding = null;
            switch (boolState) {
                case NEITHER: {
                    frontEnding = "not_false";
                    backEnding = "not_true";
                    break;
                }
                case TRUE: {
                    frontEnding = "not_false";
                    backEnding = litness + "_true";
                    break;
                }
                case FALSE: {
                    frontEnding = litness + "_false";
                    backEnding = "not_true";
                }
            }
            String front = "block/circle/directrix/boolean/front_" + (String)frontEnding;
            String back = "block/circle/directrix/boolean/back_" + (String)backEnding;
            String bottom = "block/circle/bottom";
            String modelName = "block/circle/directrix/boolean/" + litness + "_" + boolStateString + "_" + dir.m_122433_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, this.modLoc(bottom), this.modLoc(top), this.modLoc(front), this.modLoc(back), this.modLoc(left), this.modLoc(right))).texture("particle", this.modLoc("block/slate"));
            if (isLit.booleanValue() && boolState == BlockBooleanDirectrix.State.FALSE && dir == Direction.EAST) {
                ((ItemModelBuilder)this.itemModels().getBuilder("item/directrix/boolean")).parent((ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationX(dir.m_122434_() == Direction.Axis.Y ? dir.m_122421_().m_122540_() * -90 : 0).rotationY(dir.m_122434_() != Direction.Axis.Y ? (dir.m_122416_() + 2) % 4 * 90 : 0).build();
        });
    }
}

