/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import com.google.common.base.Preconditions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;

public record StackWithChance(Lazy<ItemStack> stack, float chance) {
    public StackWithChance {
        Preconditions.checkNotNull(stack);
    }

    public StackWithChance(ItemStack stack, float chance) {
        this((Lazy<ItemStack>)Lazy.of(() -> stack), chance);
    }

    public CompoundTag writeToNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128365_("stack", (Tag)((ItemStack)this.stack.get()).m_41739_(new CompoundTag()));
        compoundNBT.m_128350_("chance", this.chance);
        return compoundNBT;
    }

    public static StackWithChance readFromNBT(CompoundTag compoundNBT) {
        Preconditions.checkNotNull((Object)compoundNBT);
        Preconditions.checkArgument((boolean)compoundNBT.m_128441_("chance"));
        Preconditions.checkArgument((boolean)compoundNBT.m_128441_("stack"));
        ItemStack stack = ItemStack.m_41712_((CompoundTag)compoundNBT.m_128469_("stack"));
        float chance = compoundNBT.m_128457_("chance");
        return new StackWithChance(stack, chance);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130055_((ItemStack)this.stack.get());
        buffer.writeFloat(this.chance);
    }

    public static StackWithChance read(FriendlyByteBuf buffer) {
        return new StackWithChance(buffer.m_130267_(), buffer.readFloat());
    }

    public StackWithChance recalculate(float totalChance) {
        return new StackWithChance(this.stack, this.chance / totalChance);
    }
}

