/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.fluid;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class FluidUtils {
    public static boolean enableFractionDisplay = true;
    private static final Map<Fraction, String> FRACTION_STRINGS = new HashMap<Fraction, String>();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount) {
        return FluidUtils.copyFluidStackWithAmount(stack, amount, false);
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        if (stack == null) {
            return null;
        }
        FluidStack fs = new FluidStack(stack, amount);
        if (stripPressure && fs.hasTag() && fs.getOrCreateTag().m_128441_("pressurized")) {
            CompoundTag tag = fs.getOrCreateTag();
            tag.m_128473_("pressurized");
            if (tag.m_128456_()) {
                fs.setTag(null);
            }
        }
        return fs;
    }

    public static Optional<FluidStack> getFluidContained(@Nonnull ItemStack container) {
        if (!container.m_41619_()) {
            return FluidUtil.getFluidHandler((ItemStack)container).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        }
        return Optional.empty();
    }

    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, IFluidHandler.FluidAction doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return containerCopy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            FluidStack simulatedMoved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)handler, (int)maxAmount, (boolean)false);
            if (simulatedMoved.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            handler.drain(simulatedMoved, IFluidHandler.FluidAction.EXECUTE);
            fluidDestination.fill(simulatedMoved, doDrain);
            return new FluidActionResult(handler.getContainer());
        }).orElse(FluidActionResult.FAILURE);
    }

    public static boolean multiblockFluidOutput(CapabilityReference<IFluidHandler> outputCap, FluidTank tank, int slotIn, int slotOut, @Nullable IItemHandlerModifiable inv) {
        boolean updateTile = false;
        if (tank.getFluidAmount() > 0) {
            int accepted;
            if (slotIn >= 0 && slotOut >= 0 && inv != null) {
                updateTile = FluidUtils.fillFluidContainer((IFluidHandler)tank, slotIn, slotOut, inv);
            }
            FluidStack out = FluidUtils.copyFluidStackWithAmount(tank.getFluid(), Math.min(tank.getFluidAmount(), 1000), false);
            IFluidHandler output = outputCap.getNullable();
            if (output != null && (accepted = output.fill(out, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                tank.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return updateTile;
    }

    public static boolean fillFluidContainer(IFluidHandler handler, int slotIn, int slotOut, IItemHandlerModifiable inv) {
        ItemStack filledContainer = FluidUtils.fillFluidContainer(handler, inv.getStackInSlot(slotIn), inv.getStackInSlot(slotOut), null);
        if (!filledContainer.m_41619_()) {
            if (inv.getStackInSlot(slotIn).m_41613_() == 1 && !FluidUtils.isFluidContainerFull(filledContainer)) {
                inv.setStackInSlot(slotIn, filledContainer.m_41777_());
            } else {
                if (!inv.getStackInSlot(slotOut).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)filledContainer, (ItemStack)inv.getStackInSlot(slotOut))) {
                    inv.getStackInSlot(slotOut).m_41769_(filledContainer.m_41613_());
                } else {
                    inv.setStackInSlot(slotOut, filledContainer);
                }
                inv.getStackInSlot(slotIn).m_41774_(1);
                if (inv.getStackInSlot(slotIn).m_41613_() <= 0) {
                    inv.setStackInSlot(slotIn, ItemStack.f_41583_);
                }
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean fillFluidContainer(IFluidHandler handler, int slotIn, int slotOut, IntFunction<ItemStack> invGet, BiConsumer<Integer, ItemStack> invSet) {
        ItemStack filledContainer = FluidUtils.fillFluidContainer(handler, invGet.apply(slotIn), invGet.apply(slotOut), null);
        if (!filledContainer.m_41619_()) {
            if (invGet.apply(slotIn).m_41613_() == 1 && !FluidUtils.isFluidContainerFull(filledContainer)) {
                invSet.accept(slotIn, filledContainer.m_41777_());
            } else {
                if (!invGet.apply(slotOut).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)filledContainer, (ItemStack)invGet.apply(slotOut))) {
                    invGet.apply(slotOut).m_41769_(filledContainer.m_41613_());
                } else {
                    invSet.accept(slotOut, filledContainer);
                }
                invGet.apply(slotIn).m_41774_(1);
                if (invGet.apply(slotIn).m_41613_() <= 0) {
                    invSet.accept(slotIn, ItemStack.f_41583_);
                }
            }
            return true;
        }
        return false;
    }

    public static ItemStack fillFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable Player player) {
        if (containerIn == null || containerIn.m_41619_()) {
            return ItemStack.f_41583_;
        }
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)containerOut, (ItemStack)full)) {
                if (!containerOut.m_41619_() && containerOut.m_41613_() + full.m_41613_() > containerOut.m_41741_()) {
                    return ItemStack.f_41583_;
                }
                result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean isFluidContainerFull(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            for (int t = 0; t < handler.getTanks(); ++t) {
                if (handler.getFluidInTank(t).getAmount() >= handler.getTankCapacity(t)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, final IFluidHandler handler) {
        MutableObject lastNonSimulated = new MutableObject();
        MutableBoolean isInsert = new MutableBoolean();
        WrapperFluidHandler simulationWrapper = new WrapperFluidHandler(handler, (Mutable)lastNonSimulated, isInsert){
            final /* synthetic */ Mutable val$lastNonSimulated;
            final /* synthetic */ MutableBoolean val$isInsert;
            {
                this.val$lastNonSimulated = mutable;
                this.val$isInsert = mutableBoolean;
                super(handler2);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                int result = handler.fill(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$lastNonSimulated.setValue((Object)new FluidStack(resource, result));
                    this.val$isInsert.setTrue();
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }
        };
        boolean success = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)simulationWrapper);
        if (success) {
            if (isInsert.booleanValue()) {
                handler.fill((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            } else {
                handler.drain((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return success;
    }

    public static String getBucketFraction(int amount) {
        Object ret = "";
        if (amount > 1000) {
            ret = (String)ret + amount / 1000;
            amount %= 1000;
        }
        if (amount > 0) {
            Fraction key = Fraction.getReducedFraction((int)amount, (int)1000);
            if (enableFractionDisplay && FRACTION_STRINGS.containsKey(key)) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : " ") + FRACTION_STRINGS.get(key);
            } else {
                double decimal = (double)amount / 1000.0;
                String decimalString = DECIMAL_FORMAT.format(decimal);
                ret = !((String)ret).isEmpty() ? (String)ret + decimalString.substring(1) : decimalString;
            }
        }
        return ret;
    }

    static {
        FRACTION_STRINGS.put(Fraction.ONE_HALF, "\u00bd");
        FRACTION_STRINGS.put(Fraction.ONE_QUARTER, "\u00bc");
        FRACTION_STRINGS.put(Fraction.THREE_QUARTERS, "\u00be");
        FRACTION_STRINGS.put(Fraction.ONE_THIRD, "\u2153");
        FRACTION_STRINGS.put(Fraction.TWO_THIRDS, "\u2154");
        FRACTION_STRINGS.put(Fraction.ONE_FIFTH, "\u2155");
        FRACTION_STRINGS.put(Fraction.TWO_FIFTHS, "\u2156");
        FRACTION_STRINGS.put(Fraction.THREE_FIFTHS, "\u2157");
        FRACTION_STRINGS.put(Fraction.FOUR_FIFTHS, "\u2158");
        FRACTION_STRINGS.put(Fraction.getFraction((int)1, (int)8), "\u215b");
        FRACTION_STRINGS.put(Fraction.getFraction((int)3, (int)8), "\u215c");
        FRACTION_STRINGS.put(Fraction.getFraction((int)1, (int)9), "\u2151");
        FRACTION_STRINGS.put(Fraction.getFraction((int)1, (int)10), "\u2152");
    }

    public static abstract class WrapperFluidHandler
    implements IFluidHandler {
        private final IFluidHandler handler;

        protected WrapperFluidHandler(IFluidHandler handler) {
            this.handler = handler;
        }

        public int getTanks() {
            return this.handler.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.handler.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.handler.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.handler.isFluidValid(tank, stack);
        }
    }
}

