/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallbacks;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.models.obj.GlobalTempData;
import blusunrize.immersiveengineering.client.models.obj.SpecificIEOBJModel;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.modelsplitter.model.Group;
import malte0811.modelsplitter.model.MaterialLibrary;
import malte0811.modelsplitter.model.OBJModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class GeneralIEOBJModel<T>
implements ICacheKeyProvider<ModelKey<T>> {
    private final Cache<GroupKey<T>, List<SpecificIEOBJModel.ShadedQuads>> groupCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final LoadingCache<ModelKey<T>, SpecificIEOBJModel<T>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(p -> new SpecificIEOBJModel(this, p.callbackKey(), p.shader(), p.renderTypeIfRelevant())));
    private final IEOBJCallback<T> callback;
    private final OBJModel<MaterialLibrary.OBJMaterial> baseModel;
    private final ChunkRenderTypeSet blockLayers;
    private final List<RenderType> itemTypes;
    private final List<RenderType> fabulousItemTypes;
    private final TextureAtlasSprite particles;
    private final IGeometryBakingContext owner;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState sprite;
    private final boolean isDynamic;
    private final ItemOverrides overrides;
    private final ModelProperty<T> keyProperty;

    public GeneralIEOBJModel(IEOBJCallback<T> callback, OBJModel<MaterialLibrary.OBJMaterial> baseModel, IGeometryBakingContext owner, Function<Material, TextureAtlasSprite> spriteGetter, ModelState sprite, boolean isDynamic, ChunkRenderTypeSet blockLayers, List<RenderType> itemTypes, List<RenderType> fabulousItemTypes) {
        this.callback = callback;
        this.baseModel = baseModel;
        this.blockLayers = blockLayers;
        this.itemTypes = itemTypes;
        this.fabulousItemTypes = fabulousItemTypes;
        this.particles = spriteGetter.apply(owner.getMaterial("particle"));
        this.owner = owner;
        this.spriteGetter = spriteGetter;
        this.sprite = sprite;
        this.isDynamic = isDynamic;
        if (callback instanceof ItemCallback) {
            ItemCallback itemCB = (ItemCallback)callback;
            this.overrides = new Overrides(itemCB);
        } else {
            this.overrides = new ItemOverrides(){

                public BakedModel m_173464_(@Nonnull BakedModel p_173465_, @Nonnull ItemStack p_173466_, @Nullable ClientLevel p_173467_, @Nullable LivingEntity p_173468_, int p_173469_) {
                    return Minecraft.m_91087_().m_91304_().m_119409_();
                }
            };
        }
        this.keyProperty = IEOBJCallbacks.getModelProperty(callback);
    }

    @Override
    public List<BakedQuad> getQuads(ModelKey<T> key) {
        if (key == null) {
            return ImmutableList.of();
        }
        return ((SpecificIEOBJModel)this.modelCache.getUnchecked(key)).getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
    }

    @Override
    @Nullable
    public ModelKey<T> getKey(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        if (side != null) {
            return null;
        }
        Object key = extraData.has(this.keyProperty) ? extraData.get(this.keyProperty) : this.callback.getDefaultKey();
        boolean includeLayer = BlockCallback.castOrDefault(this.callback).dependsOnLayer();
        ShaderCase shader = (ShaderCase)extraData.get(CapabilityShader.MODEL_PROPERTY);
        return new ModelKey<T>(key, shader, (RenderType)(includeLayer ? layer : null));
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        CapabilityShader.ShaderWrapper shaderCap;
        BlockCallback<T> blockCB = BlockCallback.castOrDefault(this.callback);
        BlockEntity blockEntity = level.m_7702_(pos);
        T key = blockCB.extractKey(level, pos, state, blockEntity);
        ModelData.Builder modelData = tileData.derive();
        modelData.with(this.keyProperty, key);
        if (blockEntity != null && (shaderCap = CapabilityUtils.getCapability((ICapabilityProvider)blockEntity, CapabilityShader.SHADER_CAPABILITY)) != null) {
            modelData.with(CapabilityShader.MODEL_PROPERTY, (Object)shaderCap.getCase());
        }
        return modelData.build();
    }

    @Nonnull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.blockLayers;
    }

    @Nonnull
    public List<RenderType> getRenderTypes(@Nonnull ItemStack itemStack, boolean fabulous) {
        return fabulous ? this.fabulousItemTypes : this.itemTypes;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return this.isDynamic;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        return this.particles;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public Cache<GroupKey<T>, List<SpecificIEOBJModel.ShadedQuads>> getGroupCache() {
        return this.groupCache;
    }

    public Map<String, Group<MaterialLibrary.OBJMaterial>> getGroups() {
        return this.baseModel.getFacesByGroup();
    }

    public OBJModel<MaterialLibrary.OBJMaterial> getBaseModel() {
        return this.baseModel;
    }

    public ModelState getSprite() {
        return this.sprite;
    }

    public Function<Material, TextureAtlasSprite> getSpriteGetter() {
        return this.spriteGetter;
    }

    public IGeometryBakingContext getOwner() {
        return this.owner;
    }

    public IEOBJCallback<T> getCallback() {
        return this.callback;
    }

    private class Overrides
    extends ItemOverrides {
        private final ItemCallback<T> callback;

        private Overrides(IEOBJCallback<T> callback) {
            this.callback = ItemCallback.castOrDefault(callback);
        }

        @Nullable
        public BakedModel m_173464_(@Nonnull BakedModel baseModel, @Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity holder, int p_173469_) {
            GlobalTempData.setActiveHolder(holder);
            Object key = this.callback.extractKey(stack, holder);
            ShaderCase shader = stack.getCapability(CapabilityShader.SHADER_CAPABILITY).resolve().map(CapabilityShader.ShaderWrapper::getCase).orElse(null);
            return (BakedModel)GeneralIEOBJModel.this.modelCache.getUnchecked(new ModelKey(key, shader, null));
        }
    }

    public record ModelKey<T>(T callbackKey, ShaderCase shader, @Nullable RenderType renderTypeIfRelevant) {
    }

    public record GroupKey<T>(T callbackKey, ShaderCase shader, @Nullable RenderType renderTypeIfRelevant, String group) {
    }
}

