/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class ShieldCallbacks
implements ItemCallback<Key> {
    public static final ShieldCallbacks INSTANCE = new ShieldCallbacks();

    @Override
    public Key extractKey(ItemStack stack, LivingEntity owner) {
        CompoundTag upgrades = IEShieldItem.getUpgradesStatic(stack);
        return new Key(upgrades.m_128471_("flash"), upgrades.m_128471_("shock"));
    }

    @Override
    public boolean shouldRenderGroup(Key object, String group, RenderType layer) {
        if ("flash".equals(group)) {
            return object.flash();
        }
        if ("shock".equals(group)) {
            return object.shock();
        }
        return true;
    }

    @Override
    public void handlePerspective(Key key, LivingEntity holder, ItemDisplayContext cameraItemDisplayContext, PoseStack mat) {
        InteractionHand inHand;
        boolean rightHand;
        if (holder == null || !holder.m_6117_()) {
            return;
        }
        boolean leftHand = cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        boolean bl = rightHand = cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        if (!leftHand && !rightHand) {
            return;
        }
        boolean leftIsMain = holder.m_5737_() == HumanoidArm.LEFT;
        InteractionHand interactionHand = inHand = leftIsMain == leftHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (holder.m_7655_() != inHand) {
            return;
        }
        if (cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            mat.m_252781_(new Quaternionf().rotateXYZ(-0.15f, 0.0f, 0.0f));
            mat.m_85837_(-0.25, 0.5, -0.4375);
        } else if (cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            mat.m_252781_(new Quaternionf().rotateXYZ(0.52359f, 0.0f, 0.0f));
            mat.m_252781_(new Quaternionf().rotateXYZ(0.0f, 0.78539f, 0.0f));
            mat.m_85837_(0.40625, -0.125, -0.125);
        }
        if (cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            mat.m_252781_(new Quaternionf().rotateXYZ(0.15f, 0.0f, 0.0f));
            mat.m_85837_(-0.25, 0.375, 0.4375);
        } else if (cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            mat.m_252781_(new Quaternionf().rotateX(-0.52359f).rotateY(-0.78539f));
            mat.m_85837_(-0.1875, 0.3125, 0.4375);
        }
    }

    @Override
    public Key getDefaultKey() {
        return new Key(false, false);
    }

    public record Key(boolean flash, boolean shock) {
    }
}

