/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.conveyor;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class BasicConveyorRender<T extends ConveyorBase>
implements IConveyorModelRender<T> {
    private final ResourceLocation active;
    private final ResourceLocation inactive;

    public BasicConveyorRender(ResourceLocation active, ResourceLocation inactive) {
        this.active = active;
        this.inactive = inactive;
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return this.active;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return this.inactive;
    }

    @Override
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<T> context, @Nullable RenderType renderType) {
        if (renderType == null || renderType == RenderType.m_110466_()) {
            this.addCoverToQuads(baseModel, context);
        }
        return baseModel;
    }

    protected void addCoverToQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<T> context) {
        Block b = context.getCover();
        if (b == Blocks.f_50016_) {
            return;
        }
        Function<Direction, TextureAtlasSprite> getSprite = BasicConveyorRender.makeTextureGetter(b);
        Direction facing = context.getFacing();
        ConveyorHandler.ConveyorDirection conDir = context.getConveyorDirection();
        Function<Direction, TextureAtlasSprite> getSpriteHorizontal = f -> f.m_122434_() == Direction.Axis.Y ? null : (TextureAtlasSprite)getSprite.apply((Direction)f);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Matrix4 matrix = new Matrix4(facing);
        Function<Vec3[], Vec3[]> vertexTransformer = conDir == ConveyorHandler.ConveyorDirection.HORIZONTAL ? vertices -> vertices : vertices -> {
            Vec3[] ret = new Vec3[((Vec3[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vec3(vertices[i].f_82479_, vertices[i].f_82480_ + (double)(vertices[i].f_82481_ == (double)(conDir != ConveyorHandler.ConveyorDirection.UP ? 1 : 0) ? 1 : 0), vertices[i].f_82481_);
            }
            return ret;
        };
        baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.75, 0.0), new Vec3(1.0, 1.0, 1.0), matrix, facing, vertexTransformer, getSprite, colour));
        if (this.shouldRenderWall(facing, ConveyorWall.LEFT, context)) {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.0), new Vec3(0.0625, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
        } else {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.0), new Vec3(0.0625, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0, 0.1875, 0.9375), new Vec3(0.0625, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
        }
        if (this.shouldRenderWall(facing, ConveyorWall.RIGHT, context)) {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.0), new Vec3(1.0, 0.75, 1.0), matrix, facing, vertexTransformer, getSpriteHorizontal, colour));
        } else {
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.0), new Vec3(1.0, 0.75, 0.0625), matrix, facing, getSpriteHorizontal, colour));
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.9375, 0.1875, 0.9375), new Vec3(1.0, 0.75, 1.0), matrix, facing, getSpriteHorizontal, colour));
        }
    }

    protected static Function<Direction, TextureAtlasSprite> makeTextureGetter(Block b) {
        BlockState state = b.m_49966_();
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
        TextureAtlasSprite sprite = model.getParticleIcon(ModelData.EMPTY);
        EnumMap<Direction, TextureAtlasSprite> sprites = new EnumMap<Direction, TextureAtlasSprite>(Direction.class);
        for (Direction f : DirectionUtils.VALUES) {
            for (BakedQuad q : model.getQuads(state, f, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null)) {
                if (q == null || q.m_173410_() == null) continue;
                sprites.put(f, q.m_173410_());
            }
        }
        for (BakedQuad q : model.getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null)) {
            if (q == null || q.m_173410_() == null || q.m_111306_() == null) continue;
            sprites.put(q.m_111306_(), q.m_173410_());
        }
        return d -> sprites.getOrDefault(d, sprite);
    }
}

