/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill;

import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.energy.IEnergyStorage;

public class SawmillProcess {
    private static final double STRIP_THRESHOLD = 0.3125;
    private static final double SAWING_THRESHOLD = 0.8625;
    private final ItemStack input;
    private RecipeDependentData recipeDependentData;
    private int processTick;
    private boolean stripped = false;
    private boolean sawed = false;
    private boolean processFinished = false;

    public SawmillProcess(ItemStack input) {
        this.input = input;
    }

    private RecipeDependentData getRecipeDependentData(Level level) {
        if (this.recipeDependentData == null) {
            SawmillRecipe recipe = SawmillRecipe.findRecipe(level, this.input);
            this.recipeDependentData = recipe != null ? new RecipeDependentData(recipe, recipe.getTotalProcessTime(), recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime()) : new RecipeDependentData(null, 80.0f, 40);
        }
        return this.recipeDependentData;
    }

    public boolean processStep(Level level, IEnergyStorage energy, ItemStack sawblade, Set<ItemStack> secondaries) {
        RecipeDependentData data = this.getRecipeDependentData(level);
        if (energy.extractEnergy(data.energyPerTick, true) < data.energyPerTick) {
            return false;
        }
        energy.extractEnergy(data.energyPerTick, false);
        ++this.processTick;
        float relative = this.getRelativeProcessStep(level);
        if (data.recipe != null) {
            if (!this.stripped && (double)relative >= 0.3125) {
                this.stripped = true;
                data.recipe.secondaryStripping.stream().map(Supplier::get).forEach(secondaries::add);
            }
            if (!this.sawed && (double)relative >= 0.8625) {
                this.sawed = true;
                if (!sawblade.m_41619_()) {
                    data.recipe.secondaryOutputs.stream().map(Supplier::get).forEach(secondaries::add);
                }
            }
        }
        if (relative >= 1.0f) {
            this.processFinished = true;
        }
        return true;
    }

    public void incrementProcessOnClient() {
        ++this.processTick;
    }

    public float getRelativeProcessStep(Level level) {
        return (float)this.processTick / this.getRecipeDependentData((Level)level).maxProcessTicks;
    }

    public ItemStack getCurrentStack(Level level, boolean sawblade) {
        RecipeDependentData data = this.getRecipeDependentData(level);
        if (data.recipe == null) {
            return this.input;
        }
        double relativeProgress = (double)this.processTick / (double)data.maxProcessTicks;
        if (relativeProgress > 0.8625 && sawblade) {
            return (ItemStack)data.recipe.output.get();
        }
        if (relativeProgress < 0.3125) {
            return this.input;
        }
        ItemStack stripped = (ItemStack)data.recipe.stripped.get();
        if (stripped.m_41619_()) {
            stripped = this.input;
        }
        return stripped;
    }

    public boolean isSawing(Level level) {
        return (double)this.getRelativeProcessStep(level) > 0.5375 && !this.sawed;
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("input", (Tag)this.input.m_41739_(new CompoundTag()));
        nbt.m_128405_("processTick", this.processTick);
        nbt.m_128379_("stripped", this.stripped);
        nbt.m_128379_("sawed", this.sawed);
        return nbt;
    }

    public boolean isProcessFinished() {
        return this.processFinished;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public static SawmillProcess readFromNBT(CompoundTag nbt) {
        ItemStack input = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("input"));
        SawmillProcess process = new SawmillProcess(input);
        process.processTick = nbt.m_128451_("processTick");
        process.stripped = nbt.m_128471_("stripped");
        process.sawed = nbt.m_128471_("sawed");
        return process;
    }

    private record RecipeDependentData(SawmillRecipe recipe, float maxProcessTicks, int energyPerTick) {
    }
}

