/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidSorterBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IInteractionObjectIE<FluidSorterBlockEntity>,
IFluidPipe,
IEBlockInterfaces.IBlockEntityDrop {
    public byte[] sortWithNBT = new byte[]{1, 1, 1, 1, 1, 1};
    public static final int FILTER_SLOTS_PER_SIDE = 8;
    public FluidStack[][] filters = FluidSorterBlockEntity.makeFilterArray();
    private static Set<BlockPos> usedRouters = null;
    private final Map<Direction, CapabilityReference<IFluidHandler>> neighborCaps = CapabilityReference.forAllNeighbors(this, ForgeCapabilities.FLUID_HANDLER);
    private final EnumMap<Direction, ResettableCapability<IFluidHandler>> insertionHandlers = new EnumMap(Direction.class);

    public FluidSorterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLUID_SORTER.get(), pos, state);
        for (Direction f : DirectionUtils.VALUES) {
            ResettableCapability<SorterFluidHandler> forSide = this.registerCapability(new SorterFluidHandler(this, f));
            this.insertionHandlers.put(f, forSide);
        }
    }

    public int routeFluid(Direction inputSide, FluidStack stack, IFluidHandler.FluidAction doFill) {
        int ret = 0;
        if (!this.f_58857_.f_46443_ && this.canRoute()) {
            boolean first = this.startRouting();
            Direction[][] validOutputs = this.getValidOutputs(inputSide, stack);
            ret += this.doInsert(stack, validOutputs[0], doFill);
            if (validOutputs[0].length == 0) {
                ret += this.doInsert(stack, validOutputs[1], doFill);
            }
            if (first) {
                usedRouters = null;
            }
        }
        return ret;
    }

    private boolean canRoute() {
        return usedRouters == null || !usedRouters.contains(this.f_58858_);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = usedRouters == null;
        if (first) {
            usedRouters = new HashSet<BlockPos>();
        }
        usedRouters.add(this.f_58858_);
        return first;
    }

    private int doInsert(FluidStack stack, Direction[] sides, IFluidHandler.FluidAction doFill) {
        int ret = 0;
        FluidStack available = stack.copy();
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && available.getAmount() > 0; --lengthFiltered) {
            int rand = ApiUtils.RANDOM.nextInt(lengthFiltered);
            Direction currentSide = sides[rand];
            CapabilityReference<IFluidHandler> capRef = this.neighborCaps.get(currentSide);
            IFluidHandler fluidOut = capRef.getNullable();
            if (fluidOut != null) {
                int filledHere = fluidOut.fill(available, doFill);
                available.shrink(filledHere);
                ret += filledHere;
            }
            sides[rand] = sides[lengthFiltered - 1];
        }
        return ret;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sortWithNBT.length) {
            return this.sortWithNBT[side] == 1;
        }
        return false;
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public FluidSorterBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<FluidSorterBlockEntity, ?> getContainerType() {
        return IEMenuTypes.FLUID_SORTER;
    }

    public Direction[][] getValidOutputs(Direction inputSide, @Nullable FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.isEmpty()) {
            return new Direction[2][0];
        }
        fluidStack = FluidUtils.copyFluidStackWithAmount(fluidStack, 1, true);
        ArrayList<Direction> validFilteredInvOuts = new ArrayList<Direction>(6);
        ArrayList<Direction> validUnfilteredInvOuts = new ArrayList<Direction>(6);
        for (Direction side : Direction.values()) {
            if (side == inputSide || !this.f_58857_.m_46805_(this.m_58899_().m_121945_(side))) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (FluidStack filterStack : this.filters[side.ordinal()]) {
                boolean b;
                if (filterStack == null || filterStack.isEmpty()) continue;
                unmapped = false;
                boolean bl = b = filterStack.getFluid() == fluidStack.getFluid();
                if (this.doNBT(side.ordinal())) {
                    b &= FluidStack.areFluidStackTagsEqual((FluidStack)filterStack, (FluidStack)fluidStack);
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                validFilteredInvOuts.add(side);
                continue;
            }
            if (!unmapped) continue;
            validUnfilteredInvOuts.add(side);
        }
        return new Direction[][]{validFilteredInvOuts.toArray(new Direction[0]), validUnfilteredInvOuts.toArray(new Direction[0])};
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.sortWithNBT = nbt.m_128463_("sortWithNBT");
        for (int side = 0; side < 6; ++side) {
            ListTag filterList = nbt.m_128437_("filter_" + side, 10);
            for (int i = 0; i < filterList.size(); ++i) {
                this.filters[side][i] = FluidStack.loadFluidStackFromNBT((CompoundTag)filterList.m_128728_(i));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128382_("sortWithNBT", this.sortWithNBT);
        for (int side = 0; side < 6; ++side) {
            ListTag filterList = new ListTag();
            for (int i = 0; i < this.filters[side].length; ++i) {
                CompoundTag tag = new CompoundTag();
                if (this.filters[side][i] != null) {
                    this.filters[side][i].writeToNBT(tag);
                }
                filterList.add((Object)tag);
            }
            nbt.m_128365_("filter_" + side, (Tag)filterList);
        }
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        this.writeCustomNBT(stack.m_41784_(), false);
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (stack.m_41782_()) {
            this.readCustomNBT(stack.m_41784_(), false);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER && facing != null) {
            return this.insertionHandlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    public static FluidStack[][] makeFilterArray() {
        FluidStack[][] filters;
        for (Object[] objectArray : filters = new FluidStack[DirectionUtils.VALUES.length][8]) {
            Arrays.fill(objectArray, FluidStack.EMPTY);
        }
        return filters;
    }

    static class SorterFluidHandler
    implements IFluidHandler {
        FluidSorterBlockEntity tile;
        Direction facing;

        SorterFluidHandler(FluidSorterBlockEntity tile, Direction facing) {
            this.tile = tile;
            this.facing = facing;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            return this.tile.routeFluid(this.facing, resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }
    }
}

