/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DrillItem
extends DieselToolItem {
    public DrillItem() {
        super(new Item.Properties().m_41487_(1), "DRILL");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    @Override
    public int getSlotCount() {
        return 5;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.WithPredicate(toolInventory, 0, 98, 22, itemStack -> itemStack.m_41720_() instanceof IDrillHead), new IESlot.Upgrades(container, toolInventory, 1, 78, 52, "DRILL", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 2, 98, 52, "DRILL", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 3, 118, 52, "DRILL", stack, true, level, getPlayer)};
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        invCap.ifPresent(inv -> {
            if (!(inv.getStackInSlot(0).m_41619_() || inv.getStackInSlot(1).m_41619_() || inv.getStackInSlot(2).m_41619_() || inv.getStackInSlot(3).m_41619_())) {
                Utils.unlockIEAdvancement(player, "tools/upgrade_drill");
            }
        });
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        super.finishUpgradeRecalculation(stack);
        Map enchants = DrillItem.getUpgradesStatic(stack).m_128471_("fortune") ? Collections.singletonMap(Enchantments.f_44987_, 3) : Collections.emptyMap();
        EnchantmentHelper.m_44865_(enchants, (ItemStack)stack);
    }

    @Override
    public final ItemStack getHead(ItemStack drill) {
        return DrillItem.getHeadStatic(drill);
    }

    public static ItemStack getHeadStatic(ItemStack drill) {
        if (ForgeCapabilities.ITEM_HANDLER == null) {
            return ItemStack.f_41583_;
        }
        LazyOptional cap = drill.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (cap.isPresent()) {
            ItemStack head = cap.map(handler -> handler.getStackInSlot(0)).orElse(ItemStack.f_41583_);
            return !head.m_41619_() && head.m_41720_() instanceof IDrillHead ? head : ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void setHead(ItemStack drill, ItemStack head) {
        IItemHandler inv = (IItemHandler)drill.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(RuntimeException::new);
        ((IItemHandlerModifiable)inv).setStackInSlot(0, head);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getHead(stack).m_41619_()) {
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.drill.noHead"), ChatFormatting.GRAY));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            ChatFormatting status = (double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.drill.headDamage"), ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"desc.immersiveengineering.info.percent", (Object[])new Object[]{(int)(quote * 100.0f)}), status)));
        }
    }

    @Override
    protected double getAttackDamage(ItemStack stack, ItemStack head) {
        return ((IDrillHead)head.m_41720_()).getAttackDamage(head) + (float)this.getUpgrades(stack).m_128451_("damage");
    }

    public static boolean isSingleBlockMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, "singleBlockMode");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            boolean mode = !DrillItem.isSingleBlockMode(stack);
            stack.m_41784_().m_128379_("singleBlockMode", mode);
            player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.drill_mode." + (mode ? "single" : "multi"))), true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public boolean canToolBeUsed(ItemStack drill) {
        return this.getHeadDamage(drill) < this.getMaxHeadDamage(drill) && !this.getFluid(drill).isEmpty();
    }

    @SubscribeEvent
    public static void handleUnderwaterDrill(PlayerEvent.HarvestCheck ev) {
        ItemStack drill = ev.getEntity().m_150109_().m_36056_();
        Item item = drill.m_41720_();
        if (!(item instanceof DrillItem)) {
            return;
        }
        DrillItem drillItem = (DrillItem)item;
        if (ev.getEntity().isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !drillItem.getUpgrades(drill).m_128471_("waterproof")) {
            ev.setCanHarvest(false);
        }
    }

    @Override
    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.m_41619_() ? ((IDrillHead)head.m_41720_()).getMaximumHeadDamage(head) : 0;
    }

    @Override
    public int getHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.m_41619_() ? ((IDrillHead)head.m_41720_()).getHeadDamage(head) : 0;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity living) {
        ItemStack head;
        if (state.m_60800_((BlockGetter)world, pos) != 0.0f && !(head = this.getHead(stack)).m_41619_()) {
            if (living instanceof Player) {
                if (((Player)living).m_150110_().f_35937_) {
                    return true;
                }
                ((IDrillHead)head.m_41720_()).afterBlockbreak(stack, head, (Player)living);
            }
            this.consumeDurability(stack, world, state, pos, living);
        }
        return true;
    }

    @Override
    protected void damageHead(ItemStack head, int amount, LivingEntity living) {
        ((IDrillHead)head.m_41720_()).damageHead(head, amount);
    }

    @Override
    public Tier getHarvestLevel(ItemStack stack, @Nullable Player player) {
        ItemStack head = this.getHead(stack);
        if (!head.m_41619_() && this.canToolBeUsed(stack)) {
            return ((IDrillHead)head.m_41720_()).getMiningLevel(head);
        }
        return null;
    }

    @Override
    public boolean isEffective(ItemStack stack, BlockState state) {
        return state.m_204336_(IETags.drillHarvestable);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        ItemStack head = this.getHead(stack);
        if (!head.m_41619_() && this.canToolBeUsed(stack)) {
            return ((IDrillHead)head.m_41720_()).getMiningSpeed(head) + this.getUpgrades(stack).m_128457_("speed");
        }
        return super.m_8102_(stack, state);
    }

    public boolean canBreakExtraBlock(Level world, BlockPos pos, BlockState state, Player player, ItemStack drill, ItemStack head) {
        if (!(state.canHarvestBlock((BlockGetter)world, pos, player) && this.isEffective(drill, state) && this.canToolBeUsed(drill))) {
            return false;
        }
        return !((IDrillHead)head.m_41720_()).beforeBlockbreak(drill, head, player);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos iPos, Player player) {
        Level world = player.m_9236_();
        if (world.f_46443_ || !(player instanceof ServerPlayer)) {
            return false;
        }
        if (player.m_6144_() || DrillItem.isSingleBlockMode(stack)) {
            return false;
        }
        BlockHitResult mop = DrillItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack head = this.getHead(stack);
        if (mop == null || head.m_41619_() || !this.canToolBeUsed(stack)) {
            return false;
        }
        ImmutableList<BlockPos> additional = ((IDrillHead)head.m_41720_()).getExtraBlocksDug(head, world, player, (HitResult)mop);
        for (BlockPos pos : additional) {
            int xpDropEvent;
            if (!world.m_46805_(pos)) continue;
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (state.m_60795_() || state.m_60625_(player, (BlockGetter)world, pos) == 0.0f || !this.canBreakExtraBlock(world, pos, state, player, stack, head) || (xpDropEvent = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos)) < 0) continue;
            if (player.m_150110_().f_35937_) {
                if (block.onDestroyedByPlayer(state, world, pos, player, false, state.m_60819_())) {
                    block.m_6786_((LevelAccessor)world, pos, state);
                }
            } else {
                BlockEntity te = world.m_7702_(pos);
                stack.m_41686_(world, state, pos, player);
                if (block.onDestroyedByPlayer(state, world, pos, player, true, state.m_60819_())) {
                    block.m_6786_((LevelAccessor)world, pos, state);
                    block.m_6240_(world, player, pos, state, te, stack);
                    if (world instanceof ServerLevel) {
                        block.m_49805_((ServerLevel)world, pos, xpDropEvent);
                    }
                }
            }
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
        }
        return false;
    }
}

