/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class JerrycanItem
extends IEBaseItem {
    private final int jerrycanMaxMB = 10000;

    public JerrycanItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (ForgeCapabilities.FLUID_HANDLER_ITEM != null) {
            Optional fsCap = FluidUtil.getFluidContained((ItemStack)stack);
            fsCap.ifPresent(fs -> list.add(IEItemFluidHandler.fluidItemInfoFlavor(fs, 10000)));
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Optional fs;
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        BlockEntity tileEntity = world.m_7702_(pos);
        if ((tileEntity == null || !tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) && (fs = FluidUtil.getFluidContained((ItemStack)stack)).isPresent() && Utils.placeFluidBlock(world, pos.m_121945_(ctx.m_43719_()), (FluidStack)fs.get())) {
            ItemNBTHelper.setFluidStack(stack, "Fluid", (FluidStack)fs.get());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, "jerrycanDrain") || FluidUtil.getFluidContained((ItemStack)stack).isPresent();
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "jerrycanDrain")) {
            ItemStack ret = stack.m_41777_();
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)ret).orElseThrow(RuntimeException::new);
            handler.drain(ItemNBTHelper.getInt(ret, "jerrycanDrain"), IFluidHandler.FluidAction.EXECUTE);
            ItemNBTHelper.remove(ret, "jerrycanDrain");
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack).isPresent()) {
            ItemStack ret = stack.m_41777_();
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)ret).orElseThrow(RuntimeException::new);
            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            return ret;
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new FluidHandlerItemStack(stack, 10000);
        }
        return null;
    }
}

