/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseItem;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShaderItem
extends IEBaseItem
implements IShaderItem,
IEItemInterfaces.IColouredItem {
    public static final String SHADER_NAME_KEY = "shader_name";

    public ShaderItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public ShaderCase getShaderCase(ItemStack shader, ResourceLocation shaderType) {
        return ShaderRegistry.getShader(this.getShaderName(shader), shaderType);
    }

    @Override
    public ResourceLocation getShaderName(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, SHADER_NAME_KEY)) {
            return new ResourceLocation(ItemNBTHelper.getString(stack, SHADER_NAME_KEY));
        }
        return null;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ResourceLocation name = this.getShaderName(ctx.m_43722_());
        if (ShaderRegistry.shaderRegistry.containsKey(name)) {
            BlockState blockState = world.m_8055_(pos);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BannerBlockEntity) {
                ShaderCase sCase = ShaderRegistry.shaderRegistry.get(name).getCase(new ResourceLocation("immersiveengineering", "banner"));
                if (sCase != null) {
                    boolean wall = blockState.m_60734_() instanceof WallBannerBlock;
                    if (wall) {
                        world.m_46597_(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER_WALL.defaultBlockState().m_61124_(ShaderBannerWallBlock.FACING, (Comparable)((Direction)blockState.m_61143_((Property)WallBannerBlock.f_57916_))));
                    } else {
                        world.m_46597_(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER.defaultBlockState().m_61124_((Property)ShaderBannerStandingBlock.ROTATION, (Comparable)((Integer)blockState.m_61143_((Property)BannerBlock.f_49007_))));
                    }
                    tile = world.m_7702_(pos);
                    if (tile instanceof ShaderBannerBlockEntity) {
                        ((ShaderBannerBlockEntity)tile).shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.m_43722_(), (int)1));
                        tile.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                }
            } else if (tile instanceof ShaderBannerBlockEntity) {
                ((ShaderBannerBlockEntity)tile).shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.m_43722_(), (int)1));
                tile.m_6596_();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237115_((String)"desc.immersiveengineering.info.shader.level").m_130946_(this.m_41460_((ItemStack)stack).f_43022_.toString()).m_7220_((Component)Component.m_237115_((String)("desc.immersiveengineering.info.shader.rarity." + this.m_41460_(stack).name().toLowerCase(Locale.US)))));
        if (!Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"desc.immersiveengineering.info.shader.applyTo").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"desc.immersiveengineering.info.holdShift")));
        } else {
            list.add((Component)Component.m_237115_((String)"desc.immersiveengineering.info.shader.applyTo"));
            ResourceLocation rl = this.getShaderName(stack);
            if (rl != null) {
                List<ShaderCase> array = ShaderRegistry.shaderRegistry.get(rl).getCases();
                for (ShaderCase sCase : array) {
                    if (sCase instanceof ShaderCaseItem) continue;
                    list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)("desc.immersiveengineering.info.shader." + sCase.getShaderType())), ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        MutableComponent itc = super.m_7626_(stack).m_6881_();
        ResourceLocation rl = this.getShaderName(stack);
        if (rl != null) {
            itc.m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("item." + rl.m_135827_() + ".shader.name." + rl.m_135815_())));
        }
        return itc;
    }

    @Nonnull
    public Rarity m_41460_(ItemStack stack) {
        ResourceLocation rl = this.getShaderName(stack);
        return ShaderRegistry.shaderRegistry.containsKey(rl) ? ShaderRegistry.shaderRegistry.get(rl).getRarity() : Rarity.COMMON;
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
        for (ResourceLocation key : ShaderRegistry.shaderRegistry.keySet()) {
            ItemStack s = new ItemStack((ItemLike)this);
            ItemNBTHelper.putString(s, SHADER_NAME_KEY, key.toString());
            out.m_246342_(s);
        }
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        ShaderCase sCase;
        ResourceLocation name = this.getShaderName(stack);
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ShaderRegistry.shaderRegistry.get(name).getCase(new ResourceLocation("immersiveengineering", "item"))) != null) {
            ShaderLayer[] layers = sCase.getLayers();
            if (pass < layers.length && layers[pass] != null) {
                return Utils.intFromRGBA(layers[pass].getColor());
            }
            return -1;
        }
        return -1;
    }
}

