/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.compat;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class RFToolsStorageTOPDriver
implements TOPDriver {
    public static final RFToolsStorageTOPDriver DRIVER = new RFToolsStorageTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = Tools.getId((BlockState)blockState);
        if (!this.drivers.containsKey(id)) {
            if (blockState.m_60734_() == ModularStorageModule.MODULAR_STORAGE.get()) {
                this.drivers.put(id, new ModularStorageDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class ModularStorageDriver
    implements TOPDriver {
        private ModularStorageDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int maxSize = te.getMaxSize();
                if (maxSize == 0) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("No storage module!"));
                } else {
                    int stacks;
                    IItemHandler cardHandler = te.getCardHandler();
                    ItemStack storageModule = cardHandler.getStackInSlot(0);
                    if (!storageModule.m_41619_() && storageModule.m_41783_().m_128441_("display")) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Module: ", (Object)storageModule.m_41786_()));
                    }
                    if ((stacks = te.getNumStacks()) == -1) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Maximum size: ", (Object)maxSize));
                    } else {
                        probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text(stacks + " out of " + maxSize));
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

