/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.SidedBlockPos;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransporterPathfinder {
    private TransporterPathfinder() {
    }

    private static List<Destination> getPaths(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min, Map<Coord4D, Set<TransporterStack>> additionalFlowingStacks) {
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return Collections.emptyList();
        }
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        List<InventoryNetwork.AcceptorData> acceptors = network.calculateAcceptors(request, stack, (Long2ObjectMap<ChunkAccess>)chunkMap, additionalFlowingStacks);
        ArrayList<Destination> paths = new ArrayList<Destination>();
        for (InventoryNetwork.AcceptorData data : acceptors) {
            Destination path = TransporterPathfinder.getPath(network, data, start, stack, min, (Long2ObjectMap<ChunkAccess>)chunkMap);
            if (path == null) continue;
            paths.add(path);
        }
        Collections.sort(paths);
        return paths;
    }

    private static boolean checkPath(InventoryNetwork network, List<BlockPos> path, TransporterStack stack) {
        for (int i = path.size() - 1; i > 0; --i) {
            LogisticalTransporterBase transmitter = network.getTransmitter(path.get(i));
            if (transmitter == null) {
                return false;
            }
            EnumColor color = transmitter.getColor();
            if (color == null || color == stack.color) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Destination getPath(InventoryNetwork network, InventoryNetwork.AcceptorData data, LogisticalTransporterBase start, TransporterStack stack, int min, Long2ObjectMap<ChunkAccess> chunkMap) {
        final TransitRequest.TransitResponse response = data.getResponse();
        if (response.getSendingAmount() >= min) {
            BlockPos dest = data.getLocation();
            PathfinderCache.CachedPath test = PathfinderCache.getCache(start, dest, data.getSides());
            if (test != null && TransporterPathfinder.checkPath(network, test.path(), stack)) {
                return new Destination(test.path(), false, response, test.cost());
            }
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, Direction side, BlockEntity tile) {
                    return TransporterUtils.canInsert(tile, stack.color, response.getStack(), side, false);
                }
            }, network, start.getTileWorld(), dest, start.getTilePos(), stack);
            p.find(chunkMap);
            List<BlockPos> path = p.getPath();
            if (path.size() >= 2) {
                PathfinderCache.addCachedPath(start, new PathfinderCache.PathData(start.getTilePos(), dest, p.getSide()), path, p.finalScore);
                return new Destination(path, false, response, p.finalScore);
            }
        }
        return null;
    }

    @Nullable
    public static Destination getNewBasePath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min) {
        return TransporterPathfinder.getNewBasePath(start, stack, request, min, Collections.emptyMap());
    }

    @Nullable
    public static Destination getNewBasePath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min, Map<Coord4D, Set<TransporterStack>> additionalFlowingStacks) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min, additionalFlowingStacks);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    @Nullable
    public static Destination getNewRRPath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, TileEntityLogisticalSorter outputter, int min) {
        List<Destination> destinations = TransporterPathfinder.getPaths(start, stack, request, min, Collections.emptyMap());
        int destinationCount = destinations.size();
        if (destinationCount == 0) {
            return null;
        }
        if (destinationCount > 1 && outputter.rrTarget != null) {
            for (int i = 0; i < destinationCount; ++i) {
                Destination destination = destinations.get(i);
                List<BlockPos> path = destination.getPath();
                BlockPos pos = path.get(0);
                if (!outputter.rrTarget.pos().equals((Object)pos)) continue;
                Direction sideOfDest = WorldUtils.sideDifference(path.get(1), pos);
                if (outputter.rrTarget.side() != sideOfDest) continue;
                outputter.rrTarget = i == destinationCount - 1 ? SidedBlockPos.get(destinations.get(0)) : SidedBlockPos.get(destinations.get(i + 1));
                return destination;
            }
        }
        Destination destination = destinations.get(0);
        outputter.rrTarget = destinationCount > 1 ? SidedBlockPos.get(destinations.get(1)) : SidedBlockPos.get(destination);
        return destination;
    }

    @Nullable
    public static IdlePathData getIdlePath(LogisticalTransporterBase start, TransporterStack stack) {
        IdlePath d;
        Destination dest;
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return null;
        }
        if (stack.homeLocation != null) {
            Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, Direction side, BlockEntity tile) {
                    return TransporterUtils.canInsert(tile, stack.color, stack.itemStack, side, true);
                }
            }, network, start.getTileWorld(), stack.homeLocation, start.getTilePos(), stack);
            p.find((Long2ObjectMap<ChunkAccess>)chunkMap);
            List<BlockPos> path = p.getPath();
            if (path.size() >= 2) {
                return new IdlePathData(path, TransporterStack.Path.HOME);
            }
            stack.homeLocation = null;
        }
        if ((dest = (d = new IdlePath(network, start.getTilePos(), stack)).find()) == null) {
            return null;
        }
        return new IdlePathData(dest.getPath(), dest.getPathType());
    }

    public static class Destination
    implements Comparable<Destination> {
        private final TransitRequest.TransitResponse response;
        private final List<BlockPos> path;
        private final double score;
        private TransporterStack.Path pathType;

        public Destination(List<BlockPos> list, boolean inv, TransitRequest.TransitResponse ret, double gScore) {
            this.path = new ArrayList<BlockPos>(list);
            if (inv) {
                Collections.reverse(this.path);
            }
            this.response = ret;
            this.score = gScore;
        }

        public Destination setPathType(TransporterStack.Path type) {
            this.pathType = type;
            return this;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.path.hashCode();
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Destination)) return false;
            Destination other = (Destination)o;
            if (!other.path.equals(this.path)) return false;
            return true;
        }

        @Override
        public int compareTo(@NotNull Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return this.path.size() - dest.path.size();
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public TransporterStack.Path getPathType() {
            return this.pathType;
        }

        public List<BlockPos> getPath() {
            return this.path;
        }
    }

    public static class Pathfinder {
        private final Set<BlockPos> openSet = new ObjectOpenHashSet();
        private final Set<BlockPos> closedSet = new ObjectOpenHashSet();
        private final Map<BlockPos, BlockPos> navMap = new Object2ObjectOpenHashMap();
        private final Object2DoubleOpenHashMap<BlockPos> gScore = new Object2DoubleOpenHashMap();
        private final Object2DoubleOpenHashMap<BlockPos> fScore = new Object2DoubleOpenHashMap();
        private final InventoryNetwork network;
        private final BlockPos start;
        private final BlockPos finalNode;
        private final TransporterStack transportStack;
        private final DestChecker destChecker;
        private final Level world;
        private double finalScore;
        private Direction side;
        private List<BlockPos> results = new ArrayList<BlockPos>();

        public Pathfinder(DestChecker checker, InventoryNetwork network, Level world, BlockPos finalNode, BlockPos start, TransporterStack stack) {
            this.destChecker = checker;
            this.network = network;
            this.world = world;
            this.finalNode = finalNode;
            this.start = start;
            this.transportStack = stack;
        }

        public boolean find(Long2ObjectMap<ChunkAccess> chunkMap) {
            this.openSet.add(this.start);
            this.gScore.put((Object)this.start, 0.0);
            double totalDistance = WorldUtils.distanceBetween(this.start, this.finalNode);
            this.fScore.put((Object)this.start, totalDistance);
            boolean hasValidDirection = false;
            LogisticalTransporterBase startTransmitter = this.network.getTransmitter(this.start);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                BlockPos neighbor = this.start.m_121945_(direction);
                LogisticalTransporterBase neighborTransmitter = this.network.getTransmitter(neighbor);
                if (this.transportStack.canInsertToTransporter(neighborTransmitter, direction, startTransmitter)) {
                    hasValidDirection = true;
                    break;
                }
                if (!this.isValidDestination(this.start, startTransmitter, direction, neighbor, chunkMap)) continue;
                return true;
            }
            if (!hasValidDirection) {
                return false;
            }
            double maxSearchDistance = Math.max(2.0 * totalDistance, 4.0);
            while (!this.openSet.isEmpty()) {
                BlockPos currentNode = null;
                double lowestFScore = 0.0;
                for (BlockPos node : this.openSet) {
                    if (currentNode != null && !(this.fScore.getDouble((Object)node) < lowestFScore)) continue;
                    currentNode = node;
                    lowestFScore = this.fScore.getDouble((Object)node);
                }
                if (currentNode == null) break;
                this.openSet.remove(currentNode);
                this.closedSet.add(currentNode);
                if (WorldUtils.distanceBetween(this.start, currentNode) > maxSearchDistance) continue;
                LogisticalTransporterBase currentNodeTransmitter = this.network.getTransmitter(currentNode);
                double currentScore = this.gScore.getDouble((Object)currentNode);
                for (Direction direction : EnumUtils.DIRECTIONS) {
                    BlockPos neighbor = currentNode.m_121945_(direction);
                    LogisticalTransporterBase neighborTransmitter = this.network.getTransmitter(neighbor);
                    if (this.transportStack.canInsertToTransporter(neighborTransmitter, direction, currentNodeTransmitter)) {
                        double tentativeG = currentScore + neighborTransmitter.getCost();
                        if (this.closedSet.contains(neighbor) && tentativeG >= this.gScore.getDouble((Object)neighbor) || this.openSet.contains(neighbor) && !(tentativeG < this.gScore.getDouble((Object)neighbor))) continue;
                        this.navMap.put(neighbor, currentNode);
                        this.gScore.put((Object)neighbor, tentativeG);
                        this.fScore.put((Object)neighbor, tentativeG + WorldUtils.distanceBetween(neighbor, this.finalNode));
                        this.openSet.add(neighbor);
                        continue;
                    }
                    if (!this.isValidDestination(currentNode, currentNodeTransmitter, direction, neighbor, chunkMap)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isValidDestination(BlockPos start, @Nullable LogisticalTransporterBase startTransporter, Direction direction, BlockPos neighbor, Long2ObjectMap<ChunkAccess> chunkMap) {
            BlockEntity neighborTile;
            if (startTransporter != null && neighbor.equals((Object)this.finalNode) && (neighborTile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, neighbor)) != null && this.destChecker.isValid(this.transportStack, direction, neighborTile) && (startTransporter.canEmitTo(direction) || this.finalNode.equals((Object)this.transportStack.homeLocation) && startTransporter.canConnect(direction))) {
                this.side = direction;
                this.results = this.reconstructPath(this.navMap, start);
                this.finalScore = this.gScore.getDouble((Object)start) + WorldUtils.distanceBetween(start, this.finalNode);
                return true;
            }
            return false;
        }

        private List<BlockPos> reconstructPath(Map<BlockPos, BlockPos> navMap, BlockPos nextNode) {
            ArrayList<BlockPos> path = new ArrayList<BlockPos>();
            while (nextNode != null) {
                path.add(nextNode);
                nextNode = navMap.get(nextNode);
            }
            return path;
        }

        public List<BlockPos> getPath() {
            ArrayList<BlockPos> path = new ArrayList<BlockPos>();
            path.add(this.finalNode);
            path.addAll(this.results);
            return path;
        }

        public Direction getSide() {
            return this.side;
        }

        public static class DestChecker {
            public boolean isValid(TransporterStack stack, Direction side, BlockEntity tile) {
                return false;
            }
        }
    }

    public record IdlePathData(List<BlockPos> path, TransporterStack.Path type) {
    }

    public static class IdlePath {
        private final InventoryNetwork network;
        private final BlockPos start;
        private final TransporterStack transportStack;

        public IdlePath(InventoryNetwork network, BlockPos start, TransporterStack stack) {
            this.network = network;
            this.start = start;
            this.transportStack = stack;
        }

        public Destination find() {
            Destination newPath;
            ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
            ret.add(this.start);
            LogisticalTransporterBase startTransmitter = this.network.getTransmitter(this.start);
            if (this.transportStack.idleDir == null) {
                return this.getDestination(ret, startTransmitter);
            }
            LogisticalTransporterBase transmitter = this.network.getTransmitter(this.start.m_121945_(this.transportStack.idleDir));
            if (this.transportStack.canInsertToTransporter(transmitter, this.transportStack.idleDir, startTransmitter)) {
                this.loopSide(ret, this.transportStack.idleDir, startTransmitter);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TransitRequest.SimpleTransitRequest request = TransitRequest.simple(this.transportStack.itemStack);
            if (startTransmitter != null && (newPath = TransporterPathfinder.getNewBasePath(startTransmitter, this.transportStack, request, 0)) != null && newPath.getResponse() != null) {
                this.transportStack.idleDir = null;
                newPath.setPathType(TransporterStack.Path.DEST);
                return newPath;
            }
            return this.getDestination(ret, startTransmitter);
        }

        @Nullable
        private Destination getDestination(List<BlockPos> ret, @Nullable LogisticalTransporterBase startTransmitter) {
            Direction newSide = this.findSide(startTransmitter);
            if (newSide == null) {
                if (startTransmitter != null) {
                    Direction sideClosest = this.transportStack.idleDir == null ? this.transportStack.getSide(startTransmitter) : this.transportStack.idleDir;
                    for (Direction side : EnumSet.complementOf(EnumSet.of(sideClosest))) {
                        if (startTransmitter.getConnectionType(side) == ConnectionType.NONE) continue;
                        this.transportStack.idleDir = side;
                        ret.add(this.start.m_121945_(side));
                        return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
                    }
                }
                return null;
            }
            this.transportStack.idleDir = newSide;
            this.loopSide(ret, newSide, startTransmitter);
            return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
        }

        private void loopSide(List<BlockPos> list, Direction side, @Nullable LogisticalTransporterBase startTransmitter) {
            LogisticalTransporterBase lastTransmitter = startTransmitter;
            BlockPos pos = this.start.m_121945_(side);
            LogisticalTransporterBase transmitter = this.network.getTransmitter(pos);
            while (this.transportStack.canInsertToTransporter(transmitter, side, lastTransmitter)) {
                lastTransmitter = transmitter;
                list.add(pos);
                pos = pos.m_121945_(side);
                transmitter = this.network.getTransmitter(pos);
            }
        }

        private Direction findSide(@Nullable LogisticalTransporterBase startTransmitter) {
            if (this.transportStack.idleDir == null) {
                for (Direction side : EnumUtils.DIRECTIONS) {
                    if (!this.canInsertToTransporter(side, startTransmitter)) continue;
                    return side;
                }
            } else {
                Direction opposite = this.transportStack.idleDir.m_122424_();
                for (Direction side : EnumSet.complementOf(EnumSet.of(opposite))) {
                    if (!this.canInsertToTransporter(side, startTransmitter)) continue;
                    return side;
                }
                if (this.canInsertToTransporter(opposite, startTransmitter)) {
                    return opposite;
                }
            }
            return null;
        }

        private boolean canInsertToTransporter(Direction from, @Nullable LogisticalTransporterBase startTransmitter) {
            return this.transportStack.canInsertToTransporter(this.network.getTransmitter(this.start.m_121945_(from)), from, startTransmitter);
        }
    }
}

