/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.joml.Matrix4f;

public class QuadTransformer {
    private static void processVertices(Matrix4f transform, VertexFormat fmt, int positionIndex, int[] inData, int[] outData) {
        int positionOffset = fmt.getOffset(positionIndex);
        int stride = fmt.m_86020_() / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = positionOffset + i * stride;
            float x = Float.intBitsToFloat(inData[offset]);
            float y = Float.intBitsToFloat(inData[offset + 1]);
            float f = Float.intBitsToFloat(inData[offset + 2]);
        }
    }

    private static int findPositionIndex(VertexFormat fmt) {
        int positionIndex;
        VertexFormatElement positionElement = null;
        ImmutableList list = fmt.m_86023_().asList();
        for (positionIndex = 0; positionIndex < list.size(); ++positionIndex) {
            VertexFormatElement el = (VertexFormatElement)list.get(positionIndex);
            if (el.m_86048_() != VertexFormatElement.Usage.POSITION) continue;
            positionElement = el;
            break;
        }
        if (positionIndex == list.size() || positionElement == null) {
            throw new RuntimeException("WAT? Position not found");
        }
        if (positionElement.m_86041_() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("WAT? Position not FLOAT");
        }
        if (positionElement.m_86050_() < 3) {
            throw new RuntimeException("WAT? Position not 3D");
        }
        return positionIndex;
    }

    public static BakedQuad processOne(BakedQuad input, Matrix4f transform) {
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        int[] data = input.m_111303_();
        QuadTransformer.processVertices(transform, fmt, positionIndex, data, data);
        return new BakedQuad(data, input.m_111305_(), input.m_111306_(), input.m_173410_(), input.m_111307_());
    }

    public static List<BakedQuad> processMany(List<BakedQuad> inputs, Matrix4f transform) {
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        ArrayList outputs = Lists.newArrayList();
        for (BakedQuad input : inputs) {
            int[] inData = input.m_111303_();
            int[] outData = Arrays.copyOf(inData, inData.length);
            QuadTransformer.processVertices(transform, fmt, positionIndex, inData, outData);
            outputs.add(new BakedQuad(outData, input.m_111305_(), input.m_111306_(), input.m_173410_(), input.m_111307_()));
        }
        return outputs;
    }

    public static void processManyInPlace(List<BakedQuad> inputs, Matrix4f transform) {
        if (inputs.isEmpty()) {
            return;
        }
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        for (BakedQuad input : inputs) {
            int[] data = input.m_111303_();
            QuadTransformer.processVertices(transform, fmt, positionIndex, data, data);
        }
    }
}

