/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import mcjty.lib.varia.Tools;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseLootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<EntityType<?>, LootTable.Builder> entityLootTables = new HashMap();
    protected final Map<ResourceLocation, LootTable.Builder> chestLootTables = new HashMap<ResourceLocation, LootTable.Builder>();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();

    public void addLootTable(Block block, LootTable.Builder builder) {
        this.lootTables.put(block, builder);
    }

    public void addItemDropTable(EntityType<?> entityType, ItemLike item) {
        this.entityLootTables.put(entityType, this.createItemDropTable(Tools.getId(entityType).m_135815_(), item));
    }

    public void addChestLootTable(ResourceLocation id, LootTable.Builder builder) {
        this.chestLootTables.put(id, builder);
    }

    public void addItemDropTable(EntityType<?> entityType, ItemLike item, float min, float max, float lmin, float lmax) {
        this.entityLootTables.put(entityType, this.createItemDropTable(Tools.getId(entityType).m_135815_(), item, min, max, lmin, lmax));
    }

    public LootTable.Builder createItemDropTable(String name, ItemLike item) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item));
        return LootTable.m_79147_().m_79161_(builder);
    }

    public LootTable.Builder createItemDropTable(String name, ItemLike item, float min, float max, float lmin, float lmax) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)lmin, (float)lmax))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    public LootTable.Builder createSilkTouchTable(String name, Block block, Item lootItem, float min, float max) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)lootItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected void addBlockStateTable(Block block, Property<?> property) {
        this.lootTables.put(block, this.createBlockStateTable(Tools.getId(block).m_135815_(), block, property));
    }

    protected LootTable.Builder createBlockStateTable(String name, Block block, Property<?> property) {
        LootPool.Builder builder = LootPool.m_79043_().name(Tools.getId(block).m_135815_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyBlockState.m_80062_((Block)block).m_80084_(property)));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected void addStandardTable(Block block, BlockEntityType<?> type) {
        this.lootTables.put(block, this.createStandardTable(Tools.getId(block).m_135815_(), block, type));
    }

    protected LootTable.Builder createStandardTable(String name, Block block, BlockEntityType<?> type) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Info", "BlockEntityTag.Info", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("Items", "BlockEntityTag.McItems", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE)).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(type).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected void addSimpleTable(Block block) {
        this.lootTables.put(block, this.createSimpleTable(Tools.getId(block).m_135815_(), block));
    }

    protected LootTable.Builder createSimpleTable(String name, Block block) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSimpleTable(String name, Item item) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item));
        return LootTable.m_79147_().m_79161_(builder);
    }

    public void generate(BiConsumer<ResourceLocation, LootTable.Builder> builder, LootContextParamSet paramSet) {
        if (paramSet == LootContextParamSets.f_81421_) {
            for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
                builder.accept(entry.getKey().m_60589_(), entry.getValue().m_79165_(LootContextParamSets.f_81421_));
            }
        }
        if (paramSet == LootContextParamSets.f_81415_) {
            for (Map.Entry<Block, LootTable.Builder> entry : this.entityLootTables.entrySet()) {
                builder.accept(((EntityType)entry.getKey()).m_20677_(), entry.getValue().m_79165_(LootContextParamSets.f_81415_));
            }
        }
        if (paramSet == LootContextParamSets.f_81411_) {
            for (Map.Entry<Block, LootTable.Builder> entry : this.chestLootTables.entrySet()) {
                ResourceLocation id = (ResourceLocation)entry.getKey();
                builder.accept(id, entry.getValue().m_79165_(LootContextParamSets.f_81411_));
            }
        }
    }
}

