/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.icons;

import java.util.Optional;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.icons.IIcon;
import mcjty.lib.gui.widgets.IconHolder;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class IconManager {
    private final WindowManager windowManager;
    private IIcon draggingIcon;
    private IconHolder origin;
    private int dx;
    private int dy;
    private boolean clickHoldToDrag = false;

    public IconManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public void startDragging(IIcon icon, IconHolder origin, int iconX, int iconY) {
        this.draggingIcon = icon;
        this.origin = origin;
        this.dx = iconX - 2;
        this.dy = iconY - 1;
    }

    public boolean isClickHoldToDrag() {
        return this.clickHoldToDrag;
    }

    public void setClickHoldToDrag(boolean clickHoldToDrag) {
        this.clickHoldToDrag = clickHoldToDrag;
    }

    public void cancelDragging() {
        if (this.draggingIcon == null) {
            return;
        }
        if (this.origin != null) {
            this.origin.setIcon(this.draggingIcon);
        }
        this.draggingIcon = null;
        this.origin = null;
    }

    public void stopDragging(double x, double y) {
        if (this.draggingIcon == null) {
            return;
        }
        IconHolder iconHolder = this.findClosestIconHolder(x, y);
        if (iconHolder == null || iconHolder.getIcon() != null) {
            if (this.origin != null) {
                this.origin.setIcon(this.draggingIcon);
            }
        } else if (!iconHolder.setIcon(this.draggingIcon)) {
            if (this.origin != null) {
                this.origin.setIcon(this.draggingIcon);
            }
        } else if (iconHolder.isSelectable()) {
            this.windowManager.setFocus(iconHolder);
        }
        this.draggingIcon = null;
        this.origin = null;
    }

    private IconHolder findClosestIconHolder(double x, double y) {
        Optional<Widget<?>> widget = this.windowManager.findWidgetAtPosition(x, y);
        if (widget.isPresent() && widget.get() instanceof IconHolder) {
            return (IconHolder)widget.get();
        }
        return null;
    }

    public boolean isDragging() {
        return this.draggingIcon != null;
    }

    public void draw(Screen gui, GuiGraphics graphics) {
        if (this.draggingIcon != null) {
            this.draggingIcon.draw(gui, graphics, this.getRelativeX() - this.dx, this.getRelativeY() - this.dy);
        }
    }

    private int getRelativeX() {
        Screen gui = this.windowManager.getGui();
        int width = gui.getMinecraft().m_91268_().m_85443_();
        if (width <= 0) {
            return 0;
        }
        return (int)gui.getMinecraft().f_91067_.m_91589_() * gui.f_96543_ / width;
    }

    private int getRelativeY() {
        Screen gui = this.windowManager.getGui();
        int height = gui.getMinecraft().m_91268_().m_85444_();
        if (height <= 0) {
            return 0;
        }
        return (int)gui.getMinecraft().f_91067_.m_91594_() * gui.f_96544_ / height;
    }
}

