/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.event.Compute;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ModeLoader {
    @Nullable
    private static LightyMode mode = null;
    private static boolean enabled = false;
    private static final HashMap<ResourceLocation, LightyMode> MODES = new HashMap();

    public static void loadMode(ResourceLocation id) {
        LightyMode modeToLoad = MODES.get(id);
        if (modeToLoad == null) {
            Lighty.LOGGER.error("Trying to load unregistered mode with id {}! Not changing mode.", (Object)id);
            return;
        }
        mode = modeToLoad;
        Config.setLastUsedMode(id);
        Compute.clear();
        ModeLoader.enable();
    }

    public static void disable() {
        enabled = false;
    }

    public static void enable() {
        enabled = true;
    }

    public static void toggle() {
        enabled = !enabled;
    }

    public static void put(ResourceLocation id, LightyMode mode) {
        MODES.put(id, mode);
    }

    @Nullable
    public static LightyMode getCurrentMode() {
        if (!enabled) {
            return null;
        }
        return mode;
    }

    public static void setLastUsedMode() {
        mode = MODES.getOrDefault(Config.getLastUsedMode(), MODES.values().iterator().next());
    }

    private ModeLoader() {
    }
}

