/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.api;

import dev.schmarrn.lighty.config.Config;

public class LightyColors {
    private static int GREEN = 65280;
    private static int ORANGE = 0xFF6600;
    private static int RED = 0xFF0000;

    public static void onConfigUpdate() {
        GREEN = Config.getOverlayGreen();
        ORANGE = Config.getOverlayOrange();
        RED = Config.getOverlayRed();
    }

    public static int getSafe() {
        return GREEN;
    }

    public static int getSafeARGB() {
        return GREEN | 0xFF000000;
    }

    public static int getWarning() {
        return ORANGE;
    }

    public static int getWarningARGB() {
        return ORANGE | 0xFF000000;
    }

    public static int getDanger() {
        return RED;
    }

    public static int getDangerARGB() {
        return RED | 0xFF000000;
    }

    public static int getARGB(int blockLightLevel, int skyLightLevel) {
        int color = LightyColors.getSafeARGB();
        if (blockLightLevel <= Config.getBlockThreshold()) {
            color = skyLightLevel <= Config.getSkyThreshold() ? LightyColors.getDangerARGB() : LightyColors.getWarningARGB();
        }
        return color;
    }

    private LightyColors() {
    }

    static {
        LightyColors.onConfigUpdate();
    }
}

