/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis;

import guideme.internal.shaded.lucene.analysis.AbstractAnalysisFactory;
import guideme.internal.shaded.lucene.util.ClassLoaderUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;

public final class AnalysisSPILoader<S extends AbstractAnalysisFactory> {
    private volatile Map<String, Class<? extends S>> services = Collections.emptyMap();
    private volatile Set<String> originalNames = Collections.emptySet();
    private final Class<S> clazz;
    private static final Pattern SERVICE_NAME_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]+$");

    public AnalysisSPILoader(Class<S> clazz) {
        this(clazz, null);
    }

    public AnalysisSPILoader(Class<S> clazz, ClassLoader classloader) {
        this.clazz = clazz;
        ClassLoader clazzClassloader = clazz.getClassLoader();
        if (classloader == null) {
            classloader = clazzClassloader;
        }
        if (clazzClassloader != null && !ClassLoaderUtils.isParentClassLoader(clazzClassloader, classloader)) {
            this.reload(clazzClassloader);
        }
        this.reload(classloader);
    }

    public synchronized void reload(ClassLoader classloader) {
        Objects.requireNonNull(classloader, "classloader");
        LinkedHashMap<String, Class<S>> services = new LinkedHashMap<String, Class<S>>(this.services);
        LinkedHashSet<String> originalNames = new LinkedHashSet<String>(this.originalNames);
        ServiceLoader.load(this.clazz, classloader).stream().map(ServiceLoader.Provider::type).forEachOrdered(service -> {
            String name = null;
            String originalName = null;
            Exception cause = null;
            try {
                originalName = AnalysisSPILoader.lookupSPIName(service);
                name = originalName.toLowerCase(Locale.ROOT);
                if (!this.isValidName(originalName)) {
                    throw new ServiceConfigurationError("The name " + originalName + " for " + service.getName() + " is invalid: Allowed characters are (English) alphabet, digits, and underscore. It should be started with an alphabet.");
                }
            }
            catch (IllegalAccessException | IllegalStateException | NoSuchFieldException e) {
                cause = e;
            }
            if (name == null) {
                throw new ServiceConfigurationError("The class name " + service.getName() + " has no service name field: [public static final String NAME]", cause);
            }
            if (!services.containsKey(name)) {
                services.put(name, (Class<S>)service);
                originalNames.add(originalName);
            }
        });
        if (services.keySet().size() != originalNames.size()) {
            throw new ServiceConfigurationError("Service lookup key set is inconsistent with original name set!");
        }
        this.services = Map.copyOf(services);
        this.originalNames = Set.copyOf(originalNames);
    }

    private boolean isValidName(String name) {
        return SERVICE_NAME_PATTERN.matcher(name).matches();
    }

    public S newInstance(String name, Map<String, String> args) {
        Class<S> service = this.lookupClass(name);
        return AnalysisSPILoader.newFactoryClassInstance(service, args);
    }

    public Class<? extends S> lookupClass(String name) {
        Class<? extends S> service = this.services.get(name.toLowerCase(Locale.ROOT));
        if (service != null) {
            return service;
        }
        throw new IllegalArgumentException("A SPI class of type " + this.clazz.getName() + " with name '" + name + "' does not exist. You need to add the corresponding JAR file supporting this SPI to your classpath. The current classpath supports the following names: " + this.availableServices());
    }

    public Set<String> availableServices() {
        return this.originalNames;
    }

    public static String lookupSPIName(Class<? extends AbstractAnalysisFactory> service) throws NoSuchFieldException, IllegalAccessException, IllegalStateException {
        Field field = service.getField("NAME");
        int modifier = field.getModifiers();
        if (Modifier.isStatic(modifier) && Modifier.isFinal(modifier) && Objects.equals(field.getDeclaringClass(), service) && Objects.equals(field.getType(), String.class)) {
            return (String)field.get(null);
        }
        throw new IllegalStateException("No SPI name defined.");
    }

    public static <T extends AbstractAnalysisFactory> T newFactoryClassInstance(Class<T> clazz, Map<String, String> args) {
        try {
            return (T)((AbstractAnalysisFactory)clazz.getConstructor(Map.class).newInstance(args));
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unexpected checked exception while calling constructor of " + clazz.getName(), cause);
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException("Factory " + clazz.getName() + " cannot be instantiated. This is likely due to missing Map<String,String> constructor.", e);
        }
    }
}

